/*
 * Decompiled with CFR 0.152.
 */
package bluej.parser;

import bluej.parser.JavaParser;
import bluej.parser.SourceLocation;
import bluej.parser.SourceSpan;
import bluej.parser.lexer.LocatableToken;
import java.io.Reader;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class UnitTestParser
extends JavaParser {
    private int classLevel = 0;
    private boolean inMethod = false;
    private String methodName;
    private LocatableToken methodBegin;
    private boolean isPublic = false;
    private boolean haveClassInfo = false;
    private List<SourceSpan> fieldSpans = new LinkedList<SourceSpan>();
    private SourceLocation methodInsertLocation;
    private SourceLocation fixtureInsertLocation;
    private Map<String, SourceSpan> methodSpans = new HashMap<String, SourceSpan>();
    private Stack<SourceLocation> fieldStarts = new Stack();

    public UnitTestParser(Reader r) {
        super(r);
        try {
            this.parseCU();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public List<SourceSpan> getFieldSpans() {
        return this.fieldSpans;
    }

    public SourceLocation getNewMethodInsertLocation() {
        return this.methodInsertLocation;
    }

    public SourceLocation getFixtureInsertLocation() {
        return this.fixtureInsertLocation;
    }

    public SourceSpan getMethodBlockSpan(String name) {
        return this.methodSpans.get(name);
    }

    @Override
    protected void error(String msg, int beginLine, int beginColumn, int endLine, int endColumn) {
        throw new RuntimeException("Parse error: " + msg);
    }

    @Override
    protected void gotModifier(LocatableToken token) {
        if (token.getType() == 89) {
            this.isPublic = true;
        }
    }

    @Override
    protected void modifiersConsumed() {
        this.isPublic = false;
    }

    @Override
    protected void gotField(LocatableToken first, LocatableToken idToken) {
        if (this.classLevel == 1 && !this.haveClassInfo) {
            this.fieldStarts.push(new SourceLocation(first.getLine(), first.getColumn()));
        }
    }

    @Override
    protected void endFieldDeclarations(LocatableToken token, boolean included) {
        if (this.classLevel == 1 && !this.haveClassInfo) {
            SourceLocation start = this.fieldStarts.pop();
            SourceLocation end = new SourceLocation(token.getEndLine(), token.getEndColumn());
            SourceSpan ss = new SourceSpan(start, end);
            this.fieldSpans.add(ss);
        }
    }

    @Override
    protected void gotTypeDef(LocatableToken firstToken, int tdType) {
        ++this.classLevel;
        if (this.haveClassInfo && this.isPublic) {
            this.haveClassInfo = false;
            this.fieldSpans = new LinkedList<SourceSpan>();
            this.methodSpans = new HashMap<String, SourceSpan>();
        }
    }

    @Override
    protected void beginTypeBody(LocatableToken leftCurlyToken) {
        if (this.classLevel == 1) {
            this.fixtureInsertLocation = new SourceLocation(leftCurlyToken.getLine(), leftCurlyToken.getColumn());
        }
    }

    @Override
    protected void gotTypeDefEnd(LocatableToken token, boolean included) {
        --this.classLevel;
        this.endElement(token, included);
        if (this.classLevel == 0) {
            this.haveClassInfo = true;
            this.methodInsertLocation = new SourceLocation(token.getLine(), token.getColumn());
        }
    }

    @Override
    protected void gotMethodDeclaration(LocatableToken token, LocatableToken hiddenToken) {
        if (this.classLevel == 1 && !this.haveClassInfo) {
            this.inMethod = true;
            this.methodName = token.getText();
        }
    }

    @Override
    protected void gotMethodParameter(LocatableToken token, LocatableToken ellipsisToken) {
        this.inMethod = false;
    }

    @Override
    protected void beginMethodBody(LocatableToken token) {
        if (this.inMethod) {
            this.methodBegin = token;
        }
    }

    @Override
    protected void endMethodBody(LocatableToken token, boolean included) {
        if (this.classLevel == 1 && !this.haveClassInfo && this.methodBegin != null) {
            SourceLocation start = new SourceLocation(this.methodBegin.getLine(), this.methodBegin.getColumn());
            SourceLocation end = new SourceLocation(token.getEndLine(), token.getEndColumn());
            SourceSpan ss = new SourceSpan(start, end);
            this.methodSpans.put(this.methodName, ss);
        }
    }
}

