/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr;

import bluej.Config;
import bluej.editor.Editor;
import bluej.pkgmgr.ClassDiagramPrinter;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.ProjectPrintDialog;
import bluej.pkgmgr.target.ClassTarget;
import bluej.pkgmgr.target.ReadmeTarget;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.util.List;

public class PackagePrintManager
extends Thread {
    private PageFormat pageFormat;
    private Package pkg;
    private ProjectPrintDialog dialog;

    public PackagePrintManager(Package pkg, PageFormat pageFormat, ProjectPrintDialog dialog) {
        this.pkg = pkg;
        this.pageFormat = pageFormat;
        this.dialog = dialog;
    }

    @Override
    public void run() {
        PrinterJob printer = PrinterJob.getPrinterJob();
        if (printer.printDialog()) {
            if (this.dialog.printDiagram()) {
                this.printClassDiagram(printer);
            }
            if (this.dialog.printSource()) {
                this.printSourceCode(printer);
            }
            if (this.dialog.printReadme()) {
                this.printReadme(printer);
            }
        }
    }

    public void printClassDiagram(PrinterJob printJob) {
        ClassDiagramPrinter diagramPrinter = new ClassDiagramPrinter(printJob, this.pkg, this.pageFormat);
        this.pkg.setStatus(Config.getString("pkgmgr.info.printing"));
        diagramPrinter.printPackage();
    }

    public void printSourceCode(PrinterJob printJob) {
        List<String> classes = this.pkg.getAllClassnamesWithSource();
        for (String className : classes) {
            ClassTarget target = (ClassTarget)this.pkg.getTarget(className);
            Editor editor = target.getEditor();
            editor.print(printJob);
        }
    }

    public void printReadme(PrinterJob printJob) {
        ReadmeTarget readme = this.pkg.getReadmeTarget();
        if (readme != null) {
            readme.getEditor().print(printJob);
        }
    }
}

