/*
 * Decompiled with CFR 0.152.
 */
package bluej.doclet.doclets.formats.html;

import bluej.doclet.doclets.formats.html.AbstractMemberWriter;
import bluej.doclet.doclets.formats.html.AnnotationTypeOptionalMemberWriterImpl;
import bluej.doclet.doclets.formats.html.ConfigurationImpl;
import bluej.doclet.doclets.formats.html.ConstructorWriterImpl;
import bluej.doclet.doclets.formats.html.EnumConstantWriterImpl;
import bluej.doclet.doclets.formats.html.FieldWriterImpl;
import bluej.doclet.doclets.formats.html.MethodWriterImpl;
import bluej.doclet.doclets.formats.html.NestedClassWriterImpl;
import bluej.doclet.doclets.formats.html.SubWriterHolderWriter;
import bluej.doclet.doclets.internal.toolkit.util.DeprecatedAPIListBuilder;
import bluej.doclet.doclets.internal.toolkit.util.DocletAbortException;
import java.io.IOException;

public class DeprecatedListWriter
extends SubWriterHolderWriter {
    private static final String[] ANCHORS = new String[]{"interface", "class", "enum", "exception", "error", "annotation_type", "field", "method", "constructor", "enum_constant", "annotation_type_member"};
    private static final String[] HEADING_KEYS = new String[]{"doclet.Deprecated_Interfaces", "doclet.Deprecated_Classes", "doclet.Deprecated_Enums", "doclet.Deprecated_Exceptions", "doclet.Deprecated_Errors", "doclet.Deprecated_Annotation_Types", "doclet.Deprecated_Fields", "doclet.Deprecated_Methods", "doclet.Deprecated_Constructors", "doclet.Deprecated_Enum_Constants", "doclet.Deprecated_Annotation_Type_Members"};
    private AbstractMemberWriter[] writers;
    private ConfigurationImpl configuration;

    public DeprecatedListWriter(ConfigurationImpl configuration, String filename) throws IOException {
        super(configuration, filename);
        this.configuration = configuration;
        NestedClassWriterImpl classW = new NestedClassWriterImpl(this);
        this.writers = new AbstractMemberWriter[]{classW, classW, classW, classW, classW, classW, new FieldWriterImpl(this), new MethodWriterImpl(this), new ConstructorWriterImpl(this), new EnumConstantWriterImpl(this), new AnnotationTypeOptionalMemberWriterImpl((SubWriterHolderWriter)this, null)};
    }

    public static void generate(ConfigurationImpl configuration) {
        String filename = "deprecated-list.html";
        try {
            DeprecatedListWriter depr = new DeprecatedListWriter(configuration, filename);
            depr.generateDeprecatedListFile(new DeprecatedAPIListBuilder(configuration.root));
            depr.close();
        }
        catch (IOException exc) {
            configuration.standardmessage.error("doclet.exception_encountered", exc.toString(), filename);
            throw new DocletAbortException();
        }
    }

    protected void generateDeprecatedListFile(DeprecatedAPIListBuilder deprapi) throws IOException {
        int i;
        this.writeHeader();
        this.bold(this.configuration.getText("doclet.Contents"));
        this.ul();
        for (i = 0; i < 11; ++i) {
            this.writeIndexLink(deprapi, i);
        }
        this.ulEnd();
        this.println();
        for (i = 0; i < 11; ++i) {
            if (!deprapi.hasDocumentation(i)) continue;
            this.writeAnchor(deprapi, i);
            this.writers[i].printDeprecatedAPI(deprapi.getList(i), HEADING_KEYS[i]);
        }
        this.printDeprecatedFooter();
    }

    private void writeIndexLink(DeprecatedAPIListBuilder builder, int type) {
        if (builder.hasDocumentation(type)) {
            this.li();
            this.printHyperLink("#" + ANCHORS[type], this.configuration.getText(HEADING_KEYS[type]));
            this.println();
        }
    }

    private void writeAnchor(DeprecatedAPIListBuilder builder, int type) {
        if (builder.hasDocumentation(type)) {
            this.anchor(ANCHORS[type]);
        }
    }

    protected void writeHeader() {
        this.printHtmlHeader(this.configuration.getText("doclet.Window_Deprecated_List"), null, true);
        this.printTop();
        this.navLinks(true);
        this.hr();
        this.center();
        this.h2();
        this.boldText("doclet.Deprecated_API");
        this.h2End();
        this.centerEnd();
        this.hr(4, "noshade");
    }

    protected void printDeprecatedFooter() {
        this.hr();
        this.navLinks(false);
        this.printBottom();
        this.printBodyHtmlEnd();
    }

    @Override
    protected void navLinkDeprecated() {
        this.navCellRevStart();
        this.fontStyle("NavBarFont1Rev");
        this.boldText("doclet.navDeprecated");
        this.fontEnd();
        this.navCellEnd();
    }
}

