/*
 * Decompiled with CFR 0.152.
 */
package bluej.parser;

import bluej.debugger.gentype.GenTypeClass;
import bluej.debugger.gentype.GenTypeSolid;
import bluej.debugger.gentype.MethodReflective;
import bluej.debugger.gentype.Reflective;
import bluej.parser.TextParser;
import bluej.parser.entity.EntityResolver;
import bluej.parser.entity.JavaEntity;
import bluej.parser.lexer.LocatableToken;
import java.io.Reader;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class CompletionParser
extends TextParser {
    private Map<String, Set<MethodReflective>> methodSuggestions = Collections.emptyMap();
    private JavaEntity suggestionEntity;
    private LocatableToken suggestionToken;
    private boolean staticRestricted = false;

    public CompletionParser(EntityResolver resolver, Reader reader, JavaEntity defaultEnt) {
        super(resolver, reader, defaultEnt, false);
        this.suggestionEntity = defaultEnt;
    }

    public CompletionParser(EntityResolver resolver, Reader reader, JavaEntity defaultEnt, int line, int col, int pos) {
        super(resolver, reader, defaultEnt, false, line, col, pos);
        this.suggestionEntity = defaultEnt;
    }

    @Override
    protected void error(String msg, int beginLine, int beginCol, int endLine, int endCol) {
    }

    public Map<String, Set<MethodReflective>> getMethodSuggestions() {
        if (this.methodSuggestions == null) {
            this.suggestFor(this.getSuggestionType());
        }
        return this.methodSuggestions;
    }

    public GenTypeSolid getSuggestionType() {
        if (this.suggestionEntity != null) {
            JavaEntity valEnt = this.suggestionEntity.resolveAsValue();
            if (valEnt != null) {
                return valEnt.getType().asSolid();
            }
            valEnt = this.suggestionEntity.resolveAsType();
            if (valEnt != null) {
                this.setStatic(true);
                return valEnt.getType().asSolid();
            }
        }
        return null;
    }

    public LocatableToken getSuggestionToken() {
        return this.suggestionToken;
    }

    @Override
    protected void gotDotEOF(LocatableToken token) {
        this.suggestionEntity = this.popValueStack();
    }

    @Override
    protected void gotIdentifierEOF(LocatableToken token) {
        this.suggestionToken = token;
    }

    @Override
    protected void gotMemberAccessEOF(LocatableToken token) {
        this.suggestionToken = token;
        this.suggestionEntity = this.popValueStack();
    }

    @Override
    protected void completeCompoundValueEOF(LocatableToken token) {
        this.suggestionToken = token;
        this.suggestionEntity = this.popValueStack();
    }

    private void suggestFor(GenTypeSolid type) {
        GenTypeClass ctype;
        if (type != null && (ctype = type.asClass()) != null) {
            Reflective r = ctype.getReflective();
            this.methodSuggestions = r.getDeclaredMethods();
        }
    }

    public boolean isSuggestionStatic() {
        return this.staticRestricted;
    }

    protected void setStatic(boolean restricted) {
        this.staticRestricted = restricted;
    }
}

