/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr;

import bluej.BlueJTheme;
import bluej.Config;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.pkgmgr.Project;
import bluej.prefmgr.PrefMgr;
import bluej.prefmgr.PrefMgrDialog;
import bluej.utility.Debug;
import bluej.utility.DialogManager;
import bluej.utility.EscapeDialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;

class ExportDialog
extends EscapeDialog {
    private static final String dialogTitle = Config.getString("pkgmgr.export.title");
    private static final String helpLine1 = Config.getString("pkgmgr.export.helpLine1");
    private static final String helpLine2 = Config.getString("pkgmgr.export.helpLine2");
    private static final String classLabelText = Config.getString("pkgmgr.export.classLabel");
    private static final String libsLabel = Config.getString("pkgmgr.export.includeLibs");
    private static final String sourceLabel = Config.getString("pkgmgr.export.sourceLabel");
    private static final String pkgFilesLabel = Config.getString("pkgmgr.export.pkgFilesLabel");
    private static final String noClassText = Config.getString("pkgmgr.export.noClassText");
    private String mainClassName = "";
    private JComboBox classSelect;
    private JCheckBox sourceBox;
    private JCheckBox pkgFilesBox;
    private UserLibInfo[] userLibs;
    private boolean ok;
    private JPanel userLibPanel;

    public ExportDialog(PkgMgrFrame parent) {
        super(parent, dialogTitle, true);
        this.makeDialog(parent.getProject());
    }

    public void updateDialog(PkgMgrFrame parent) {
        Project project = parent.getProject();
        this.fillClassPopup(project);
        this.fillUserLibPanel(project, this.getSelectedLibs());
        String sel = this.mainClassName;
        if (sel.equals("")) {
            sel = noClassText;
        }
        this.classSelect.setSelectedItem(sel);
    }

    public boolean display() {
        this.ok = false;
        this.setVisible(true);
        return this.ok;
    }

    public String getMainClass() {
        return this.mainClassName;
    }

    public List<File> getSelectedLibs() {
        ArrayList<File> selected = new ArrayList<File>();
        if (this.userLibs != null) {
            for (int i = 0; i < this.userLibs.length; ++i) {
                if (!this.userLibs[i].isSelected()) continue;
                selected.add(this.userLibs[i].getFile());
            }
        }
        return selected;
    }

    public boolean includeSource() {
        return this.sourceBox.isSelected();
    }

    public boolean includePkgFiles() {
        return this.pkgFilesBox.isSelected();
    }

    private void doOK() {
        this.mainClassName = (String)this.classSelect.getSelectedItem();
        if (this.mainClassName.equals(noClassText)) {
            this.mainClassName = "";
        }
        this.ok = true;
        this.setVisible(false);
    }

    private void doCancel() {
        this.ok = false;
        this.setVisible(false);
    }

    private void makeDialog(Project project) {
        this.setDefaultCloseOperation(2);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.setBorder(BlueJTheme.dialogBorder);
        JLabel helpText1 = new JLabel(helpLine1);
        mainPanel.add(helpText1);
        JLabel helpText2 = new JLabel(helpLine2);
        mainPanel.add(helpText2);
        Font smallFont = helpText1.getFont().deriveFont(2, 11.0f);
        helpText1.setFont(smallFont);
        helpText2.setFont(smallFont);
        mainPanel.add(Box.createVerticalStrut(5));
        mainPanel.add(new JSeparator());
        mainPanel.add(Box.createVerticalStrut(5));
        JPanel inputPanel = new JPanel();
        inputPanel.setLayout(new BoxLayout(inputPanel, 1));
        inputPanel.setAlignmentX(0.0f);
        JPanel mainClassPanel = new JPanel();
        JLabel classLabel = new JLabel(classLabelText);
        mainClassPanel.add(classLabel);
        this.createClassPopup();
        this.fillClassPopup(project);
        mainClassPanel.add(this.classSelect);
        mainClassPanel.setAlignmentX(0.0f);
        inputPanel.add(mainClassPanel);
        inputPanel.add(Box.createVerticalStrut(5));
        this.createUserLibPanel();
        this.fillUserLibPanel(project, null);
        this.userLibPanel.setAlignmentX(0.0f);
        inputPanel.add(this.userLibPanel);
        inputPanel.add(Box.createVerticalStrut(5));
        this.sourceBox = new JCheckBox(sourceLabel, false);
        this.sourceBox.setAlignmentX(0.0f);
        inputPanel.add(this.sourceBox);
        inputPanel.add(Box.createVerticalStrut(5));
        this.pkgFilesBox = new JCheckBox(pkgFilesLabel);
        inputPanel.add(this.pkgFilesBox);
        mainPanel.add(inputPanel);
        mainPanel.add(Box.createVerticalStrut(17));
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        buttonPanel.setAlignmentX(0.0f);
        JButton continueButton = BlueJTheme.getContinueButton();
        continueButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportDialog.this.doOK();
            }
        });
        JButton cancelButton = BlueJTheme.getCancelButton();
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportDialog.this.doCancel();
            }
        });
        DialogManager.addOKCancelButtons(buttonPanel, continueButton, cancelButton);
        this.getRootPane().setDefaultButton(continueButton);
        mainPanel.add(buttonPanel);
        this.getContentPane().add(mainPanel);
        this.pack();
        DialogManager.centreDialog(this);
    }

    private void createClassPopup() {
        this.classSelect = new JComboBox();
        this.classSelect.setFont(PrefMgr.getPopupMenuFont());
    }

    private void fillClassPopup(Project project) {
        this.classSelect.removeAllItems();
        this.classSelect.addItem(noClassText);
        List<String> packageNames = project.getPackageNames();
        Collections.sort(packageNames);
        for (String pkgName : packageNames) {
            Iterator<String> classes;
            List<String> classNames = project.getPackage(pkgName).getAllClassnames();
            Collections.sort(classNames);
            if (pkgName.length() > 0) {
                classes = classNames.iterator();
                while (classes.hasNext()) {
                    this.classSelect.addItem(pkgName + "." + classes.next());
                }
                continue;
            }
            classes = classNames.iterator();
            while (classes.hasNext()) {
                this.classSelect.addItem(classes.next());
            }
        }
    }

    private void fillUserLibPanel(Project project, List<File> startChecked) {
        this.userLibPanel.removeAll();
        ArrayList<UserLibInfo> userlibList = new ArrayList<UserLibInfo>();
        ArrayList<URL> libList = PrefMgrDialog.getInstance().getUserConfigLibPanel().getUserConfigContent();
        libList.addAll(Project.getUserlibContent());
        for (URL url : libList) {
            try {
                File file = new File(new URI(url.toString()));
                if (file == null || file.isDirectory()) continue;
                boolean shouldBeChecked = startChecked != null && startChecked.contains(file);
                userlibList.add(new UserLibInfo(file, shouldBeChecked));
            }
            catch (URISyntaxException use) {
                Debug.reportError("ExportDialog.createUserLibPanel(Project) invalid url=" + url.getPath());
            }
        }
        if (userlibList.size() < 1) {
            this.userLibPanel.setVisible(false);
        } else {
            this.userLibPanel.setVisible(true);
            this.userLibs = userlibList.toArray(new UserLibInfo[userlibList.size()]);
            for (int i = 0; i < this.userLibs.length; ++i) {
                this.userLibPanel.add(this.userLibs[i].getCheckBox());
            }
        }
    }

    private void createUserLibPanel() {
        this.userLibPanel = new JPanel(new GridLayout(0, 2));
        this.userLibPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(libsLabel), BorderFactory.createEmptyBorder(5, 10, 5, 10)));
    }

    class UserLibInfo {
        private File sourceFile;
        private JCheckBox checkBox;

        public UserLibInfo(File source, boolean selected) {
            this.sourceFile = source;
            this.checkBox = new JCheckBox(this.sourceFile.getName(), selected);
        }

        public JCheckBox getCheckBox() {
            return this.checkBox;
        }

        public File getFile() {
            return this.sourceFile;
        }

        public boolean isSelected() {
            return this.checkBox.isSelected();
        }
    }
}

