/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr;

import bluej.BlueJTheme;
import bluej.Config;
import bluej.pkgmgr.AppletParam;
import bluej.utility.DialogManager;
import bluej.utility.EscapeDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class RunAppletDialog
extends EscapeDialog
implements ListSelectionListener {
    static final String createWebPage = Config.getString("pkgmgr.runApplet.webPageLabel");
    static final String radioButtonText1 = Config.getString("pkgmgr.runApplet.webPage");
    static final String radioButtonText2 = Config.getString("pkgmgr.runApplet.appletviewer");
    static final String radioButtonText3 = Config.getString("pkgmgr.runApplet.webBrowser");
    static final String heightLbl = Config.getString("pkgmgr.runApplet.heightLbl");
    static final String widthLbl = Config.getString("pkgmgr.runApplet.widthLbl");
    static final String newParameterLbl = Config.getString("pkgmgr.runApplet.newParameterLbl");
    static final String appletParameterLbl = Config.getString("pkgmgr.runApplet.appletParameterLbl");
    static final String nameLbl = Config.getString("pkgmgr.runApplet.nameLbl");
    static final String valueLbl = Config.getString("pkgmgr.runApplet.valueLbl");
    public static final int EXEC_APPLETVIEWER = 0;
    public static final int EXEC_WEBBROWSER = 1;
    public static final int GENERATE_PAGE_ONLY = 2;
    private String webPageName;
    private JList parameterList;
    private DefaultListModel appletParameters;
    private JTextField paramNameField;
    private JTextField paramValueField;
    private JTextField heightField;
    private JTextField widthField;
    private JButton addButton;
    private JButton deleteButton;
    private JFrame parent;
    private JRadioButton generateWebPage;
    private JRadioButton runAppletViewer;
    private JRadioButton runWebBrowser;
    private boolean ok;

    public RunAppletDialog(JFrame parent, String appletClassName) {
        super(parent, Config.getString("pkgmgr.runApplet.title"), true);
        this.parent = parent;
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent E) {
                RunAppletDialog.this.ok = false;
                RunAppletDialog.this.setVisible(false);
            }
        });
        JPanel mainPanel = (JPanel)this.getContentPane();
        mainPanel.setBorder(BlueJTheme.dialogBorder);
        this.appletParameters = new DefaultListModel();
        this.webPageName = appletClassName + ".html";
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout());
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JButton button = BlueJTheme.getOkButton();
        buttonPanel.add(button);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RunAppletDialog.this.doOK();
            }
        });
        this.getRootPane().setDefaultButton(button);
        button = BlueJTheme.getCancelButton();
        buttonPanel.add(button);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RunAppletDialog.this.doCancel();
            }
        });
        this.getContentPane().add("South", buttonPanel);
        GridBagLayout gridBag = new GridBagLayout();
        GridBagConstraints gridConstraints = new GridBagConstraints();
        gridConstraints.insets = new Insets(5, 5, 5, 5);
        JPanel webPanel = new JPanel();
        ButtonGroup bGroup = new ButtonGroup();
        JPanel radioPanel = new JPanel();
        radioPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        radioPanel.setLayout(new GridLayout(3, 1));
        this.generateWebPage = new JRadioButton(radioButtonText1, false);
        radioPanel.add(this.generateWebPage);
        bGroup.add(this.generateWebPage);
        this.runAppletViewer = new JRadioButton(radioButtonText2, true);
        radioPanel.add(this.runAppletViewer);
        bGroup.add(this.runAppletViewer);
        this.runWebBrowser = new JRadioButton(radioButtonText3, false);
        radioPanel.add(this.runWebBrowser);
        bGroup.add(this.runWebBrowser);
        this.getContentPane().add("North", radioPanel);
        webPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.darkGray), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        gridConstraints.weightx = 0.0;
        gridConstraints.weighty = 0.0;
        this.addGridBagComponent(webPanel, gridBag, gridConstraints, new JLabel(heightLbl), 0, 1, 1, 1, 13);
        gridConstraints.fill = 2;
        this.heightField = new JTextField(5);
        gridConstraints.weightx = 1.0;
        gridConstraints.weighty = 1.0;
        this.addGridBagComponent(webPanel, gridBag, gridConstraints, this.heightField, 1, 1, 1, 1, 17);
        gridConstraints.fill = 0;
        gridConstraints.weightx = 0.0;
        gridConstraints.weighty = 0.0;
        this.addGridBagComponent(webPanel, gridBag, gridConstraints, new JLabel(widthLbl), 2, 1, 1, 1, 13);
        gridConstraints.fill = 2;
        gridConstraints.weightx = 1.0;
        gridConstraints.weighty = 1.0;
        this.widthField = new JTextField(5);
        this.addGridBagComponent(webPanel, gridBag, gridConstraints, this.widthField, 3, 1, 1, 1, 17);
        gridConstraints.fill = 0;
        this.addGridBagComponent(webPanel, gridBag, gridConstraints, new JLabel(newParameterLbl), 5, 2, 1, 1, 10);
        this.parameterList = new JList(this.appletParameters);
        this.parameterList.setSelectionMode(0);
        this.parameterList.setModel(this.appletParameters);
        this.parameterList.addListSelectionListener(this);
        JScrollPane parameterScroller = new JScrollPane(this.parameterList);
        parameterScroller.setColumnHeaderView(new JLabel(appletParameterLbl, 0));
        gridConstraints.fill = 1;
        this.addGridBagComponent(webPanel, gridBag, gridConstraints, parameterScroller, 0, 2, 4, 4, 10);
        gridConstraints.fill = 0;
        this.addGridBagComponent(webPanel, gridBag, gridConstraints, new JLabel(nameLbl), 4, 3, 1, 1, 13);
        gridConstraints.weightx = 1.0;
        gridConstraints.weighty = 1.0;
        gridConstraints.fill = 2;
        this.paramNameField = new JTextField(16);
        this.addGridBagComponent(webPanel, gridBag, gridConstraints, this.paramNameField, 5, 3, 1, 1, 17);
        gridConstraints.weightx = 0.0;
        gridConstraints.weighty = 0.0;
        gridConstraints.fill = 0;
        this.addGridBagComponent(webPanel, gridBag, gridConstraints, new JLabel(valueLbl), 4, 4, 1, 1, 13);
        gridConstraints.weightx = 1.0;
        gridConstraints.weighty = 1.0;
        gridConstraints.fill = 2;
        this.paramValueField = new JTextField(16);
        this.addGridBagComponent(webPanel, gridBag, gridConstraints, this.paramValueField, 5, 4, 1, 1, 17);
        gridConstraints.weightx = 0.0;
        gridConstraints.weighty = 0.0;
        gridConstraints.fill = 0;
        this.deleteButton = new JButton(Config.getString("classmgr.delete"));
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RunAppletDialog.this.doDelete();
            }
        });
        this.deleteButton.setEnabled(false);
        this.addButton = new JButton(Config.getString("classmgr.add"));
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RunAppletDialog.this.doAdd();
            }
        });
        this.addButton.setEnabled(true);
        JPanel addDeletePanel = new JPanel();
        addDeletePanel.add(this.deleteButton);
        addDeletePanel.add(this.addButton);
        this.addGridBagComponent(webPanel, gridBag, gridConstraints, addDeletePanel, 5, 5, 1, 1, 10);
        this.getContentPane().add("Center", webPanel);
        DialogManager.centreDialog(this);
    }

    private void addGridBagComponent(Container container, GridBagLayout layout, GridBagConstraints constraints, Component component, int gridx, int gridy, int gridWidth, int gridHeight, int anchor) {
        constraints.gridx = gridx;
        constraints.gridy = gridy;
        constraints.gridwidth = gridWidth;
        constraints.gridheight = gridHeight;
        constraints.anchor = anchor;
        layout.setConstraints(component, constraints);
        if (!container.getLayout().equals(layout)) {
            container.setLayout(layout);
        }
        container.add(component);
    }

    public boolean display() {
        this.ok = false;
        this.pack();
        this.setVisible(true);
        return this.ok;
    }

    public String getWebPageName() {
        return this.webPageName;
    }

    public void addAppletParameter() {
        AppletParam param = new AppletParam(this.paramNameField.getText(), this.paramValueField.getText());
        int index = this.appletParameters.indexOf(param);
        if (index == -1) {
            this.appletParameters.addElement(param);
        } else {
            this.appletParameters.set(index, param);
        }
        this.clearInput();
    }

    private void clearInput() {
        this.paramNameField.setText("");
        this.paramValueField.setText("");
    }

    private void prepareForClosure() {
        this.clearInput();
        this.parameterList.getSelectionModel().clearSelection();
    }

    public void doOK() {
        if (!this.checkFieldsAreValid()) {
            DialogManager.showError(this.parent, "applet-height-width");
        } else {
            this.ok = true;
            this.prepareForClosure();
            this.setVisible(false);
        }
    }

    public void doCancel() {
        this.ok = false;
        this.prepareForClosure();
        this.setVisible(false);
    }

    public void doAdd() {
        if (!this.paramNameField.getText().equals("") && !this.paramValueField.getText().equals("")) {
            this.addAppletParameter();
            this.parameterList.getSelectionModel().clearSelection();
            this.paramNameField.requestFocus();
        }
    }

    public void doDelete() {
        this.appletParameters.remove(this.parameterList.getSelectedIndex());
        this.clearInput();
        this.deleteButton.setEnabled(false);
    }

    public boolean checkFieldsAreValid() {
        return !this.widthField.getText().equals("") && !this.heightField.getText().equals("");
    }

    public String getAppletHeight() {
        return this.heightField.getText();
    }

    public String getAppletWidth() {
        return this.widthField.getText();
    }

    public void setAppletHeight(int height) {
        this.heightField.setText(String.valueOf(height));
    }

    public void setAppletWidth(int width) {
        this.widthField.setText(String.valueOf(width));
    }

    public String[] getAppletParameters() {
        String[] paramStringArray = new String[this.appletParameters.size()];
        Enumeration e = this.appletParameters.elements();
        for (int i = 0; e.hasMoreElements() && i < paramStringArray.length; ++i) {
            AppletParam ap = (AppletParam)e.nextElement();
            paramStringArray[i] = ap.toString();
        }
        return paramStringArray;
    }

    public void setAppletParameters(String[] parameters) {
        if (parameters != null) {
            for (int i = 0; i < parameters.length; ++i) {
                this.appletParameters.addElement(new AppletParam(parameters[i]));
            }
        }
    }

    public int getAppletExecutionOption() {
        if (this.runAppletViewer.isSelected()) {
            return 0;
        }
        if (this.runWebBrowser.isSelected()) {
            return 1;
        }
        return 2;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!this.parameterList.isSelectionEmpty()) {
            this.deleteButton.setEnabled(true);
            AppletParam param = (AppletParam)this.parameterList.getSelectedValue();
            this.paramNameField.setText(param.getParamName());
            this.paramValueField.setText(param.getParamValue());
        }
    }
}

