/*
 * Decompiled with CFR 0.152.
 */
package bluej.prefmgr;

import bluej.BlueJTheme;
import bluej.Config;
import bluej.collect.DataCollector;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.prefmgr.PrefMgr;
import bluej.prefmgr.PrefPanelListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class MiscPrefPanel
extends JPanel
implements PrefPanelListener {
    private static final String bluejJdkURL = "bluej.url.javaStdLib";
    private static final String greenfootJdkURL = "greenfoot.url.javaStdLib";
    private JTextField jdkURLField;
    private JCheckBox linkToLibBox;
    private JCheckBox showUncheckedBox;
    private String jdkURLPropertyName = Config.isGreenfoot() ? "greenfoot.url.javaStdLib" : "bluej.url.javaStdLib";
    private JTextField playerNameField;
    private JTextField participantIdentifierField;
    private JTextField experimentIdentifierField;
    private JLabel statusLabel;

    public MiscPrefPanel() {
        JPanel box = new JPanel();
        box.setLayout(new BoxLayout(box, 1));
        this.add(box);
        this.setBorder(BlueJTheme.generalBorder);
        box.add(Box.createVerticalGlue());
        box.add(this.makeDocumentationPanel());
        if (Config.isGreenfoot()) {
            box.add(this.makePlayerNamePanel());
        } else {
            box.add(this.makeVMPanel());
            box.add(this.makeDataCollectionPanel());
        }
        box.add(Box.createVerticalStrut(5));
    }

    private JPanel makeDataCollectionPanel() {
        JPanel dataCollectionPanel = new JPanel();
        dataCollectionPanel.setLayout(new BoxLayout(dataCollectionPanel, 1));
        dataCollectionPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(Config.getString("prefmgr.collection.title")), BlueJTheme.generalBorder));
        dataCollectionPanel.setAlignmentX(0.0f);
        this.statusLabel = new JLabel();
        JButton optButton = new JButton(Config.getString("prefmgr.collection.change"));
        optButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataCollector.changeOptInOut();
                MiscPrefPanel.this.statusLabel.setText(DataCollector.getOptInOutStatus());
            }
        });
        JPanel statusPanel = new JPanel();
        statusPanel.setLayout(new BoxLayout(statusPanel, 0));
        statusPanel.add(this.statusLabel);
        statusPanel.add(Box.createHorizontalStrut(15));
        statusPanel.add(optButton);
        statusPanel.setAlignmentX(0.0f);
        dataCollectionPanel.add(statusPanel);
        JLabel identifierLabel = new JLabel(Config.getString("prefmgr.collection.identifier.explanation") + ":");
        identifierLabel.setAlignmentX(0.0f);
        dataCollectionPanel.add(Box.createVerticalStrut(20));
        dataCollectionPanel.add(identifierLabel);
        dataCollectionPanel.add(Box.createVerticalStrut(5));
        JPanel experimentPanel = new JPanel();
        experimentPanel.setLayout(new BoxLayout(experimentPanel, 0));
        JLabel experimentLabel = new JLabel(Config.getString("prefmgr.collection.identifier.experiment"));
        experimentPanel.add(experimentLabel);
        experimentPanel.add(Box.createHorizontalStrut(5));
        this.experimentIdentifierField = new JTextField(32);
        this.experimentIdentifierField.setMaximumSize(this.experimentIdentifierField.getPreferredSize());
        experimentPanel.add(this.experimentIdentifierField);
        experimentPanel.add(Box.createHorizontalGlue());
        JPanel participantPanel = new JPanel();
        participantPanel.setLayout(new BoxLayout(participantPanel, 0));
        JLabel participantLabel = new JLabel(Config.getString("prefmgr.collection.identifier.participant"));
        participantPanel.add(participantLabel);
        participantPanel.add(Box.createHorizontalStrut(5));
        this.participantIdentifierField = new JTextField(32);
        this.participantIdentifierField.setMaximumSize(this.participantIdentifierField.getPreferredSize());
        participantPanel.add(this.participantIdentifierField);
        participantPanel.add(Box.createHorizontalGlue());
        Dimension labelSize = this.maxByWidth(participantLabel.getPreferredSize(), experimentLabel.getPreferredSize());
        experimentLabel.setPreferredSize(labelSize);
        participantLabel.setPreferredSize(labelSize);
        experimentPanel.setAlignmentX(0.0f);
        participantPanel.setAlignmentX(0.0f);
        dataCollectionPanel.add(experimentPanel);
        dataCollectionPanel.add(participantPanel);
        return dataCollectionPanel;
    }

    private JPanel makeVMPanel() {
        JPanel vmPanel = new JPanel(new GridLayout(0, 1, 0, 0));
        vmPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(Config.getString("prefmgr.misc.vm.title")), BlueJTheme.generalBorder));
        vmPanel.setAlignmentX(0.0f);
        this.showUncheckedBox = new JCheckBox(Config.getString("prefmgr.misc.showUnchecked"));
        if (Config.isJava15()) {
            vmPanel.add(this.showUncheckedBox);
        }
        return vmPanel;
    }

    private JPanel makePlayerNamePanel() {
        JPanel playerNamePanel = new JPanel();
        playerNamePanel.setLayout(new BoxLayout(playerNamePanel, 1));
        String playerNameTitle = Config.getString("prefmgr.misc.playername.title");
        playerNamePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(playerNameTitle), BlueJTheme.generalBorder));
        playerNamePanel.setAlignmentX(0.0f);
        String shortcutText = " ";
        KeyStroke accelerator = Config.GREENFOOT_SET_PLAYER_NAME_SHORTCUT;
        if (accelerator != null) {
            int keyCode;
            int modifiers = accelerator.getModifiers();
            if (modifiers > 0) {
                shortcutText = shortcutText + KeyEvent.getKeyModifiersText(modifiers);
                shortcutText = shortcutText + (Config.isMacOS() ? "" : "+");
            }
            shortcutText = (keyCode = accelerator.getKeyCode()) != 0 ? shortcutText + KeyEvent.getKeyText(keyCode) : shortcutText + accelerator.getKeyChar();
        }
        playerNamePanel.add(new JLabel(Config.getString("playername.dialog.help")));
        this.playerNameField = new JTextField(Config.getPropString("extensions.rmiextension.RMIExtension.settings.greenfoot.player.name", "Player"), 20);
        this.playerNameField.setMaximumSize(this.playerNameField.getPreferredSize());
        JPanel namePanel = new JPanel();
        namePanel.setLayout(new BoxLayout(namePanel, 0));
        namePanel.add(this.playerNameField);
        namePanel.add(Box.createHorizontalGlue());
        playerNamePanel.add(namePanel);
        JLabel playerNameNote = new JLabel(Config.getString("prefmgr.misc.playerNameNote") + shortcutText);
        Font smallFont = playerNameNote.getFont().deriveFont(10);
        playerNameNote.setFont(smallFont);
        playerNamePanel.add(playerNameNote);
        return playerNamePanel;
    }

    private JPanel makeDocumentationPanel() {
        JPanel docPanel = new JPanel();
        docPanel.setLayout(new BoxLayout(docPanel, 1));
        String docTitle = Config.getString("prefmgr.misc.documentation.title");
        docPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(docTitle), BlueJTheme.generalBorder));
        docPanel.setAlignmentX(0.0f);
        JPanel urlPanel = new JPanel(new BorderLayout(5, 0));
        urlPanel.add((Component)new JLabel(Config.getString("prefmgr.misc.jdkurlpath")), "West");
        this.jdkURLField = new JTextField(32);
        urlPanel.add((Component)this.jdkURLField, "Center");
        urlPanel.setAlignmentX(0.0f);
        docPanel.add(urlPanel);
        docPanel.add(Box.createVerticalStrut(5));
        this.linkToLibBox = new JCheckBox(Config.getString("prefmgr.misc.linkToLib"));
        this.linkToLibBox.setAlignmentX(0.0f);
        docPanel.add(this.linkToLibBox);
        docPanel.add(Box.createVerticalStrut(5));
        JLabel linkToLibNoteLine1 = new JLabel(Config.getString("prefmgr.misc.linkToLibNoteLine1"));
        Font smallFont = linkToLibNoteLine1.getFont().deriveFont(10);
        linkToLibNoteLine1.setFont(smallFont);
        linkToLibNoteLine1.setAlignmentX(0.0f);
        docPanel.add(linkToLibNoteLine1);
        JLabel linkToLibNoteLine2 = new JLabel(Config.getString("prefmgr.misc.linkToLibNoteLine2"));
        linkToLibNoteLine2.setFont(smallFont);
        linkToLibNoteLine2.setAlignmentX(0.0f);
        docPanel.add(linkToLibNoteLine2);
        return docPanel;
    }

    private Dimension maxByWidth(Dimension a, Dimension b) {
        return a.width > b.width ? a : b;
    }

    @Override
    public void beginEditing() {
        this.linkToLibBox.setSelected(PrefMgr.getFlag("doctool.linkToStandardLib"));
        this.jdkURLField.setText(Config.getPropString(this.jdkURLPropertyName));
        if (!Config.isGreenfoot()) {
            this.showUncheckedBox.setSelected(PrefMgr.getFlag("bluej.compiler.showunchecked"));
            this.statusLabel.setText(DataCollector.getOptInOutStatus());
            this.experimentIdentifierField.setText(DataCollector.getExperimentIdentifier());
            this.participantIdentifierField.setText(DataCollector.getParticipantIdentifier());
        } else {
            this.playerNameField.setText(Config.getPropString("extensions.rmiextension.RMIExtension.settings.greenfoot.player.name", "Player"));
        }
    }

    @Override
    public void revertEditing() {
    }

    @Override
    public void commitEditing() {
        PrefMgr.setFlag("doctool.linkToStandardLib", this.linkToLibBox.isSelected());
        if (!Config.isGreenfoot()) {
            PrefMgr.setFlag("bluej.compiler.showunchecked", this.showUncheckedBox.isSelected());
            PkgMgrFrame.updateTestingStatus();
            PkgMgrFrame.updateTeamStatus();
            PkgMgrFrame.updateJavaMEstatus();
            DataCollector.setExperimentIdentifier(this.experimentIdentifierField.getText());
            DataCollector.setParticipantIdentifier(this.participantIdentifierField.getText());
        }
        String jdkURL = this.jdkURLField.getText();
        Config.putPropString(this.jdkURLPropertyName, jdkURL);
        if (Config.isGreenfoot()) {
            Config.putPropString("extensions.rmiextension.RMIExtension.settings.greenfoot.player.name", this.playerNameField.getText());
        }
    }
}

