/*
 * Decompiled with CFR 0.152.
 */
package bluej.utility;

import bluej.Config;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;

public class Debug {
    private static final String eol = System.getProperty("line.separator");
    private static Writer debugStream = new Writer(){

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() throws IOException {
        }
    };

    public static void setDebugStream(Writer debugStream) {
        Debug.debugStream = debugStream;
    }

    public static Writer getDebugStream() {
        return debugStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void message(String msg) {
        try {
            Writer writer = debugStream;
            synchronized (writer) {
                debugStream.write(msg);
                debugStream.write(eol);
                debugStream.flush();
            }
        }
        catch (IOException ioe) {
            System.err.println("IOException writing debug log");
        }
    }

    public static void log(String msg) {
        if (!Config.getPropString("bluej.debug").equals("true")) {
            Debug.message(msg);
        }
    }

    public static void reportError(String error) {
        Debug.message("Internal error: " + error);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reportError(String error, Throwable exc) {
        Writer writer = debugStream;
        synchronized (writer) {
            Debug.message("Internal error: " + error);
            Debug.message("Exception message: " + exc.getMessage());
            PrintWriter pwriter = new PrintWriter(debugStream);
            exc.printStackTrace(pwriter);
            pwriter.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reportError(Throwable error) {
        Writer writer = debugStream;
        synchronized (writer) {
            Debug.message("An unexpected exception occurred:");
            PrintWriter pwriter = new PrintWriter(debugStream);
            error.printStackTrace(pwriter);
            pwriter.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printCallStack(String msg) {
        Writer writer = debugStream;
        synchronized (writer) {
            Debug.message(msg + "; call stack:");
            StackTraceElement[] stack = Thread.currentThread().getStackTrace();
            for (int i = 2; i < stack.length; ++i) {
                Debug.message("  " + stack[i].toString());
            }
        }
    }
}

