/*
 * Decompiled with CFR 0.152.
 */
package greenfoot;

import bluej.debugger.gentype.JavaType;
import bluej.debugmgr.NamedValue;
import bluej.debugmgr.ValueCollection;
import bluej.runtime.BJMap;
import bluej.runtime.ExecServer;
import bluej.utility.Debug;
import bluej.utility.JavaUtils;
import greenfoot.core.GNamedValue;
import greenfoot.core.GreenfootLauncherDebugVM;
import greenfoot.core.GreenfootMain;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Iterator;
import rmiextension.wrappers.RObject;

public class ObjectTracker {
    private static HashMap<Object, RObject> cachedObjects = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RObject getRObject(Object obj) throws RemoteException {
        HashMap<Object, RObject> hashMap = cachedObjects;
        synchronized (hashMap) {
            RObject rObject = cachedObjects.get(obj);
            if (rObject != null) {
                return rObject;
            }
            GreenfootLauncherDebugVM.getInstance().setTransportField(obj);
            RObject rObj = GreenfootMain.getInstance().getProject().getRProject().getRemoteObject();
            if (rObj != null) {
                cachedObjects.put(obj, rObj);
            }
            return rObj;
        }
    }

    public static ValueCollection getObjects() {
        return new ValueCollection(){
            BJMap<String, Object> map;
            String[] names;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void initNames() {
                if (this.names == null) {
                    this.map = ExecServer.getObjectMap();
                    BJMap<String, Object> bJMap = this.map;
                    synchronized (bJMap) {
                        Object[] keys = this.map.getKeys();
                        this.names = new String[keys.length];
                        System.arraycopy(keys, 0, this.names, 0, keys.length);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public GNamedValue getNamedValue(String name) {
                this.initNames();
                BJMap<String, Object> bJMap = this.map;
                synchronized (bJMap) {
                    Object o = this.map.get((Object)name);
                    if (o != null) {
                        JavaType type = JavaUtils.genTypeFromClass(o.getClass());
                        return new GNamedValue(name, type);
                    }
                    return new GNamedValue(name, JavaUtils.genTypeFromClass(Object.class));
                }
            }

            public Iterator<? extends NamedValue> getValueIterator() {
                this.initNames();
                return new Iterator<GNamedValue>(){
                    int index = 0;

                    @Override
                    public boolean hasNext() {
                        return this.index < names.length;
                    }

                    @Override
                    public GNamedValue next() {
                        return this.getNamedValue(names[this.index++]);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static Object getRealObject(RObject remoteObj) {
        try {
            return ExecServer.getObject((String)remoteObj.getInstanceName());
        }
        catch (RemoteException e) {
            Debug.reportError((String)"Unexpected exception getting remote object name", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearRObjectCache() {
        HashMap<Object, RObject> hashMap = cachedObjects;
        synchronized (hashMap) {
            cachedObjects.clear();
        }
    }
}

