/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.actions;

import bluej.Config;
import bluej.utility.DialogManager;
import greenfoot.actions.SelectImageAction;
import greenfoot.core.GClass;
import greenfoot.core.GPackage;
import greenfoot.gui.NewClassDialog;
import greenfoot.gui.classbrowser.ClassBrowser;
import greenfoot.gui.classbrowser.ClassView;
import greenfoot.gui.classbrowser.role.ImageClassRole;
import greenfoot.gui.images.ImageLibFrame;
import greenfoot.record.InteractionListener;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class NewSubclassAction
extends AbstractAction {
    private ClassView superclass;
    private ClassBrowser classBrowser;
    private InteractionListener interactionListener;

    public NewSubclassAction(ClassView view, ClassBrowser classBrowser, InteractionListener interactionListener) {
        super(Config.getString((String)"new.subclass"));
        this.superclass = view;
        this.classBrowser = classBrowser;
        this.interactionListener = interactionListener;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        GClass superG = this.superclass.getGClass();
        boolean imageClass = superG.isActorClass() || superG.isActorSubclass();
        if (imageClass |= superG.isWorldClass() || superG.isWorldSubclass()) {
            this.createImageClass();
        } else {
            this.createNonActorClass();
        }
    }

    public void createImageClass() {
        JFrame f = (JFrame)SwingUtilities.getWindowAncestor(this.classBrowser);
        ImageLibFrame dialog = new ImageLibFrame(f, this.superclass.getGClass());
        DialogManager.centreDialog((JDialog)((Object)dialog));
        dialog.setVisible(true);
        if (dialog.getResult() != 0) {
            return;
        }
        String className = dialog.getClassName();
        GClass gClass = this.superclass.createSubclass(className);
        if (gClass != null) {
            ClassView classView = new ClassView(this.classBrowser, gClass, this.interactionListener);
            SelectImageAction.setClassImage(classView, (ImageClassRole)classView.getRole(), dialog.getSelectedImageFile());
            this.classBrowser.addClass(classView);
        }
    }

    public void createNonActorClass() {
        JFrame f = (JFrame)SwingUtilities.getWindowAncestor(this.classBrowser);
        GPackage pkg = this.classBrowser.getProject().getDefaultPackage();
        NewClassDialog dialog = new NewClassDialog(f, pkg);
        dialog.setVisible(true);
        if (!dialog.okPressed()) {
            return;
        }
        String className = dialog.getClassName();
        GClass gClass = this.superclass.createSubclass(className);
        if (gClass != null) {
            ClassView classView = new ClassView(this.classBrowser, gClass, this.interactionListener);
            this.classBrowser.addClass(classView);
        }
    }
}

