/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.actions;

import bluej.Config;
import bluej.utility.Debug;
import bluej.utility.DialogManager;
import bluej.utility.FileUtility;
import greenfoot.GreenfootImage;
import greenfoot.World;
import greenfoot.WorldVisitor;
import greenfoot.core.GClass;
import greenfoot.core.GreenfootMain;
import greenfoot.core.Simulation;
import greenfoot.core.WorldHandler;
import greenfoot.gui.GreenfootFrame;
import greenfoot.gui.classbrowser.ClassView;
import greenfoot.gui.classbrowser.role.ImageClassRole;
import greenfoot.gui.images.ImageLibFrame;
import greenfoot.gui.images.ImageSelectionWatcher;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.JDialog;

public class SelectImageAction
extends AbstractAction {
    private ClassView classView;
    private ImageClassRole gclassRole;

    public SelectImageAction(ClassView classView, ImageClassRole gcr) {
        super(Config.getString((String)"select.image"));
        this.classView = classView;
        this.gclassRole = gcr;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        final World currentWorld = WorldHandler.getInstance().getWorld();
        final GreenfootImage originalBackground = currentWorld == null ? null : WorldVisitor.getBackgroundImage(currentWorld);
        ImageSelectionWatcher watcher = null;
        if (currentWorld != null && currentWorld.getClass().getName().equals(this.classView.getGClass().getQualifiedName())) {
            watcher = new ImageSelectionWatcher(){

                @Override
                public void imageSelected(final File imageFile) {
                    if (imageFile != null) {
                        Simulation.getInstance().runLater(new Runnable(){

                            @Override
                            public void run() {
                                if (WorldHandler.getInstance().getWorld() == currentWorld) {
                                    currentWorld.setBackground(imageFile.getAbsolutePath());
                                }
                            }
                        });
                    }
                }
            };
        }
        GreenfootFrame gfFrame = GreenfootMain.getInstance().getFrame();
        ImageLibFrame imageLibFrame = new ImageLibFrame(gfFrame, this.classView, watcher);
        DialogManager.centreDialog((JDialog)((Object)imageLibFrame));
        imageLibFrame.setVisible(true);
        if (imageLibFrame.getResult() == 0) {
            File currentImageFile = imageLibFrame.getSelectedImageFile();
            SelectImageAction.setClassImage(this.classView, this.gclassRole, currentImageFile);
            gfFrame.repaint();
        } else if (currentWorld != null && imageLibFrame.getResult() == 1) {
            Simulation.getInstance().runLater(new Runnable(){

                @Override
                public void run() {
                    currentWorld.setBackground(originalBackground);
                }
            });
        }
    }

    public static void setClassImage(ClassView classView, ImageClassRole gclassRole, File imageFile) {
        GClass gclass = classView.getGClass();
        File projImagesDir = gclass.getPackage().getProject().getImageDir();
        if (imageFile != null) {
            if (!imageFile.getParentFile().getAbsoluteFile().equals(projImagesDir)) {
                File destFile = new File(projImagesDir, imageFile.getName());
                try {
                    FileUtility.copyFile((File)imageFile, (File)destFile);
                    imageFile = destFile;
                }
                catch (IOException e) {
                    Debug.reportError((String)("Error when copying file: " + imageFile + " to: " + destFile), (Throwable)e);
                }
            }
            gclass.setClassProperty("image", imageFile.getName());
        } else {
            imageFile = null;
            gclass.setClassProperty("image", null);
        }
        gclassRole.changeImage();
        gclass.getPackage().getProject().getProjectProperties().save();
    }
}

