/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.collision;

import greenfoot.TestObject;
import greenfoot.TestUtilDelegate;
import greenfoot.World;
import greenfoot.WorldCreator;
import greenfoot.util.GreenfootUtil;
import java.util.List;
import junit.framework.TestCase;

public class InRangeTest
extends TestCase {
    private World world;

    protected void setUp() throws Exception {
        GreenfootUtil.initialise(new TestUtilDelegate());
    }

    public void testNoWrap() {
        this.world = WorldCreator.createWorld(10, 10, 10);
        TestObject actor1 = new TestObject(20, 20);
        this.world.addObject(actor1, 2, 2);
        TestObject actor2 = new TestObject(10, 10);
        this.world.addObject(actor2, 2, 4);
        List inRange = actor1.getObjectsInRangeP(3, TestObject.class);
        InRangeTest.assertTrue((boolean)inRange.contains(actor2));
        inRange = actor2.getObjectsInRangeP(3, TestObject.class);
        InRangeTest.assertTrue((boolean)inRange.contains(actor1));
        actor2.setLocation(2, 5);
        inRange = actor1.getObjectsInRangeP(3, TestObject.class);
        InRangeTest.assertTrue((boolean)inRange.contains(actor2));
        inRange = actor2.getObjectsInRangeP(3, TestObject.class);
        InRangeTest.assertTrue((boolean)inRange.contains(actor1));
        actor2.setLocation(2, 6);
        inRange = actor1.getObjectsInRangeP(3, TestObject.class);
        InRangeTest.assertFalse((boolean)inRange.contains(actor2));
        inRange = actor2.getObjectsInRangeP(3, TestObject.class);
        InRangeTest.assertFalse((boolean)inRange.contains(actor1));
        actor2.setLocation(4, 4);
        inRange = actor1.getObjectsInRangeP(3, TestObject.class);
        InRangeTest.assertTrue((boolean)inRange.contains(actor2));
        inRange = actor2.getObjectsInRangeP(3, TestObject.class);
        InRangeTest.assertTrue((boolean)inRange.contains(actor1));
        actor2.setLocation(5, 5);
        inRange = actor1.getObjectsInRangeP(3, TestObject.class);
        InRangeTest.assertFalse((boolean)inRange.contains(actor2));
        inRange = actor2.getObjectsInRangeP(3, TestObject.class);
        InRangeTest.assertFalse((boolean)inRange.contains(actor1));
        actor2.setLocation(5, 5);
        inRange = actor1.getObjectsInRangeP(10000, TestObject.class);
        InRangeTest.assertTrue((boolean)inRange.contains(actor2));
        inRange = actor2.getObjectsInRangeP(10000, TestObject.class);
        InRangeTest.assertTrue((boolean)inRange.contains(actor1));
    }
}

