/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.collision.ibsp;

import greenfoot.Actor;
import greenfoot.ActorVisitor;
import greenfoot.collision.ClassQuery;
import greenfoot.collision.CollisionChecker;
import greenfoot.collision.CollisionQuery;
import greenfoot.collision.GOCollisionQuery;
import greenfoot.collision.InRangeQuery;
import greenfoot.collision.NeighbourCollisionQuery;
import greenfoot.collision.PointCollisionQuery;
import greenfoot.collision.ibsp.ActorNode;
import greenfoot.collision.ibsp.BSPNode;
import greenfoot.collision.ibsp.BSPNodeCache;
import greenfoot.collision.ibsp.Rect;
import java.awt.Color;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class IBSPColChecker
implements CollisionChecker {
    public static final int X_AXIS = 0;
    public static final int Y_AXIS = 1;
    public static final int PARENT_LEFT = 0;
    public static final int PARENT_RIGHT = 1;
    public static final int PARENT_NONE = 3;
    public static final int REBALANCE_THRESHOLD = 20;
    private GOCollisionQuery actorQuery = new GOCollisionQuery();
    private NeighbourCollisionQuery neighbourQuery = new NeighbourCollisionQuery();
    private PointCollisionQuery pointQuery = new PointCollisionQuery();
    private InRangeQuery inRangeQuery = new InRangeQuery();
    private int cellSize;
    private BSPNode bspTree;
    public static boolean debugging = false;
    private static int dbgCounter = 0;

    @Override
    public void initialize(int width, int height, int cellSize, boolean wrap) {
        this.cellSize = cellSize;
    }

    @Override
    public void addObject(Actor actor) {
        Rect bounds = this.getActorBounds(actor);
        if (this.bspTree == null) {
            int splitPos;
            int splitAxis;
            if (bounds.getWidth() > bounds.getHeight()) {
                splitAxis = 0;
                splitPos = bounds.getMiddleX();
            } else {
                splitAxis = 1;
                splitPos = bounds.getMiddleY();
            }
            this.bspTree = BSPNodeCache.getBSPNode();
            this.bspTree.getArea().copyFrom(bounds);
            this.bspTree.setSplitAxis(splitAxis);
            this.bspTree.setSplitPos(splitPos);
            this.bspTree.addActor(actor);
        } else {
            Rect treeArea = this.bspTree.getArea();
            while (!treeArea.contains(bounds)) {
                int by;
                BSPNode newTop;
                Rect newArea;
                int bx;
                if (bounds.getX() < treeArea.getX()) {
                    bx = treeArea.getX() - treeArea.getWidth();
                    newArea = new Rect(bx, treeArea.getY(), treeArea.getRight() - bx, treeArea.getHeight());
                    newTop = BSPNodeCache.getBSPNode();
                    newTop.getArea().copyFrom(newArea);
                    newTop.setSplitAxis(0);
                    newTop.setSplitPos(treeArea.getX());
                    newTop.setChild(1, this.bspTree);
                    this.bspTree = newTop;
                    treeArea = newArea;
                }
                if (bounds.getRight() > treeArea.getRight()) {
                    bx = treeArea.getRight() + treeArea.getWidth();
                    newArea = new Rect(treeArea.getX(), treeArea.getY(), bx - treeArea.getX(), treeArea.getHeight());
                    newTop = BSPNodeCache.getBSPNode();
                    newTop.getArea().copyFrom(newArea);
                    newTop.setSplitAxis(0);
                    newTop.setSplitPos(treeArea.getRight());
                    newTop.setChild(0, this.bspTree);
                    this.bspTree = newTop;
                    treeArea = newArea;
                }
                if (bounds.getY() < treeArea.getY()) {
                    by = treeArea.getY() - treeArea.getHeight();
                    newArea = new Rect(treeArea.getX(), by, treeArea.getWidth(), treeArea.getTop() - by);
                    newTop = BSPNodeCache.getBSPNode();
                    newTop.getArea().copyFrom(newArea);
                    newTop.setSplitAxis(1);
                    newTop.setSplitPos(treeArea.getY());
                    newTop.setChild(1, this.bspTree);
                    this.bspTree = newTop;
                    treeArea = newArea;
                }
                if (bounds.getTop() <= treeArea.getTop()) continue;
                by = treeArea.getTop() + treeArea.getHeight();
                newArea = new Rect(treeArea.getX(), treeArea.getY(), treeArea.getWidth(), by - treeArea.getY());
                newTop = BSPNodeCache.getBSPNode();
                newTop.getArea().copyFrom(newArea);
                newTop.setSplitAxis(1);
                newTop.setSplitPos(treeArea.getTop());
                newTop.setChild(0, this.bspTree);
                this.bspTree = newTop;
                treeArea = newArea;
            }
            this.insertObject(actor, bounds, bounds, treeArea, this.bspTree);
        }
    }

    public void checkConsistency(boolean checkActorBounds) {
        if (!debugging) {
            return;
        }
        LinkedList<BSPNode> stack = new LinkedList<BSPNode>();
        stack.add(this.bspTree);
        while (!stack.isEmpty()) {
            Rect rightArea;
            Rect leftArea;
            BSPNode node = (BSPNode)stack.removeLast();
            if (node == null) continue;
            Rect nodeArea = node.getArea();
            List<Actor> actors = node.getActorsList();
            for (Actor actor : actors) {
                Rect actorBounds = this.getActorBounds(actor);
                if (!checkActorBounds || nodeArea.intersects(actorBounds)) continue;
                throw new IllegalStateException("Actor not contained within region bounds?");
            }
            if (node.getLeft() != null && !Rect.equals(leftArea = node.getLeft().getArea(), node.getLeftArea())) {
                throw new IllegalStateException("Areas wrong!");
            }
            if (node.getRight() != null && !Rect.equals(rightArea = node.getRight().getArea(), node.getRightArea())) {
                throw new IllegalStateException("Areas wrong!");
            }
            stack.add(node.getLeft());
            stack.add(node.getRight());
        }
    }

    private void insertObject(Actor actor, Rect actorBounds, Rect bounds, Rect area, BSPNode node) {
        if (node.containsActor(actor)) {
            return;
        }
        if (node.isEmpty() || area.getWidth() <= actorBounds.getWidth() && area.getHeight() <= actorBounds.getHeight()) {
            node.addActor(actor);
            return;
        }
        Rect leftArea = node.getLeftArea();
        Rect rightArea = node.getRightArea();
        Rect leftIntersects = Rect.getIntersection(leftArea, bounds);
        Rect rightIntersects = Rect.getIntersection(rightArea, bounds);
        if (leftIntersects != null) {
            if (node.getLeft() == null) {
                BSPNode newLeft = this.createNewNode(leftArea);
                newLeft.addActor(actor);
                node.setChild(0, newLeft);
            } else {
                this.insertObject(actor, actorBounds, leftIntersects, leftArea, node.getLeft());
            }
        }
        if (rightIntersects != null) {
            if (node.getRight() == null) {
                BSPNode newRight = this.createNewNode(rightArea);
                newRight.addActor(actor);
                node.setChild(1, newRight);
            } else {
                this.insertObject(actor, actorBounds, rightIntersects, rightArea, node.getRight());
            }
        }
    }

    private BSPNode createNewNode(Rect area) {
        int splitPos;
        int splitAxis;
        if (area.getWidth() > area.getHeight()) {
            splitAxis = 0;
            splitPos = area.getMiddleX();
        } else {
            splitAxis = 1;
            splitPos = area.getMiddleY();
        }
        BSPNode newNode = BSPNodeCache.getBSPNode();
        newNode.setArea(area);
        newNode.setSplitAxis(splitAxis);
        newNode.setSplitPos(splitPos);
        return newNode;
    }

    public final Rect getActorBounds(Actor actor) {
        Rect r = ActorVisitor.getBoundingRect(actor);
        return r;
    }

    public static void printTree(BSPNode node, String indent, String lead) {
        if (node == null) {
            return;
        }
        String xx = lead;
        xx = String.valueOf(xx) + node + ": ";
        xx = String.valueOf(xx) + node.getArea();
        IBSPColChecker.println(xx);
        BSPNode left = node.getLeft();
        BSPNode right = node.getRight();
        if (left != null) {
            String newIndent = right != null ? String.valueOf(indent) + " |" : String.valueOf(indent) + "  ";
            IBSPColChecker.printTree(left, newIndent, String.valueOf(indent) + " \\L-");
        }
        if (right != null) {
            IBSPColChecker.printTree(node.getRight(), String.valueOf(indent) + "  ", String.valueOf(indent) + " \\R-");
        }
    }

    public void printTree() {
        IBSPColChecker.printTree(this.bspTree, "", "");
    }

    @Override
    public void removeObject(Actor object) {
        ActorNode node = IBSPColChecker.getNodeForActor(object);
        while (node != null) {
            BSPNode bspNode = node.getBSPNode();
            node.remove();
            this.checkRemoveNode(bspNode);
            node = IBSPColChecker.getNodeForActor(object);
        }
    }

    private BSPNode checkRemoveNode(BSPNode node) {
        while (node != null && node.isEmpty()) {
            BSPNode parent = node.getParent();
            int side = parent != null ? parent.getChildSide(node) : 3;
            BSPNode left = node.getLeft();
            BSPNode right = node.getRight();
            if (left == null) {
                if (parent != null) {
                    if (right != null) {
                        right.getArea().copyFrom(node.getArea());
                        right.areaChanged();
                    }
                    parent.setChild(side, right);
                } else {
                    this.bspTree = right;
                    if (right != null) {
                        right.setParent(null);
                    }
                }
                node.setChild(1, null);
                BSPNodeCache.returnNode(node);
                node = parent;
                continue;
            }
            if (right != null) break;
            if (parent != null) {
                if (left != null) {
                    left.getArea().copyFrom(node.getArea());
                    left.areaChanged();
                }
                parent.setChild(side, left);
            } else {
                this.bspTree = left;
                if (left != null) {
                    left.setParent(null);
                }
            }
            node.setChild(0, null);
            BSPNodeCache.returnNode(node);
            node = parent;
        }
        return node;
    }

    private static void println(String s) {
        if (dbgCounter < 3000) {
            System.out.println(s);
        }
    }

    public static ActorNode getNodeForActor(Actor object) {
        return (ActorNode)ActorVisitor.getData(object);
    }

    public static void setNodeForActor(Actor object, ActorNode node) {
        ActorVisitor.setData(object, node);
    }

    /*
     * Unable to fully structure code
     */
    private void updateObject(Actor object) {
        node = IBSPColChecker.getNodeForActor(object);
        if (node == null) {
            return;
        }
        newBounds = this.getActorBounds(object);
        if (this.bspTree.getArea().contains(newBounds)) ** GOTO lbl38
        while (node != null) {
            rNode = node.getBSPNode();
            node.remove();
            this.checkRemoveNode(rNode);
            node = node.getNext();
        }
        this.addObject(object);
        return;
lbl-1000:
        // 1 sources

        {
            bspNode = node.getBSPNode();
            bspArea = bspNode.getArea();
            if (bspArea.contains(newBounds)) {
                iter = IBSPColChecker.getNodeForActor(object);
                while (iter != null) {
                    if (iter != node) {
                        rNode = iter.getBSPNode();
                        iter.remove();
                        this.checkRemoveNode(rNode);
                    }
                    iter = iter.getNext();
                }
                return;
            }
            if (!bspArea.intersects(newBounds)) {
                rNode = node.getBSPNode();
                node.remove();
                this.checkRemoveNode(rNode);
                if (this.bspTree == null) {
                    this.addObject(object);
                    return;
                }
            }
            node.clearMark();
            node = node.getNext();
lbl38:
            // 2 sources

            ** while (node != null)
        }
lbl39:
        // 1 sources

        node = IBSPColChecker.getNodeForActor(object);
        if (node != null) {
            bspNode = node.getBSPNode();
            while (bspNode != null && !bspNode.getArea().contains(newBounds)) {
                bspNode = bspNode.getParent();
            }
            if (bspNode == null) {
                while (node != null) {
                    bspNode = node.getBSPNode();
                    node.remove();
                    this.checkRemoveNode(bspNode);
                    node = node.getNext();
                }
                this.addObject(object);
                return;
            }
        } else {
            bspNode = this.bspTree;
        }
        bspArea = bspNode.getArea();
        this.insertObject(object, newBounds, newBounds, bspArea, bspNode);
        node = IBSPColChecker.getNodeForActor(object);
        while (node != null) {
            if (!node.checkMark()) {
                bspNode = node.getBSPNode();
                node.remove();
                this.checkRemoveNode(bspNode);
            }
            node = node.getNext();
        }
    }

    @Override
    public void updateObjectLocation(Actor object, int oldX, int oldY) {
        this.updateObject(object);
    }

    @Override
    public void updateObjectSize(Actor object) {
        this.updateObject(object);
    }

    private List<Actor> getIntersectingObjects(Rect r, CollisionQuery query) {
        HashSet<Actor> set = new HashSet<Actor>();
        this.getIntersectingObjects(r, query, set, this.bspTree);
        ArrayList<Actor> l = new ArrayList<Actor>(set);
        return l;
    }

    private void getIntersectingObjects(Rect r, CollisionQuery query, Set<Actor> resultSet, BSPNode startNode) {
        LinkedList<BSPNode> nodeStack = new LinkedList<BSPNode>();
        if (startNode != null) {
            nodeStack.add(startNode);
        }
        while (!nodeStack.isEmpty()) {
            BSPNode node = (BSPNode)nodeStack.removeLast();
            if (!node.getArea().intersects(r)) continue;
            Iterator<Actor> i = node.getActorsIterator();
            while (i.hasNext()) {
                Actor actor = i.next();
                if (!query.checkCollision(actor) || resultSet.contains(actor)) continue;
                resultSet.add(actor);
            }
            BSPNode left = node.getLeft();
            BSPNode right = node.getRight();
            if (left != null) {
                nodeStack.add(left);
            }
            if (right == null) continue;
            nodeStack.add(right);
        }
    }

    private Actor checkForOneCollision(Actor ignore, BSPNode node, CollisionQuery query) {
        Iterator<Actor> i = node.getActorsIterator();
        while (i.hasNext()) {
            Actor candidate = i.next();
            if (ignore == candidate || !query.checkCollision(candidate)) continue;
            return candidate;
        }
        return null;
    }

    private Actor getOneObjectDownTree(Actor ignore, Rect r, CollisionQuery query, BSPNode startNode) {
        if (startNode == null) {
            return null;
        }
        LinkedList<BSPNode> nodeStack = new LinkedList<BSPNode>();
        nodeStack.add(startNode);
        while (!nodeStack.isEmpty()) {
            BSPNode node = (BSPNode)nodeStack.removeLast();
            if (!node.getArea().intersects(r)) continue;
            Actor res = this.checkForOneCollision(ignore, node, query);
            if (res != null) {
                return res;
            }
            BSPNode left = node.getLeft();
            BSPNode right = node.getRight();
            if (left != null) {
                nodeStack.add(left);
            }
            if (right == null) continue;
            nodeStack.add(right);
        }
        return null;
    }

    private Actor getOneIntersectingDown(Rect r, CollisionQuery query, Actor actor) {
        if (this.bspTree == null) {
            return null;
        }
        LinkedList<BSPNode> nodeStack = new LinkedList<BSPNode>();
        nodeStack.add(this.bspTree);
        while (!nodeStack.isEmpty()) {
            BSPNode node = (BSPNode)nodeStack.removeLast();
            if (!node.getArea().contains(r)) continue;
            Actor res = this.checkForOneCollision(actor, node, query);
            if (res != null) {
                return res;
            }
            BSPNode left = node.getLeft();
            BSPNode right = node.getRight();
            if (left != null) {
                nodeStack.add(left);
            }
            if (right == null) continue;
            nodeStack.add(right);
        }
        return null;
    }

    public Actor getOneIntersectingUp(Rect r, CollisionQuery query, Actor actor, BSPNode start) {
        while (start != null && !start.getArea().contains(r)) {
            Actor res = this.checkForOneCollision(actor, start, query);
            if (res != null) {
                return res;
            }
            start = start.getParent();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Actor> List<T> getObjectsAt(int x, int y, Class<T> cls) {
        PointCollisionQuery pointCollisionQuery = this.pointQuery;
        synchronized (pointCollisionQuery) {
            int px = x * this.cellSize + this.cellSize / 2;
            int py = y * this.cellSize + this.cellSize / 2;
            this.pointQuery.init(px, py, cls);
            return this.getIntersectingObjects(new Rect(px, py, 1, 1), this.pointQuery);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Actor> List<T> getIntersectingObjects(Actor actor, Class<T> cls) {
        Rect r = this.getActorBounds(actor);
        GOCollisionQuery gOCollisionQuery = this.actorQuery;
        synchronized (gOCollisionQuery) {
            this.actorQuery.init(cls, actor);
            return this.getIntersectingObjects(r, this.actorQuery);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Actor> List<T> getObjectsInRange(int x, int y, int r, Class<T> cls) {
        List<Actor> result;
        int halfCell = this.cellSize / 2;
        int size = 2 * r * this.cellSize;
        Rect rect = new Rect((x - r) * this.cellSize + halfCell, (y - r) * this.cellSize + halfCell, size, size);
        GOCollisionQuery gOCollisionQuery = this.actorQuery;
        synchronized (gOCollisionQuery) {
            this.actorQuery.init(cls, null);
            result = this.getIntersectingObjects(rect, this.actorQuery);
        }
        Iterator<Actor> i = result.iterator();
        InRangeQuery inRangeQuery = this.inRangeQuery;
        synchronized (inRangeQuery) {
            this.inRangeQuery.init(x * this.cellSize + halfCell, y * this.cellSize + halfCell, r * this.cellSize);
            while (i.hasNext()) {
                if (this.inRangeQuery.checkCollision(i.next())) continue;
                i.remove();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Actor> List<T> getNeighbours(Actor actor, int distance, boolean diag, Class<T> cls) {
        int x = ActorVisitor.getX(actor);
        int y = ActorVisitor.getY(actor);
        int xPixel = x * this.cellSize;
        int yPixel = y * this.cellSize;
        int dPixel = distance * this.cellSize;
        Rect r = new Rect(xPixel - dPixel, yPixel - dPixel, dPixel * 2 + 1, dPixel * 2 + 1);
        NeighbourCollisionQuery neighbourCollisionQuery = this.neighbourQuery;
        synchronized (neighbourCollisionQuery) {
            this.neighbourQuery.init(x, y, distance, diag, cls);
            List<Actor> res = this.getIntersectingObjects(r, this.neighbourQuery);
            return res;
        }
    }

    @Override
    public <T extends Actor> List<T> getObjectsInDirection(int x, int y, int angle, int length, Class<T> cls) {
        return new ArrayList();
    }

    @Override
    public <T extends Actor> List<T> getObjects(Class<T> cls) {
        HashSet<Actor> set = new HashSet<Actor>();
        LinkedList<BSPNode> nodeStack = new LinkedList<BSPNode>();
        if (this.bspTree != null) {
            nodeStack.add(this.bspTree);
        }
        while (!nodeStack.isEmpty()) {
            BSPNode node = (BSPNode)nodeStack.removeLast();
            Iterator<Actor> i = node.getActorsIterator();
            while (i.hasNext()) {
                Actor actor = i.next();
                if (cls != null && !cls.isInstance(actor)) continue;
                set.add(actor);
            }
            BSPNode left = node.getLeft();
            BSPNode right = node.getRight();
            if (left != null) {
                nodeStack.add(left);
            }
            if (right == null) continue;
            nodeStack.add(right);
        }
        ArrayList list = new ArrayList(set);
        return list;
    }

    @Override
    public List<Actor> getObjectsList() {
        return this.getObjects(null);
    }

    @Override
    public final void startSequence() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Actor> T getOneObjectAt(Actor object, int dx, int dy, Class<T> cls) {
        PointCollisionQuery pointCollisionQuery = this.pointQuery;
        synchronized (pointCollisionQuery) {
            int px = dx * this.cellSize + this.cellSize / 2;
            int py = dy * this.cellSize + this.cellSize / 2;
            this.pointQuery.init(px, py, cls);
            CollisionQuery query = this.pointQuery;
            if (cls != null) {
                query = new ClassQuery(cls, this.pointQuery);
            }
            return (T)this.getOneIntersectingDown(new Rect(px, py, 1, 1), query, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Actor> T getOneIntersectingObject(Actor actor, Class<T> cls) {
        Rect r = this.getActorBounds(actor);
        GOCollisionQuery gOCollisionQuery = this.actorQuery;
        synchronized (gOCollisionQuery) {
            this.actorQuery.init(cls, actor);
            ActorNode node = IBSPColChecker.getNodeForActor(actor);
            do {
                BSPNode bspNode;
                Actor ret;
                if ((ret = this.getOneObjectDownTree(actor, r, this.actorQuery, bspNode = node.getBSPNode())) != null) {
                    return (T)ret;
                }
                ret = this.getOneIntersectingUp(r, this.actorQuery, actor, bspNode.getParent());
                if (ret == null) continue;
                return (T)ret;
            } while ((node = node.getNext()) != null);
            return (T)this.getOneIntersectingDown(r, this.actorQuery, actor);
        }
    }

    @Override
    public void paintDebug(Graphics g) {
        LinkedList<BSPNode> nodeStack = new LinkedList<BSPNode>();
        nodeStack.add(this.bspTree);
        Color oldColor = g.getColor();
        g.setColor(Color.RED);
        while (!nodeStack.isEmpty()) {
            BSPNode node = (BSPNode)nodeStack.removeLast();
            if (node == null) continue;
            Rect area = node.getArea();
            g.drawRect(area.getX(), area.getY(), area.getWidth(), area.getHeight());
            nodeStack.add(node.getLeft());
            nodeStack.add(node.getRight());
        }
        g.setColor(oldColor);
    }
}

