/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.core;

import greenfoot.GreenfootImage;
import greenfoot.util.GreenfootUtil;
import greenfoot.util.Version;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Properties;

public class ProjectProperties {
    private static final String FILE_HEADER = "Greenfoot properties";
    public static final String GREENFOOT_PKG_NAME = "project.greenfoot";
    private Properties properties = new Properties();
    private File propsFile;

    public ProjectProperties(File projectDir) {
        this.load(projectDir);
    }

    public ProjectProperties() {
        this.load();
    }

    private void load() {
        block12: {
            URL probsFile = this.getClass().getResource("/project.greenfoot");
            InputStream is = null;
            try {
                try {
                    is = probsFile.openStream();
                    this.properties.load(is);
                }
                catch (IOException iOException) {
                    if (is == null) break block12;
                    try {
                        is.close();
                    }
                    catch (IOException iOException2) {}
                }
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private void load(File projectDir) {
        block12: {
            this.propsFile = new File(projectDir, GREENFOOT_PKG_NAME);
            FileInputStream is = null;
            try {
                try {
                    is = new FileInputStream(this.propsFile);
                    this.properties.load(is);
                }
                catch (IOException iOException) {
                    if (is == null) break block12;
                    try {
                        ((InputStream)is).close();
                    }
                    catch (IOException iOException2) {}
                }
            }
            finally {
                if (is != null) {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public synchronized void save() {
        block16: {
            FileOutputStream os = null;
            try {
                try {
                    os = new FileOutputStream(this.propsFile);
                    this.properties.store(os, FILE_HEADER);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    if (os == null) break block16;
                    try {
                        ((OutputStream)os).close();
                    }
                    catch (IOException iOException) {
                    }
                }
                catch (IOException iOException) {
                    if (os == null) break block16;
                    try {
                        ((OutputStream)os).close();
                    }
                    catch (IOException iOException2) {}
                }
            }
            finally {
                if (os != null) {
                    try {
                        ((OutputStream)os).close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public synchronized void setString(String key, String value) {
        this.properties.setProperty(key, value);
    }

    public synchronized String getString(String key) {
        return this.properties.getProperty(key);
    }

    public synchronized void setInt(String key, int value) {
        this.properties.setProperty(key, Integer.toString(value));
    }

    public synchronized int getInt(String key) throws NumberFormatException {
        String number = this.properties.getProperty(key);
        return Integer.parseInt(number);
    }

    public synchronized void setBoolean(String key, boolean value) {
        this.properties.setProperty(key, Boolean.toString(value));
    }

    public synchronized boolean getBoolean(String key, String defaultValue) {
        String bool = this.properties.getProperty(key, defaultValue);
        return Boolean.parseBoolean(bool);
    }

    public synchronized String removeProperty(String key) {
        return (String)this.properties.remove(key);
    }

    public void setApiVersion(String version) {
        this.properties.setProperty("version", version);
    }

    public Version getAPIVersion() {
        String versionString = this.properties.getProperty("version");
        Version version = new Version(versionString);
        return version;
    }

    public GreenfootImage getImage(String className) {
        return GreenfootUtil.getGreenfootImage(className, this.getString("class." + className + ".image"));
    }

    public void removeCachedImage(String className) {
        GreenfootUtil.removeCachedImage(className);
    }
}

