/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.gui;

import bluej.utility.MultiLineLabel;
import javax.swing.JLabel;

public class WrappingMultiLineLabel
extends MultiLineLabel {
    private int cols;

    public WrappingMultiLineLabel(String text, int numCols) {
        super(null);
        this.alignment = 0.0f;
        this.cols = numCols;
        this.addText(text);
    }

    public void setText(String text) {
        this.addText(text);
    }

    public void addText(String text) {
        if (text != null) {
            String[] strs = text.split("\n");
            int i = 0;
            while (i < strs.length) {
                int lastIndex = 0;
                int index = this.getLineBreakPoint(strs[i], lastIndex);
                while (index > lastIndex) {
                    this.addLabel(strs[i].substring(lastIndex, index).trim());
                    lastIndex = index;
                    index = this.getLineBreakPoint(strs[i], lastIndex);
                }
                ++i;
            }
        }
    }

    private int getLineBreakPoint(String str, int lastIndex) {
        int rest;
        int strLength;
        int index = str.lastIndexOf(" ", lastIndex + this.cols);
        if (index == lastIndex || index == -1) {
            index = lastIndex + this.cols;
        }
        if (index >= str.length()) {
            index = str.length();
        }
        if ((strLength = index - lastIndex) + (rest = str.length() - index) < this.cols) {
            index = str.length();
        }
        return index;
    }

    private void addLabel(String str) {
        if (str.equals("")) {
            str = " ";
        }
        JLabel label = new JLabel(str);
        label.setAlignmentX(this.alignment);
        this.add(label);
    }
}

