/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.mouse;

import greenfoot.Actor;
import greenfoot.MouseInfo;
import greenfoot.TestObject;
import greenfoot.TestUtilDelegate;
import greenfoot.World;
import greenfoot.WorldCreator;
import greenfoot.WorldVisitor;
import greenfoot.gui.input.mouse.MousePollingManager;
import greenfoot.gui.input.mouse.WorldLocator;
import greenfoot.util.GreenfootUtil;
import java.awt.event.MouseEvent;
import java.util.Collection;
import javax.swing.JPanel;
import junit.framework.TestCase;

public class MousePollTest
extends TestCase {
    private MousePollingManager mouseMan;
    private JPanel panel;
    private World world;
    private TestObject actorAtClick;
    private TestObject actorOutsideClick;

    protected void setUp() throws Exception {
        GreenfootUtil.initialise(new TestUtilDelegate());
        this.world = WorldCreator.createWorld(200, 200, 1);
        this.actorAtClick = new TestObject(10, 10);
        this.world.addObject(this.actorAtClick, 5, 5);
        this.actorOutsideClick = new TestObject(10, 10);
        this.world.addObject(this.actorOutsideClick, 50, 50);
        this.mouseMan = new MousePollingManager(new WorldLocator(){

            @Override
            public Actor getTopMostActorAt(MouseEvent e) {
                Collection<Actor> actors = WorldVisitor.getObjectsAtPixel(MousePollTest.this.world, e.getX(), e.getY());
                if (actors.isEmpty()) {
                    return null;
                }
                return actors.iterator().next();
            }

            @Override
            public int getTranslatedX(MouseEvent e) {
                return WorldVisitor.toCellFloor(MousePollTest.this.world, e.getX());
            }

            @Override
            public int getTranslatedY(MouseEvent e) {
                return WorldVisitor.toCellFloor(MousePollTest.this.world, e.getY());
            }
        });
        this.panel = new JPanel();
        this.panel.addMouseListener(this.mouseMan);
        this.panel.addMouseMotionListener(this.mouseMan);
        this.panel.setEnabled(true);
    }

    private void dispatch(MouseEvent e) {
        this.panel.dispatchEvent(e);
    }

    private void assertBlank() {
        Object[] objectArray = new Object[3];
        objectArray[0] = this.actorAtClick;
        objectArray[1] = this.actorOutsideClick;
        Object[] objectArray2 = objectArray;
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray2[n2];
            MousePollTest.assertFalse((boolean)this.mouseMan.isMouseClicked(obj));
            MousePollTest.assertFalse((boolean)this.mouseMan.isMouseDragEnded(obj));
            MousePollTest.assertFalse((boolean)this.mouseMan.isMouseDragged(obj));
            MousePollTest.assertFalse((boolean)this.mouseMan.isMouseMoved(obj));
            MousePollTest.assertFalse((boolean)this.mouseMan.isMousePressed(obj));
            ++n2;
        }
        MouseInfo info = this.mouseMan.getMouseInfo();
        if (info != null) {
            MousePollTest.assertEquals((int)0, (int)info.getClickCount());
            MousePollTest.assertEquals((int)0, (int)info.getButton());
            MousePollTest.assertNull((Object)info.getActor());
        }
    }

    public void testSingleLeftClickOnActor() {
        this.mouseMan.newActStarted();
        this.assertBlank();
        MouseEvent event = new MouseEvent(this.panel, 501, System.currentTimeMillis(), 0, 5, 5, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 502, System.currentTimeMillis(), 0, 5, 5, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 500, System.currentTimeMillis(), 0, 5, 5, 1, false, 1);
        this.dispatch(event);
        this.assertBlank();
        this.mouseMan.newActStarted();
        MousePollTest.assertTrue((boolean)this.mouseMan.isMousePressed(this.actorAtClick));
        MousePollTest.assertTrue((boolean)this.mouseMan.isMousePressed(null));
        MousePollTest.assertTrue((boolean)this.mouseMan.isMouseClicked(this.actorAtClick));
        MousePollTest.assertTrue((boolean)this.mouseMan.isMouseClicked(null));
        MousePollTest.assertFalse((boolean)this.mouseMan.isMouseClicked(this.actorOutsideClick));
        MousePollTest.assertTrue((boolean)this.mouseMan.isMouseClicked(this.actorAtClick));
        MouseInfo mouseInfo = this.mouseMan.getMouseInfo();
        MousePollTest.assertEquals((int)1, (int)mouseInfo.getButton());
        MousePollTest.assertEquals((int)1, (int)mouseInfo.getClickCount());
        this.mouseMan.newActStarted();
        this.assertBlank();
        mouseInfo = this.mouseMan.getMouseInfo();
        MousePollTest.assertEquals((int)0, (int)mouseInfo.getClickCount());
    }

    public void testLongLeftClickOnActor() {
        this.mouseMan.newActStarted();
        this.assertBlank();
        MouseEvent event = new MouseEvent(this.panel, 501, System.currentTimeMillis(), 0, 5, 5, 1, false, 1);
        this.dispatch(event);
        this.assertBlank();
        this.mouseMan.newActStarted();
        MousePollTest.assertTrue((boolean)this.mouseMan.isMousePressed(this.actorAtClick));
        MousePollTest.assertFalse((boolean)this.mouseMan.isMouseClicked(this.actorAtClick));
        MousePollTest.assertFalse((boolean)this.mouseMan.isMousePressed(this.actorOutsideClick));
        MousePollTest.assertFalse((boolean)this.mouseMan.isMousePressed(this.world));
        MousePollTest.assertTrue((boolean)this.mouseMan.isMousePressed(null));
        MousePollTest.assertFalse((boolean)this.mouseMan.isMouseClicked(null));
        MousePollTest.assertTrue((boolean)this.mouseMan.isMousePressed(this.actorAtClick));
        MouseInfo mouseInfo = this.mouseMan.getMouseInfo();
        MousePollTest.assertEquals((int)1, (int)mouseInfo.getButton());
        MousePollTest.assertEquals((int)0, (int)mouseInfo.getClickCount());
        event = new MouseEvent(this.panel, 502, System.currentTimeMillis(), 0, 5, 5, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 500, System.currentTimeMillis(), 0, 5, 5, 1, false, 1);
        this.dispatch(event);
        this.mouseMan.newActStarted();
        MousePollTest.assertFalse((boolean)this.mouseMan.isMousePressed(this.actorAtClick));
        MousePollTest.assertFalse((boolean)this.mouseMan.isMousePressed(null));
        MousePollTest.assertTrue((boolean)this.mouseMan.isMouseClicked(this.actorAtClick));
        MousePollTest.assertTrue((boolean)this.mouseMan.isMouseClicked(null));
    }

    public void testSimpleMouseDraggedOnActor() {
        this.mouseMan.newActStarted();
        MouseEvent event = new MouseEvent(this.panel, 501, System.currentTimeMillis(), 0, 5, 5, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 506, System.currentTimeMillis(), 0, 6, 6, 1, false, 0);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 502, System.currentTimeMillis(), 0, 7, 8, 1, false, 1);
        this.dispatch(event);
        this.assertBlank();
        this.mouseMan.newActStarted();
        MousePollTest.assertTrue((boolean)this.mouseMan.isMouseDragEnded(this.actorAtClick));
        MousePollTest.assertFalse((boolean)this.mouseMan.isMouseDragged(this.actorAtClick));
        MousePollTest.assertTrue((boolean)this.mouseMan.isMousePressed(this.actorAtClick));
        MousePollTest.assertTrue((boolean)this.mouseMan.isMouseClicked(this.actorAtClick));
        MouseInfo info = this.mouseMan.getMouseInfo();
        MousePollTest.assertEquals((int)7, (int)info.getX());
        MousePollTest.assertEquals((int)8, (int)info.getY());
        this.mouseMan.newActStarted();
        this.assertBlank();
    }

    public void testLongMouseDraggedOnActor() {
        this.mouseMan.newActStarted();
        MouseEvent event = new MouseEvent(this.panel, 501, System.currentTimeMillis(), 0, 5, 5, 1, false, 1);
        this.dispatch(event);
        this.assertBlank();
        this.mouseMan.newActStarted();
        MousePollTest.assertTrue((boolean)this.mouseMan.isMousePressed(this.actorAtClick));
        this.mouseMan.newActStarted();
        MousePollTest.assertFalse((boolean)this.mouseMan.isMousePressed(this.actorAtClick));
        MousePollTest.assertNotNull((Object)this.mouseMan.getMouseInfo());
        event = new MouseEvent(this.panel, 506, System.currentTimeMillis(), 0, 6, 6, 1, false, 0);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 506, System.currentTimeMillis(), 0, 7, 7, 1, false, 0);
        this.dispatch(event);
        this.mouseMan.newActStarted();
        MousePollTest.assertTrue((boolean)this.mouseMan.isMouseDragged(this.actorAtClick));
        MousePollTest.assertTrue((this.mouseMan.getMouseInfo().getX() == 7 && this.mouseMan.getMouseInfo().getY() == 7 ? 1 : 0) != 0);
        event = new MouseEvent(this.panel, 506, System.currentTimeMillis(), 0, 8, 8, 1, false, 0);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 506, System.currentTimeMillis(), 0, 9, 9, 1, false, 0);
        this.dispatch(event);
        this.mouseMan.newActStarted();
        MousePollTest.assertTrue((boolean)this.mouseMan.isMouseDragged(this.actorAtClick));
        MousePollTest.assertTrue((this.mouseMan.getMouseInfo().getX() == 9 && this.mouseMan.getMouseInfo().getY() == 9 ? 1 : 0) != 0);
        this.mouseMan.newActStarted();
        MousePollTest.assertFalse((boolean)this.mouseMan.isMousePressed(this.actorAtClick));
        MousePollTest.assertFalse((boolean)this.mouseMan.isMouseDragged(this.actorAtClick));
        MousePollTest.assertNotNull((Object)this.mouseMan.getMouseInfo());
        event = new MouseEvent(this.panel, 502, System.currentTimeMillis(), 0, 14, 14, 1, false, 1);
        this.dispatch(event);
        this.mouseMan.newActStarted();
        MousePollTest.assertTrue((this.mouseMan.getMouseInfo().getX() == 14 && this.mouseMan.getMouseInfo().getY() == 14 ? 1 : 0) != 0);
        MousePollTest.assertTrue((boolean)this.mouseMan.isMouseDragEnded(this.actorAtClick));
        MousePollTest.assertFalse((boolean)this.mouseMan.isMouseClicked(this.actorAtClick));
    }

    public void testLongMouseMovedOnActor() {
        this.mouseMan.newActStarted();
        MouseEvent event = new MouseEvent(this.panel, 503, System.currentTimeMillis(), 0, 5, 5, 1, false, 1);
        this.dispatch(event);
        this.mouseMan.newActStarted();
        MousePollTest.assertTrue((boolean)this.mouseMan.isMouseMoved(this.actorAtClick));
        MousePollTest.assertTrue((boolean)this.mouseMan.isMouseMoved(null));
        MousePollTest.assertFalse((boolean)this.mouseMan.isMouseMoved(this.actorOutsideClick));
        MousePollTest.assertFalse((boolean)this.mouseMan.isMouseMoved(this.world));
        this.mouseMan.newActStarted();
        MousePollTest.assertFalse((boolean)this.mouseMan.isMouseMoved(this.actorAtClick));
        event = new MouseEvent(this.panel, 503, System.currentTimeMillis(), 0, 6, 6, 1, false, 1);
        this.dispatch(event);
        this.mouseMan.newActStarted();
        MousePollTest.assertTrue((boolean)this.mouseMan.isMouseMoved(this.actorAtClick));
        MousePollTest.assertFalse((boolean)this.mouseMan.isMouseClicked(this.actorAtClick));
    }

    public void testMultipleButtons() {
        Exception exception = null;
        try {
            MouseEvent event = new MouseEvent(this.panel, 501, System.currentTimeMillis(), 0, 5, 5, 1, false, 1);
            this.dispatch(event);
            event = new MouseEvent(this.panel, 506, System.currentTimeMillis(), 0, 6, 6, 1, false, 0);
            this.dispatch(event);
            event = new MouseEvent(this.panel, 501, System.currentTimeMillis(), 0, 5, 5, 1, false, 2);
            this.dispatch(event);
            event = new MouseEvent(this.panel, 506, System.currentTimeMillis(), 0, 6, 6, 1, false, 0);
            this.dispatch(event);
            event = new MouseEvent(this.panel, 506, System.currentTimeMillis(), 0, 6, 6, 1, false, 0);
            this.dispatch(event);
            event = new MouseEvent(this.panel, 502, System.currentTimeMillis(), 0, 7, 7, 1, false, 1);
            this.dispatch(event);
            event = new MouseEvent(this.panel, 506, System.currentTimeMillis(), 0, 6, 6, 1, false, 0);
            this.dispatch(event);
            this.mouseMan.newActStarted();
            this.mouseMan.isMouseClicked(null);
            this.mouseMan.isMousePressed(null);
            this.mouseMan.isMouseMoved(null);
            this.mouseMan.isMouseDragged(null);
            this.mouseMan.isMouseDragEnded(null);
            MouseInfo info = this.mouseMan.getMouseInfo();
            info.getActor();
            info.getX();
            info.getButton();
        }
        catch (Exception e) {
            exception = e;
        }
        MousePollTest.assertNull((Object)exception);
    }

    public void testButton2() {
        MouseEvent event = new MouseEvent(this.panel, 501, System.currentTimeMillis(), 0, 5, 5, 1, false, 2);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 506, System.currentTimeMillis(), 0, 6, 6, 0, false, 2);
        this.dispatch(event);
        this.mouseMan.newActStarted();
        MousePollTest.assertNotNull((Object)this.mouseMan.getMouseInfo());
        this.mouseMan.newActStarted();
        event = new MouseEvent(this.panel, 506, System.currentTimeMillis(), 0, 5, 5, 0, false, 0);
        this.dispatch(event);
        this.mouseMan.newActStarted();
        MousePollTest.assertNotNull((Object)this.mouseMan.getMouseInfo());
        event = new MouseEvent(this.panel, 506, System.currentTimeMillis(), 0, 8, 8, 0, false, 0);
        this.dispatch(event);
        this.mouseMan.newActStarted();
        MousePollTest.assertNotNull((Object)this.mouseMan.getMouseInfo());
        event = new MouseEvent(this.panel, 502, System.currentTimeMillis(), 0, 7, 7, 1, false, 2);
        this.dispatch(event);
        this.mouseMan.newActStarted();
        MousePollTest.assertTrue((boolean)this.mouseMan.isMouseDragEnded(this.actorAtClick));
    }

    public void testBigCellSize() {
        final World world = WorldCreator.createWorld(20, 20, 10);
        MousePollingManager mouseMan = new MousePollingManager(new WorldLocator(){

            @Override
            public Actor getTopMostActorAt(MouseEvent e) {
                Collection<Actor> actors = WorldVisitor.getObjectsAtPixel(world, e.getX(), e.getY());
                if (actors.isEmpty()) {
                    return null;
                }
                return actors.iterator().next();
            }

            @Override
            public int getTranslatedX(MouseEvent e) {
                return WorldVisitor.toCellFloor(world, e.getX());
            }

            @Override
            public int getTranslatedY(MouseEvent e) {
                return WorldVisitor.toCellFloor(world, e.getY());
            }
        });
        this.panel.addMouseListener(mouseMan);
        this.panel.addMouseMotionListener(mouseMan);
        this.panel.setEnabled(true);
        MouseEvent event = new MouseEvent(this.panel, 503, System.currentTimeMillis(), 0, 5, 5, 1, false, 1);
        this.dispatch(event);
        mouseMan.newActStarted();
        MousePollTest.assertTrue((boolean)mouseMan.isMouseMoved(null));
        event = new MouseEvent(this.panel, 503, System.currentTimeMillis(), 0, 55, 75, 1, false, 1);
        this.dispatch(event);
        mouseMan.newActStarted();
        MousePollTest.assertTrue((boolean)mouseMan.isMouseMoved(null));
        MouseInfo info = mouseMan.getMouseInfo();
        MousePollTest.assertEquals((int)5, (int)info.getX());
        MousePollTest.assertEquals((int)7, (int)info.getY());
    }

    public void testDragEndPriorities() {
        MouseEvent event = new MouseEvent(this.panel, 503, System.currentTimeMillis(), 0, 1, 5, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 501, System.currentTimeMillis(), 0, 2, 5, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 502, System.currentTimeMillis(), 0, 3, 5, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 500, System.currentTimeMillis(), 0, 4, 5, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 501, System.currentTimeMillis(), 0, 5, 2, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 506, System.currentTimeMillis(), 0, 6, 3, 1, false, 0);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 502, System.currentTimeMillis(), 0, 7, 8, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 503, System.currentTimeMillis(), 0, 8, 5, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 501, System.currentTimeMillis(), 0, 9, 5, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 502, System.currentTimeMillis(), 0, 1, 5, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 500, System.currentTimeMillis(), 0, 2, 4, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 501, System.currentTimeMillis(), 0, 3, 5, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 506, System.currentTimeMillis(), 0, 4, 5, 1, false, 0);
        this.dispatch(event);
        this.mouseMan.newActStarted();
        MouseInfo info = this.mouseMan.getMouseInfo();
        MousePollTest.assertEquals((int)7, (int)info.getX());
        MousePollTest.assertEquals((int)8, (int)info.getY());
        MousePollTest.assertTrue((boolean)this.mouseMan.isMouseDragEnded(this.actorAtClick));
        MousePollTest.assertTrue((boolean)this.mouseMan.isMouseClicked(this.actorAtClick));
        MousePollTest.assertFalse((boolean)this.mouseMan.isMouseMoved(this.actorAtClick));
        MousePollTest.assertFalse((boolean)this.mouseMan.isMouseDragged(this.actorAtClick));
        MousePollTest.assertTrue((boolean)this.mouseMan.isMousePressed(this.actorAtClick));
        event = new MouseEvent(this.panel, 501, System.currentTimeMillis(), 0, 5, 5, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 506, System.currentTimeMillis(), 0, 5, 5, 1, false, 0);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 502, System.currentTimeMillis(), 0, 6, 6, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 501, System.currentTimeMillis(), 0, 5, 5, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 506, System.currentTimeMillis(), 0, 5, 5, 1, false, 0);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 502, System.currentTimeMillis(), 0, 3, 3, 1, false, 1);
        this.dispatch(event);
        this.mouseMan.newActStarted();
        MousePollTest.assertTrue((boolean)this.mouseMan.isMouseDragEnded(this.actorAtClick));
        info = this.mouseMan.getMouseInfo();
        MousePollTest.assertEquals((int)3, (int)info.getX());
        MousePollTest.assertEquals((int)3, (int)info.getY());
        MousePollTest.assertFalse((boolean)this.mouseMan.isMouseMoved(this.actorAtClick));
        MousePollTest.assertFalse((boolean)this.mouseMan.isMouseDragged(this.actorAtClick));
        MousePollTest.assertTrue((boolean)this.mouseMan.isMousePressed(this.actorAtClick));
        MousePollTest.assertTrue((boolean)this.mouseMan.isMouseClicked(this.actorAtClick));
    }

    public void testClickPriorities() {
        MouseEvent event = new MouseEvent(this.panel, 503, System.currentTimeMillis(), 0, 5, 5, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 501, System.currentTimeMillis(), 0, 5, 5, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 502, System.currentTimeMillis(), 0, 5, 5, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 500, System.currentTimeMillis(), 0, 8, 8, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 503, System.currentTimeMillis(), 0, 5, 5, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 501, System.currentTimeMillis(), 0, 5, 5, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 506, System.currentTimeMillis(), 0, 5, 5, 1, false, 0);
        this.dispatch(event);
        this.mouseMan.newActStarted();
        MousePollTest.assertTrue((boolean)this.mouseMan.isMouseClicked(this.actorAtClick));
        MouseInfo info = this.mouseMan.getMouseInfo();
        MousePollTest.assertEquals((int)8, (int)info.getX());
        MousePollTest.assertEquals((int)8, (int)info.getY());
        MousePollTest.assertFalse((boolean)this.mouseMan.isMouseMoved(this.actorAtClick));
        MousePollTest.assertFalse((boolean)this.mouseMan.isMouseDragged(this.actorAtClick));
        MousePollTest.assertTrue((boolean)this.mouseMan.isMousePressed(this.actorAtClick));
        MousePollTest.assertFalse((boolean)this.mouseMan.isMouseDragEnded(this.actorAtClick));
        event = new MouseEvent(this.panel, 501, System.currentTimeMillis(), 0, 1, 5, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 502, System.currentTimeMillis(), 0, 2, 5, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 500, System.currentTimeMillis(), 0, 3, 7, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 501, System.currentTimeMillis(), 0, 4, 5, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 502, System.currentTimeMillis(), 0, 5, 5, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 500, System.currentTimeMillis(), 0, 6, 4, 1, false, 1);
        this.dispatch(event);
        this.mouseMan.newActStarted();
        info = this.mouseMan.getMouseInfo();
        MousePollTest.assertEquals((int)6, (int)info.getX());
        MousePollTest.assertEquals((int)4, (int)info.getY());
        MousePollTest.assertTrue((boolean)this.mouseMan.isMouseClicked(this.actorAtClick));
        MousePollTest.assertFalse((boolean)this.mouseMan.isMouseMoved(this.actorAtClick));
        MousePollTest.assertFalse((boolean)this.mouseMan.isMouseDragged(this.actorAtClick));
        MousePollTest.assertTrue((boolean)this.mouseMan.isMousePressed(this.actorAtClick));
        MousePollTest.assertFalse((boolean)this.mouseMan.isMouseDragEnded(this.actorAtClick));
    }

    public void testPressPriorities() {
        MouseEvent event = new MouseEvent(this.panel, 503, System.currentTimeMillis(), 0, 5, 5, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 502, System.currentTimeMillis(), 0, 5, 5, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 501, System.currentTimeMillis(), 0, 8, 8, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 502, System.currentTimeMillis(), 0, 5, 5, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 506, System.currentTimeMillis(), 0, 5, 5, 1, false, 0);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 503, System.currentTimeMillis(), 0, 5, 5, 1, false, 1);
        this.dispatch(event);
        this.mouseMan.newActStarted();
        MousePollTest.assertTrue((boolean)this.mouseMan.isMousePressed(this.actorAtClick));
        MouseInfo info = this.mouseMan.getMouseInfo();
        MousePollTest.assertEquals((int)8, (int)info.getX());
        MousePollTest.assertEquals((int)8, (int)info.getY());
        MousePollTest.assertFalse((boolean)this.mouseMan.isMouseMoved(this.actorAtClick));
        MousePollTest.assertFalse((boolean)this.mouseMan.isMouseDragged(this.actorAtClick));
        MousePollTest.assertFalse((boolean)this.mouseMan.isMouseClicked(this.actorAtClick));
        MousePollTest.assertFalse((boolean)this.mouseMan.isMouseDragEnded(this.actorAtClick));
        event = new MouseEvent(this.panel, 501, System.currentTimeMillis(), 0, 1, 6, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 502, System.currentTimeMillis(), 0, 2, 5, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 503, System.currentTimeMillis(), 0, 3, 5, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 501, System.currentTimeMillis(), 0, 4, 3, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 502, System.currentTimeMillis(), 0, 5, 5, 1, false, 1);
        this.dispatch(event);
        this.mouseMan.newActStarted();
        info = this.mouseMan.getMouseInfo();
        MousePollTest.assertEquals((int)4, (int)info.getX());
        MousePollTest.assertEquals((int)3, (int)info.getY());
        MousePollTest.assertTrue((boolean)this.mouseMan.isMousePressed(this.actorAtClick));
        MousePollTest.assertFalse((boolean)this.mouseMan.isMouseMoved(this.actorAtClick));
        MousePollTest.assertFalse((boolean)this.mouseMan.isMouseDragged(this.actorAtClick));
        MousePollTest.assertFalse((boolean)this.mouseMan.isMouseClicked(this.actorAtClick));
        MousePollTest.assertFalse((boolean)this.mouseMan.isMouseDragEnded(this.actorAtClick));
    }

    public void testDontKeepDataTillFirstClick() {
        MouseEvent event = new MouseEvent(this.panel, 503, System.currentTimeMillis(), 0, 5, 5, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 501, System.currentTimeMillis(), 0, 5, 5, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 502, System.currentTimeMillis(), 0, 5, 5, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 500, System.currentTimeMillis(), 0, 5, 5, 1, false, 1);
        this.dispatch(event);
        this.mouseMan.newActStarted();
        this.mouseMan.newActStarted();
        this.assertBlank();
        this.mouseMan.newActStarted();
        this.assertBlank();
    }

    public void testMoveClickWithinActor() {
        MouseEvent event = new MouseEvent(this.panel, 503, System.currentTimeMillis(), 0, 5, 5, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 501, System.currentTimeMillis(), 0, 5, 5, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 506, System.currentTimeMillis(), 0, 6, 6, 1, false, 0);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 502, System.currentTimeMillis(), 0, 6, 6, 1, false, 1);
        this.dispatch(event);
        this.mouseMan.newActStarted();
        MousePollTest.assertTrue((boolean)this.mouseMan.isMouseDragEnded(this.actorAtClick));
        MousePollTest.assertTrue((boolean)this.mouseMan.isMouseClicked(this.actorAtClick));
        MousePollTest.assertTrue((boolean)this.mouseMan.isMousePressed(this.actorAtClick));
        event = new MouseEvent(this.panel, 503, System.currentTimeMillis(), 0, 5, 5, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 501, System.currentTimeMillis(), 0, 5, 5, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 506, System.currentTimeMillis(), 0, 26, 26, 1, false, 0);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 502, System.currentTimeMillis(), 0, 26, 26, 1, false, 1);
        this.dispatch(event);
        this.mouseMan.newActStarted();
        MousePollTest.assertTrue((boolean)this.mouseMan.isMouseDragEnded(this.actorAtClick));
        MousePollTest.assertFalse((boolean)this.mouseMan.isMouseClicked(this.actorAtClick));
        MousePollTest.assertTrue((boolean)this.mouseMan.isMousePressed(this.actorAtClick));
        event = new MouseEvent(this.panel, 503, System.currentTimeMillis(), 0, 25, 25, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 501, System.currentTimeMillis(), 0, 25, 25, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 506, System.currentTimeMillis(), 0, 6, 6, 1, false, 0);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 502, System.currentTimeMillis(), 0, 6, 6, 1, false, 1);
        this.dispatch(event);
        this.mouseMan.newActStarted();
        MousePollTest.assertFalse((boolean)this.mouseMan.isMouseDragEnded(this.actorAtClick));
        MousePollTest.assertFalse((boolean)this.mouseMan.isMouseClicked(this.actorAtClick));
        MousePollTest.assertFalse((boolean)this.mouseMan.isMousePressed(this.actorAtClick));
    }

    public void testNullPressDragClickOnActorBounds() {
        MouseEvent event = new MouseEvent(this.panel, 503, System.currentTimeMillis(), 0, 5, 5, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 501, System.currentTimeMillis(), 0, 5, 5, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 506, System.currentTimeMillis(), 0, 26, 26, 1, false, 0);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 502, System.currentTimeMillis(), 0, 26, 26, 1, false, 1);
        this.dispatch(event);
        this.mouseMan.newActStarted();
        MousePollTest.assertTrue((boolean)this.mouseMan.isMouseDragEnded(null));
        MousePollTest.assertTrue((boolean)this.mouseMan.isMouseClicked(null));
        MousePollTest.assertTrue((boolean)this.mouseMan.isMousePressed(null));
        event = new MouseEvent(this.panel, 503, System.currentTimeMillis(), 0, 25, 25, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 501, System.currentTimeMillis(), 0, 25, 25, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 506, System.currentTimeMillis(), 0, 6, 6, 1, false, 0);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 502, System.currentTimeMillis(), 0, 6, 6, 1, false, 1);
        this.dispatch(event);
        this.mouseMan.newActStarted();
        MousePollTest.assertFalse((boolean)this.mouseMan.isMouseMoved(null));
        MousePollTest.assertTrue((boolean)this.mouseMan.isMouseDragEnded(null));
        MousePollTest.assertTrue((boolean)this.mouseMan.isMouseClicked(null));
        MousePollTest.assertTrue((boolean)this.mouseMan.isMousePressed(null));
        MousePollTest.assertTrue((boolean)this.mouseMan.isMousePressed(this.world));
        MousePollTest.assertTrue((boolean)this.mouseMan.isMouseDragEnded(this.world));
        MousePollTest.assertFalse((boolean)this.mouseMan.isMouseClicked(this.world));
        MousePollTest.assertFalse((boolean)this.mouseMan.isMousePressed(this.actorAtClick));
        MousePollTest.assertFalse((boolean)this.mouseMan.isMouseDragEnded(this.actorAtClick));
        MousePollTest.assertFalse((boolean)this.mouseMan.isMouseClicked(this.actorAtClick));
        MousePollTest.assertFalse((boolean)this.mouseMan.isMousePressed(this.actorAtClick));
    }

    public void testMultipleDragsInFrame() {
        MouseEvent event = new MouseEvent(this.panel, 503, System.currentTimeMillis(), 0, 5, 5, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 501, System.currentTimeMillis(), 0, 5, 5, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 506, System.currentTimeMillis(), 0, 26, 26, 1, false, 0);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 502, System.currentTimeMillis(), 0, 26, 26, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 503, System.currentTimeMillis(), 0, 25, 25, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 501, System.currentTimeMillis(), 0, 25, 25, 1, false, 1);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 506, System.currentTimeMillis(), 0, 6, 6, 1, false, 0);
        this.dispatch(event);
        event = new MouseEvent(this.panel, 502, System.currentTimeMillis(), 0, 6, 6, 1, false, 1);
        this.dispatch(event);
        this.mouseMan.newActStarted();
        MousePollTest.assertFalse((boolean)this.mouseMan.isMouseMoved(null));
        MousePollTest.assertTrue((boolean)this.mouseMan.isMouseDragEnded(null));
        MousePollTest.assertTrue((boolean)this.mouseMan.isMouseClicked(null));
        MousePollTest.assertTrue((boolean)this.mouseMan.isMousePressed(null));
        MousePollTest.assertTrue((boolean)this.mouseMan.isMousePressed(this.world));
        MousePollTest.assertTrue((boolean)this.mouseMan.isMouseDragEnded(this.world));
        MousePollTest.assertFalse((boolean)this.mouseMan.isMouseClicked(this.world));
        MousePollTest.assertFalse((boolean)this.mouseMan.isMousePressed(this.actorAtClick));
        MousePollTest.assertFalse((boolean)this.mouseMan.isMouseDragEnded(this.actorAtClick));
        MousePollTest.assertFalse((boolean)this.mouseMan.isMouseClicked(this.actorAtClick));
        MousePollTest.assertFalse((boolean)this.mouseMan.isMousePressed(this.actorAtClick));
    }
}

