/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.sound;

import greenfoot.sound.ClipData;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;

public class ClipCache {
    private LinkedHashMap<String, ClipData> freeClips = new LinkedHashMap();
    private int numberFreeClips = 0;
    private static int MAX_CACHED_CLIPS = 20;
    private Map<String, ClipData> cachedClips = new HashMap<String, ClipData>();

    public synchronized ClipData getCachedClip(URL url) throws IOException, UnsupportedAudioFileException {
        String urlStr = url.toString();
        ClipData data = this.cachedClips.get(urlStr);
        if (data == null && (data = (ClipData)this.freeClips.remove(urlStr)) != null) {
            --this.numberFreeClips;
            this.cachedClips.put(urlStr, data);
        }
        if (data == null) {
            AudioInputStream ais = AudioSystem.getAudioInputStream(url);
            AudioFormat af = ais.getFormat();
            long frameLength = ais.getFrameLength();
            int total = (int)((long)af.getFrameSize() * frameLength);
            byte[] allBytes = new byte[(int)((long)af.getFrameSize() * frameLength)];
            int pos = 0;
            try {
                while (pos < total) {
                    int r = ais.read(allBytes, pos, total - pos);
                    if (r == -1) {
                        break;
                    }
                    pos += r;
                }
            }
            finally {
                ais.close();
            }
            data = new ClipData(urlStr, allBytes, af, (int)frameLength);
        } else {
            data.addUser();
        }
        return data;
    }

    public synchronized void releaseClipData(ClipData data) {
        if (data.release()) {
            this.cachedClips.remove(data.getUrl());
            this.freeClips.put(data.getUrl(), data);
            ++this.numberFreeClips;
            if (this.numberFreeClips > MAX_CACHED_CLIPS) {
                Iterator<ClipData> it = this.freeClips.values().iterator();
                it.next();
                it.remove();
                this.numberFreeClips = MAX_CACHED_CLIPS;
            }
        }
    }
}

