/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.sound;

import greenfoot.sound.Sound;
import greenfoot.sound.SoundExceptionHandler;
import greenfoot.sound.SoundPlaybackListener;
import java.io.IOException;
import java.net.URL;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaEventListener;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Synthesizer;
import javax.sound.midi.Transmitter;

public class MidiFileSound
implements Sound {
    private URL url;
    private SoundPlaybackListener playbackListener;
    private Sequencer sequencer;
    private Synthesizer synthesizer;
    private Sequence sequence;
    private boolean pause = false;
    private int level;
    private Receiver receiver;

    private void printDebug(String s) {
    }

    public MidiFileSound(URL url, SoundPlaybackListener listener) {
        this.url = url;
        this.playbackListener = listener;
        try {
            this.sequence = MidiSystem.getSequence(url);
            this.sequencer = MidiSystem.getSequencer(false);
            this.synthesizer = MidiSystem.getSynthesizer();
            this.sequencer.addMetaEventListener(new MetaEventListener(){

                @Override
                public void meta(MetaMessage event) {
                    if (event.getType() == 47) {
                        MidiFileSound.this.close();
                    }
                }
            });
        }
        catch (InvalidMidiDataException e) {
            SoundExceptionHandler.handleInvalidMidiDataException(e, url.toString());
        }
        catch (IOException e) {
            SoundExceptionHandler.handleIOException(e, url.toString());
        }
        catch (MidiUnavailableException e) {
            SoundExceptionHandler.handleLineUnavailableException(e);
        }
    }

    @Override
    public synchronized void play() {
        this.sequencer.setLoopCount(0);
        if (!this.isPlaying()) {
            this.startPlayback();
        }
    }

    private synchronized void startPlayback() {
        try {
            this.pause = false;
            this.open();
            this.sequencer.setSequence(this.sequence);
            if (this.sequencer.isOpen()) {
                this.sequencer.start();
                this.playbackListener.playbackStarted(this);
            }
        }
        catch (SecurityException e) {
            SoundExceptionHandler.handleSecurityException(e, this.url.toString());
        }
        catch (InvalidMidiDataException e) {
            SoundExceptionHandler.handleInvalidMidiDataException(e, this.url.toString());
        }
    }

    private synchronized void open() {
        try {
            if (!this.sequencer.isOpen()) {
                this.receiver = MidiSystem.getReceiver();
                this.synthesizer.open();
                this.sequencer.open();
                Transmitter seqTransmitter = this.sequencer.getTransmitter();
                seqTransmitter.setReceiver(this.receiver);
            }
        }
        catch (MidiUnavailableException e) {
            SoundExceptionHandler.handleLineUnavailableException(e);
        }
    }

    @Override
    public synchronized void loop() {
        this.sequencer.setLoopStartPoint(0L);
        this.sequencer.setLoopEndPoint(-1L);
        this.sequencer.setLoopCount(-1);
        this.startPlayback();
    }

    @Override
    public synchronized void pause() {
        this.pause = true;
        this.sequencer.stop();
        this.playbackListener.playbackPaused(this);
    }

    @Override
    public synchronized void stop() {
        this.pause = false;
        this.close();
    }

    @Override
    public synchronized void close() {
        this.playbackListener.playbackStopped(this);
        this.pause = false;
        this.printDebug(" playback ended: " + this.url);
        if (this.sequencer != null) {
            this.sequencer.close();
        }
        if (this.synthesizer != null) {
            this.synthesizer.close();
        }
        this.playbackListener.soundClosed(this);
    }

    @Override
    public synchronized boolean isPaused() {
        return this.pause;
    }

    @Override
    public synchronized boolean isPlaying() {
        return this.sequencer.isRunning();
    }

    @Override
    public synchronized boolean isStopped() {
        return !this.isPaused() && !this.isPlaying();
    }

    @Override
    public void setVolume(int level) {
        this.open();
        this.level = level;
        ShortMessage volMessage = new ShortMessage();
        int i = 0;
        while (i < 16) {
            try {
                volMessage.setMessage(176, i, 7, level);
            }
            catch (InvalidMidiDataException e) {
                e.printStackTrace();
            }
            this.receiver.send(volMessage, -1L);
            ++i;
        }
    }

    @Override
    public int getVolume() {
        return this.level;
    }
}

