/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.sound;

import bluej.utility.Debug;
import greenfoot.sound.AudioLine;
import greenfoot.sound.GreenfootAudioInputStream;
import greenfoot.sound.Sound;
import greenfoot.sound.SoundExceptionHandler;
import greenfoot.sound.SoundPlaybackListener;
import greenfoot.sound.SoundUtils;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;

public class SoundStream
implements Sound,
Runnable {
    private static final int CLOSE_TIMEOUT = 1000;
    private boolean loop = false;
    private boolean stop = true;
    private boolean pause = false;
    private boolean restart = false;
    private boolean stopped = true;
    private final GreenfootAudioInputStream inputStream;
    private final SoundPlaybackListener playbackListener;
    private volatile AudioLine line;
    private AudioFormat format;
    private DataLine.Info info;
    private Thread playThread;

    private static void printDebug(String s) {
    }

    public SoundStream(GreenfootAudioInputStream inputStream, SoundPlaybackListener playbackListener) {
        this.playbackListener = playbackListener;
        this.inputStream = inputStream;
        try {
            this.format = inputStream.getFormat();
            this.info = new DataLine.Info(SourceDataLine.class, this.format);
            this.line = this.initialiseLine(this.info, this.format);
        }
        catch (IllegalArgumentException e) {
            SoundExceptionHandler.handleIllegalArgumentException(e, inputStream.getSource());
        }
        catch (LineUnavailableException e) {
            SoundExceptionHandler.handleLineUnavailableException(e);
        }
    }

    @Override
    public synchronized void play() {
        if (this.isPlaying()) {
            this.loop = false;
        } else {
            this.startPlayback();
        }
    }

    @Override
    public synchronized void loop() {
        this.loop = true;
        if (!this.isPlaying()) {
            this.startPlayback();
        }
    }

    private void startPlayback() {
        if (!this.pause) {
            this.restart = true;
            if (this.playThread == null) {
                SoundStream.printDebug("Starting new playthread");
                this.playThread = new Thread((Runnable)this, "SoundStream:" + this.inputStream.getSource());
                this.playThread.start();
            }
            if (this.line != null) {
                this.line.reset();
            }
        }
        this.stopped = false;
        this.pause = false;
        this.stop = false;
        if (this.line != null) {
            this.line.start();
        }
        this.notifyAll();
        this.playbackListener.playbackStarted(this);
    }

    @Override
    public synchronized void close() {
        if (this.line != null) {
            this.reset();
            this.line.close();
            this.notifyAll();
            this.playbackListener.playbackStopped(this);
        }
    }

    @Override
    public synchronized void stop() {
        if (!this.stop) {
            this.stop = true;
            this.stopped = true;
            this.pause = false;
            this.line.reset();
            this.notifyAll();
            this.playbackListener.playbackStopped(this);
        }
    }

    @Override
    public synchronized void pause() {
        if (!this.stopped && !this.pause) {
            this.line.stop();
            this.pause = true;
            this.notifyAll();
            this.playbackListener.playbackPaused(this);
        }
    }

    @Override
    public synchronized boolean isPlaying() {
        return !this.stopped && !this.pause;
    }

    @Override
    public synchronized boolean isStopped() {
        return this.stopped && !this.pause;
    }

    @Override
    public synchronized boolean isPaused() {
        return this.pause;
    }

    public String toString() {
        return String.valueOf(this.inputStream.getSource()) + " " + super.toString();
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private synchronized void doPause() {
        if (this.pause) {
            while (this.pause) {
                try {
                    SoundStream.printDebug("In pause loop");
                    this.line.stop();
                    SoundStream.printDebug("In pause loop 2");
                    this.wait();
                }
                catch (InterruptedException e) {
                    Debug.reportError((String)("Interrupted while pausing sound: " + this.inputStream.getSource()), (Throwable)e);
                }
            }
            this.line.start();
        }
    }

    private AudioLine initialiseLine(DataLine.Info info, AudioFormat format) throws LineUnavailableException, IllegalArgumentException {
        SourceDataLine l = (SourceDataLine)AudioSystem.getLine(info);
        SoundStream.printDebug("buffer size: " + l.getBufferSize());
        return new AudioLine(l, format);
    }

    private synchronized void reset() {
        this.stopped = true;
        this.pause = false;
        this.loop = false;
        this.stop = true;
        this.playThread = null;
    }

    public long getLongFramePosition() {
        return this.line.getLongFramePosition();
    }

    @Override
    public void setVolume(int level) {
        this.line.setVolume(SoundUtils.logToLin(level));
    }

    @Override
    public int getVolume() {
        return this.line.getVolume();
    }
}

