/*
 * Decompiled with CFR 0.152.
 */
package org.bluej.extensions.submitter.properties;

import org.bluej.extensions.submitter.properties.Tokenizer;

public class CompilationException
extends Exception {
    private Tokenizer token;
    private String filename;

    public CompilationException(String errorMessage, Tokenizer token) {
        super(errorMessage);
        this.token = token;
        this.filename = null;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        String line = this.token.getCurrentLine();
        if (this.filename != null) {
            buf.append("In file " + this.filename + " ");
        }
        if (line == null) {
            buf.append("Error at end of file: " + this.getMessage() + "\n");
        } else {
            buf.append("Error in line " + this.token.getLineNumber() + ": " + this.getMessage() + "\n" + line + "\n");
            int n = this.token.getLinePosition();
            for (int i = 0; i < n; ++i) {
                buf.append(' ');
            }
            buf.append("^\n");
        }
        return buf.toString();
    }

    public String getSimpleString() {
        StringBuffer buf = new StringBuffer();
        String line = this.token.getCurrentLine();
        if (this.filename != null) {
            buf.append("In " + this.filename + " ");
        }
        if (line == null) {
            buf.append("Error at end of file: " + this.getMessage() + "\n");
        } else {
            buf.append("Error in line " + this.token.getLineNumber() + ": " + this.getMessage());
        }
        return buf.toString();
    }

    public void addFilename(String filename) {
        this.filename = filename;
    }
}

