/*
 * Decompiled with CFR 0.152.
 */
package sdoc;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.text.JTextComponent;

public final class Gutter
extends JLabel {
    private JTextComponent edit;
    private int rhWidth = 40;

    public Gutter(JTextComponent edit, JScrollPane pane) {
        this.edit = edit;
        edit.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("font")) {
                    Gutter.this.revalidate();
                    Gutter.this.repaint();
                }
            }
        });
        this.setBackground(Color.GRAY);
        this.setForeground(Color.GRAY.darker());
        pane.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent e) {
                Gutter.this.revalidate();
                Gutter.this.repaint();
            }
        });
    }

    public Dimension getPreferredSize() {
        int w;
        FontMetrics fm = this.edit.getFontMetrics(this.edit.getFont());
        int h = fm.getHeight();
        this.rhWidth = w = fm.stringWidth(String.valueOf(this.edit.getHeight() / h)) + 6;
        int hi = (int)this.edit.getPreferredSize().getHeight();
        return new Dimension(w, hi);
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        g2d.setFont(this.edit.getFont());
        FontMetrics fm = g2d.getFontMetrics();
        Rectangle rec = this.edit.getVisibleRect();
        int h = fm.getHeight();
        int row = rec.y / h;
        int i = h - fm.getDescent();
        i += h * row;
        int max = row + rec.height / h + 2;
        while (row < max) {
            String s = String.valueOf(Integer.toString(row + 1)) + "  ";
            g2d.drawString(s, this.rhWidth + 9 - fm.stringWidth(s), i);
            i += h;
            ++row;
        }
        g2d.setColor(Color.GRAY.darker());
        g2d.drawLine(this.getWidth() - 3, rec.y, this.getWidth() - 3, rec.height + rec.y);
    }
}

