/*
 * Decompiled with CFR 0.152.
 */
package sdoc;

import java.util.List;
import java.util.Map;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.GapContent;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import javax.swing.text.Segment;
import sdoc.SimpleStyle;
import sdoc.SyntaxSupport;
import sdoc.lexers.Lexer;
import sdoc.util.DynamicIntArray;

public class SyntaxDocument
extends PlainDocument {
    private DynamicIntArray endTokens = new DynamicIntArray(500);
    private Segment seg = new Segment();
    private Map styleMap;
    private int syntaxType;
    private Lexer lexer;
    private JTextComponent comp;

    SyntaxDocument(int syntaxType, Map styleMap, JTextComponent comp) {
        super(new GapContent());
        this.putProperty("tabSize", new Integer(4));
        this.endTokens.add(0);
        this.styleMap = styleMap;
        this.comp = comp;
        this.lexer = SyntaxSupport.getInstance().getLexerForType(syntaxType);
    }

    public SimpleStyle getStyleForType(int type) {
        return (SimpleStyle)this.styleMap.get(new Integer(type));
    }

    public void setSyntaxType(int type) {
        this.syntaxType = type;
        this.lexer = SyntaxSupport.getInstance().getLexerForType(type);
        this.styleMap = SyntaxSupport.getInstance().getStyleMapForType(type);
        try {
            this.comp.setText(this.getText(0, this.getLength()));
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public int getSyntaxType() {
        return this.syntaxType;
    }

    protected void fireInsertUpdate(DocumentEvent e) {
        int previousTokenType;
        Element lineMap = this.getDefaultRootElement();
        DocumentEvent.ElementChange change = e.getChange(lineMap);
        Element[] added = change == null ? null : change.getChildrenAdded();
        int numLines = lineMap.getElementCount();
        int line = lineMap.getElementIndex(e.getOffset());
        int previousLine = line - 1;
        int n = previousTokenType = previousLine > -1 ? this.endTokens.get(previousLine) : 0;
        if (added != null && added.length > 0) {
            Element[] removed = change.getChildrenRemoved();
            int numRemoved = removed != null ? removed.length : 0;
            int endBefore = line + added.length - numRemoved;
            int i = line;
            while (i < endBefore) {
                this.setSharedSegment(i);
                int tokenType = this.lexer.getLastTokenTypeOnLine(this.seg, previousTokenType);
                this.endTokens.add(i, tokenType);
                previousTokenType = tokenType;
                ++i;
            }
            this.updateLastTokensBelow(endBefore, numLines, previousTokenType);
        } else {
            this.updateLastTokensBelow(line, numLines, previousTokenType);
        }
        super.fireInsertUpdate(e);
    }

    protected void fireRemoveUpdate(DocumentEvent chng) {
        Element[] removed;
        Element lineMap = this.getDefaultRootElement();
        int numLines = lineMap.getElementCount();
        DocumentEvent.ElementChange change = chng.getChange(lineMap);
        Element[] elementArray = removed = change == null ? null : change.getChildrenRemoved();
        if (removed != null && removed.length > 0) {
            int line = change.getIndex();
            int previousLine = line - 1;
            int previousTokenType = previousLine > -1 ? this.endTokens.get(previousLine) : 0;
            Element[] added = change.getChildrenAdded();
            int numAdded = added == null ? 0 : added.length;
            int endBefore = line + removed.length - numAdded;
            this.endTokens.removeRange(line, endBefore);
            this.updateLastTokensBelow(line, numLines, previousTokenType);
        } else {
            int line = lineMap.getElementIndex(chng.getOffset());
            if (line >= this.endTokens.getSize()) {
                return;
            }
            int previousLine = line - 1;
            int previousTokenType = previousLine > -1 ? this.endTokens.get(previousLine) : 0;
            this.updateLastTokensBelow(line, numLines, previousTokenType);
        }
        super.fireRemoveUpdate(chng);
    }

    private final void setSharedSegment(int line) {
        Element map = this.getDefaultRootElement();
        int numLines = map.getElementCount();
        Element element = map.getElement(line);
        if (element == null) {
            throw new InternalError("Invalid line number: " + line);
        }
        int startOffset = element.getStartOffset();
        int endOffset = line == numLines - 1 ? element.getEndOffset() - 1 : element.getEndOffset() - 1;
        try {
            this.getText(startOffset, endOffset - startOffset, this.seg);
        }
        catch (BadLocationException ble) {
            throw new InternalError("Text range not in document: " + startOffset + "-" + endOffset);
        }
    }

    private int updateLastTokensBelow(int line, int numLines, int previousTokenType) {
        int firstLine = line;
        int end = numLines - 1;
        while (line < end) {
            this.setSharedSegment(line);
            int oldTokenType = this.endTokens.get(line);
            int newTokenType = this.lexer.getLastTokenTypeOnLine(this.seg, previousTokenType);
            if (oldTokenType == newTokenType) {
                this.damageRange(firstLine, line);
                return line;
            }
            this.endTokens.set(line, newTokenType);
            previousTokenType = newTokenType;
            ++line;
        }
        if (line > firstLine) {
            this.damageRange(firstLine, line);
        }
        return line;
    }

    private void damageRange(int firstLine, int lastLine) {
        Element f = this.getDefaultRootElement().getElement(firstLine);
        Element e = this.getDefaultRootElement().getElement(lastLine);
        this.comp.getUI().damageRange(this.comp, f.getStartOffset(), e.getEndOffset());
    }

    public final List getTokenListForLine(int line) {
        Element map = this.getDefaultRootElement();
        Element elem = map.getElement(line);
        int startOffset = elem.getStartOffset();
        int endOffset = elem.getEndOffset() - 1;
        try {
            this.getText(startOffset, endOffset - startOffset, this.seg);
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
            return null;
        }
        int initialTokenType = 0;
        if (line > 0) {
            initialTokenType = this.endTokens.get(line - 1);
        }
        return this.lexer.getTokens(this.seg, initialTokenType, startOffset);
    }
}

