/*
 * Decompiled with CFR 0.152.
 */
package sdoc.lexers.tokens.ui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import javax.swing.text.JTextComponent;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import sdoc.SimpleStyle;
import sdoc.SyntaxDocument;
import sdoc.SyntaxSupport;
import sdoc.lexers.tokens.Token;
import sdoc.lexers.tokens.ui.TokenUI;

public class SyntaxTokenUI
implements TokenUI {
    private Rectangle2D.Float rect = new Rectangle2D.Float();

    public float paint(Graphics2D g, float x, float y, JTextComponent comp, TabExpander e, Token token) {
        SyntaxDocument doc = (SyntaxDocument)comp.getDocument();
        SimpleStyle style = doc.getStyleForType(token.type);
        g.setColor(style.fg);
        g.setBackground(style.bg);
        g.setFont(comp.getFont());
        this.setFont(g, style);
        Segment seg = new Segment(token.data.toCharArray(), 0, token.data.length());
        return Utilities.drawTabbedText(seg, (int)x, (int)y, (Graphics)g, e, 0);
    }

    private void setFont(Graphics2D g2d, SimpleStyle style) {
        SyntaxSupport config = SyntaxSupport.getInstance();
        Object hint = RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT;
        int aa = config.getForceAATextArea();
        if (aa == SyntaxSupport.FORCE_AA_ALWAYS_ON) {
            hint = RenderingHints.VALUE_TEXT_ANTIALIAS_ON;
        } else if (aa == SyntaxSupport.FORCE_AA_ALWAYS_OFF) {
            hint = RenderingHints.VALUE_TEXT_ANTIALIAS_OFF;
        }
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, hint);
        if (style.bold) {
            g2d.setFont(g2d.getFont().deriveFont(1));
        }
        if (style.italic) {
            g2d.setFont(g2d.getFont().deriveFont(2));
            if (config.getForceAAItalics() == SyntaxSupport.FORCE_AA_ALWAYS_ON.intValue()) {
                g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            } else if (config.getForceAAItalics() == SyntaxSupport.FORCE_AA_ALWAYS_OFF.intValue()) {
                g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            }
        }
    }

    public void paintBackground(float x, float y, float width, float height, Graphics2D g, int fontAscent, JTextComponent comp, Color color) {
        g.setXORMode(comp.getBackground());
        g.setColor(color);
        this.rect.setRect(x, y - (float)fontAscent, width, height);
        g.fill(this.rect);
        g.setPaintMode();
    }
}

