/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io.archive.tar;

import de.schlichtherle.io.archive.Archive;
import de.schlichtherle.io.archive.spi.InputArchive;
import de.schlichtherle.io.archive.spi.OutputArchive;
import de.schlichtherle.io.archive.tar.ReadAheadInputStream;
import de.schlichtherle.io.archive.tar.TarDriver;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.tools.bzip2.CBZip2InputStream;
import org.apache.tools.bzip2.CBZip2OutputStream;

public class TarBZip2Driver
extends TarDriver {
    public TarBZip2Driver() {
        super("US-ASCII", null, null);
    }

    public TarBZip2Driver(String string) {
        super(string, null, null);
    }

    public InputArchive createInputArchive(Archive archive, InputStream inputStream) throws IOException {
        return super.createInputArchive(archive, (InputStream)TarBZip2Driver.createVerifiedBZip2InputStream(inputStream));
    }

    private static CBZip2InputStream createVerifiedBZip2InputStream(InputStream inputStream) throws IOException {
        ReadAheadInputStream readAheadInputStream = new ReadAheadInputStream(inputStream, 4);
        byte[] byArray = new byte[4];
        readAheadInputStream.readFully(byArray);
        readAheadInputStream.unread(byArray, 2, 2);
        if (byArray[0] != 66 || byArray[1] != 90 || byArray[2] != 104 || 49 > byArray[3] || byArray[3] > 57) {
            throw new IOException("Not a BZIP2 compressed input stream!");
        }
        return new CBZip2InputStream((InputStream)readAheadInputStream);
    }

    public OutputArchive createOutputArchive(Archive archive, OutputStream outputStream, InputArchive inputArchive) throws IOException {
        outputStream.write(new byte[]{66, 90});
        return super.createOutputArchive(archive, (OutputStream)new CBZip2OutputStream(outputStream), inputArchive);
    }
}

