/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io.archive.tar;

import de.schlichtherle.io.archive.Archive;
import de.schlichtherle.io.archive.spi.AbstractArchiveDriver;
import de.schlichtherle.io.archive.spi.ArchiveEntry;
import de.schlichtherle.io.archive.spi.InputArchive;
import de.schlichtherle.io.archive.spi.OutputArchive;
import de.schlichtherle.io.archive.tar.TarEntry;
import de.schlichtherle.io.archive.tar.TarInputArchive;
import de.schlichtherle.io.archive.tar.TarOutputArchive;
import de.schlichtherle.io.rof.ReadOnlyFile;
import de.schlichtherle.io.rof.ReadOnlyFileInputStream;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.Icon;

public class TarDriver
extends AbstractArchiveDriver {
    public static final String ENCODING = "US-ASCII";

    public TarDriver() {
        super(ENCODING, null, null);
    }

    public TarDriver(String string) {
        super(string, null, null);
    }

    public TarDriver(String string, Icon icon, Icon icon2) {
        super(string, icon, icon2);
    }

    public ArchiveEntry createArchiveEntry(Archive archive, String string, ArchiveEntry archiveEntry) throws CharConversionException {
        TarEntry tarEntry;
        this.ensureEncodable(string);
        if (archiveEntry != null) {
            if (archiveEntry instanceof TarEntry) {
                tarEntry = new TarEntry(string, (TarEntry)archiveEntry);
            } else {
                tarEntry = new TarEntry(string);
                tarEntry.setTime(archiveEntry.getTime());
            }
        } else {
            tarEntry = new TarEntry(string);
        }
        return tarEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputArchive createInputArchive(Archive archive, ReadOnlyFile readOnlyFile) throws IOException {
        ReadOnlyFileInputStream readOnlyFileInputStream = new ReadOnlyFileInputStream(readOnlyFile);
        try {
            InputArchive inputArchive = this.createInputArchive(archive, readOnlyFileInputStream);
            return inputArchive;
        }
        finally {
            ((InputStream)readOnlyFileInputStream).close();
        }
    }

    public InputArchive createInputArchive(Archive archive, InputStream inputStream) throws IOException {
        return new TarInputArchive(archive, inputStream);
    }

    public OutputArchive createOutputArchive(Archive archive, OutputStream outputStream, InputArchive inputArchive) throws IOException {
        return new TarOutputArchive(outputStream);
    }
}

