/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io.archive.tar;

import de.schlichtherle.io.File;
import de.schlichtherle.io.InputArchiveMetaData;
import de.schlichtherle.io.archive.Archive;
import de.schlichtherle.io.archive.spi.ArchiveEntry;
import de.schlichtherle.io.archive.spi.InputArchive;
import de.schlichtherle.io.archive.tar.ReadAheadInputStream;
import de.schlichtherle.io.archive.tar.TarEntry;
import de.schlichtherle.io.util.Path;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.apache.tools.tar.TarConstants;
import org.apache.tools.tar.TarInputStream;
import org.apache.tools.tar.TarUtils;

public class TarInputArchive
implements InputArchive,
TarConstants {
    private static final byte[] empty;
    private static final int CHECKSUM_OFFSET = 148;
    private final Map entries = new HashMap();
    private InputArchiveMetaData metaData;
    static final /* synthetic */ boolean $assertionsDisabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TarInputArchive(Archive archive, InputStream inputStream) throws IOException {
        TarInputStream tarInputStream = TarInputArchive.createValidatedTarInputStream(inputStream);
        try {
            org.apache.tools.tar.TarEntry tarEntry;
            while ((tarEntry = tarInputStream.getNextEntry()) != null) {
                Object object;
                java.io.File file = java.io.File.createTempFile("tar", null);
                boolean bl = file.delete();
                if (!$assertionsDisabled && !bl) {
                    throw new AssertionError();
                }
                if (tarEntry.isDirectory()) {
                    bl = file.mkdirs();
                } else {
                    object = new FileOutputStream(file);
                    try {
                        File.cat((InputStream)tarInputStream, (OutputStream)object);
                    }
                    finally {
                        ((FileOutputStream)object).close();
                    }
                }
                if (!file.setLastModified(tarEntry.getModTime().getTime())) {
                    throw new FileNotFoundException(archive.getPath() + "/" + tarEntry.getName());
                }
                object = new TarEntry(file);
                object.setName(Path.normalize(tarEntry.getName(), '/'));
                this.entries.put(object.getName(), object);
            }
        }
        catch (IOException iOException) {
            this.close();
            throw iOException;
        }
    }

    private static TarInputStream createValidatedTarInputStream(InputStream inputStream) throws IOException {
        ReadAheadInputStream readAheadInputStream = new ReadAheadInputStream(inputStream, 512);
        byte[] byArray = new byte[512];
        readAheadInputStream.readFully(byArray);
        readAheadInputStream.unread(byArray);
        if (!Arrays.equals(byArray, empty)) {
            long l = TarUtils.parseOctal((byte[])byArray, (int)148, (int)8);
            for (int i = 0; i < 8; ++i) {
                byArray[148 + i] = 32;
            }
            long l2 = TarUtils.computeCheckSum((byte[])byArray);
            if (l != l2) {
                throw new IOException("Illegal initial record in TAR file: Expected checksum " + l + ", is " + l2 + "!");
            }
        }
        return new TarInputStream((InputStream)readAheadInputStream, 10240, 512);
    }

    public int getNumArchiveEntries() {
        return this.entries.size();
    }

    public Enumeration getArchiveEntries() {
        return Collections.enumeration(this.entries.values());
    }

    public ArchiveEntry getArchiveEntry(String string) {
        return (TarEntry)this.entries.get(string);
    }

    public InputStream getInputStream(ArchiveEntry archiveEntry, ArchiveEntry archiveEntry2) throws IOException {
        return new FileInputStream(((TarEntry)archiveEntry).getFile());
    }

    public void close() throws IOException {
        Enumeration enumeration = this.getArchiveEntries();
        while (enumeration.hasMoreElements()) {
            TarEntry tarEntry = (TarEntry)enumeration.nextElement();
            java.io.File file = tarEntry.getFile();
            if (!file.exists() || file.delete()) continue;
            file.deleteOnExit();
        }
    }

    public InputArchiveMetaData getMetaData() {
        return this.metaData;
    }

    public void setMetaData(InputArchiveMetaData inputArchiveMetaData) {
        this.metaData = inputArchiveMetaData;
    }

    static {
        $assertionsDisabled = !TarInputArchive.class.desiredAssertionStatus();
        empty = new byte[512];
    }
}

