/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io.archive.zip;

import de.schlichtherle.io.File;
import de.schlichtherle.io.OutputArchiveMetaData;
import de.schlichtherle.io.archive.spi.ArchiveEntry;
import de.schlichtherle.io.archive.spi.OutputArchive;
import de.schlichtherle.io.archive.spi.OutputArchiveBusyException;
import de.schlichtherle.io.archive.zip.Zip32Entry;
import de.schlichtherle.io.archive.zip.Zip32InputArchive;
import de.schlichtherle.util.zip.ZipOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;

public class Zip32OutputArchive
extends ZipOutputStream
implements OutputArchive {
    private final Zip32InputArchive source;
    private OutputArchiveMetaData metaData;
    static /* synthetic */ Class class$de$schlichtherle$io$archive$zip$Zip32OutputArchive;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Zip32OutputArchive(OutputStream outputStream, String string, Zip32InputArchive zip32InputArchive) throws NullPointerException, UnsupportedEncodingException, IOException {
        super(outputStream, string);
        this.setLevel(9);
        this.source = zip32InputArchive;
        if (zip32InputArchive != null) {
            this.setComment(zip32InputArchive.getComment());
            if (zip32InputArchive.getPreambleLength() > 0L) {
                InputStream inputStream = zip32InputArchive.getPreambleInputStream();
                try {
                    File.cat(inputStream, zip32InputArchive.offsetsConsiderPreamble() ? this : outputStream);
                }
                finally {
                    inputStream.close();
                }
            }
        }
    }

    public int getNumArchiveEntries() {
        return this.size();
    }

    public Enumeration getArchiveEntries() {
        return this.entries();
    }

    public ArchiveEntry getArchiveEntry(String string) {
        return (Zip32Entry)this.getEntry(string);
    }

    public OutputStream getOutputStream(ArchiveEntry archiveEntry, ArchiveEntry archiveEntry2) throws IOException {
        if (this.busy()) {
            throw new OutputArchiveBusyException(archiveEntry);
        }
        Zip32Entry zip32Entry = (Zip32Entry)archiveEntry;
        if (archiveEntry2 instanceof Zip32Entry) {
            Zip32Entry zip32Entry2 = (Zip32Entry)archiveEntry2;
            zip32Entry.setCrc(zip32Entry2.getCrc());
            zip32Entry.setCompressedSize(zip32Entry2.getCompressedSize());
            zip32Entry.setSize(zip32Entry2.getSize());
        }
        return this.createEntryOutputStream(zip32Entry, archiveEntry2);
    }

    protected OutputStream createEntryOutputStream(Zip32Entry zip32Entry, ArchiveEntry archiveEntry) throws IOException {
        return new EntryOutputStream(zip32Entry, !(archiveEntry instanceof Zip32Entry));
    }

    public void storeDirectory(ArchiveEntry archiveEntry) throws IOException {
        Zip32Entry zip32Entry = (Zip32Entry)archiveEntry;
        zip32Entry.setMethod((short)0);
        zip32Entry.setCrc(0L);
        zip32Entry.setSize(0L);
        this.putNextEntry(zip32Entry);
        this.closeEntry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() throws IOException {
        super.finish();
        if (this.source == null) {
            return;
        }
        long l = this.source.getPostambleLength();
        if (l <= 0L) {
            return;
        }
        long l2 = this.source.length();
        long l3 = this.length();
        InputStream inputStream = this.source.getPostambleInputStream();
        try {
            if (l3 + l != l2) {
                this.write(new byte[(int)(l3 % 4L)]);
            }
            File.cat(inputStream, this);
        }
        finally {
            inputStream.close();
        }
    }

    public OutputArchiveMetaData getMetaData() {
        return this.metaData;
    }

    public void setMetaData(OutputArchiveMetaData outputArchiveMetaData) {
        this.metaData = outputArchiveMetaData;
    }

    protected class EntryOutputStream
    extends FilterOutputStream {
        static final /* synthetic */ boolean $assertionsDisabled;

        public EntryOutputStream(Zip32Entry zip32Entry, boolean bl) throws IOException {
            super(Zip32OutputArchive.this);
            Zip32OutputArchive.this.putNextEntry(zip32Entry, bl);
        }

        public void write(int n) throws IOException {
            this.out.write(n);
        }

        public void write(byte[] byArray) throws IOException {
            this.out.write(byArray);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.out.write(byArray, n, n2);
        }

        public void close() throws IOException {
            if (!$assertionsDisabled && this.out != Zip32OutputArchive.this) {
                throw new AssertionError();
            }
            Zip32OutputArchive.this.closeEntry();
        }

        static {
            $assertionsDisabled = !(class$de$schlichtherle$io$archive$zip$Zip32OutputArchive == null ? (class$de$schlichtherle$io$archive$zip$Zip32OutputArchive = Zip32OutputArchive.class$("de.schlichtherle.io.archive.zip.Zip32OutputArchive")) : class$de$schlichtherle$io$archive$zip$Zip32OutputArchive).desiredAssertionStatus();
        }
    }
}

