/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.swing;

import de.schlichtherle.swing.event.PanelEvent;
import de.schlichtherle.swing.event.PanelListener;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.EventListener;
import javax.swing.JPanel;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.EventListenerList;

public class EnhancedPanel
extends JPanel {
    private final ComponentListener cl = new ComponentAdapter(){

        public void componentShown(ComponentEvent componentEvent) {
            EnhancedPanel.this.getToolkit().getSystemEventQueue().postEvent(new PanelEvent(EnhancedPanel.this, 2000));
        }

        public void componentHidden(ComponentEvent componentEvent) {
            EnhancedPanel.this.getToolkit().getSystemEventQueue().postEvent(new PanelEvent(EnhancedPanel.this, 2001));
        }
    };
    private transient EventListenerList listenerList;
    static final /* synthetic */ boolean $assertionsDisabled;

    public EnhancedPanel(LayoutManager layoutManager, boolean bl) {
        super(layoutManager, bl);
        this.init();
    }

    public EnhancedPanel(LayoutManager layoutManager) {
        super(layoutManager);
        this.init();
    }

    public EnhancedPanel(boolean bl) {
        super(bl);
        this.init();
    }

    public EnhancedPanel() {
        this.init();
    }

    private void init() {
        this.addAncestorListener(new AncestorListener(){

            public void ancestorAdded(AncestorEvent ancestorEvent) {
                Window window = EnhancedPanel.getAncestorWindow(ancestorEvent.getAncestor());
                window.addComponentListener(EnhancedPanel.this.cl);
                if (window.isVisible()) {
                    EnhancedPanel.this.cl.componentShown(null);
                }
            }

            public void ancestorRemoved(AncestorEvent ancestorEvent) {
                Window window = EnhancedPanel.getAncestorWindow(ancestorEvent.getAncestor());
                window.removeComponentListener(EnhancedPanel.this.cl);
                if (!window.isVisible()) {
                    EnhancedPanel.this.cl.componentHidden(null);
                }
            }

            public void ancestorMoved(AncestorEvent ancestorEvent) {
            }
        });
    }

    protected AWTEvent coalesceEvents(AWTEvent aWTEvent, AWTEvent aWTEvent2) {
        if (!$assertionsDisabled && aWTEvent.getSource() != aWTEvent2.getSource()) {
            throw new AssertionError();
        }
        if (aWTEvent instanceof PanelEvent && aWTEvent2 instanceof PanelEvent) {
            int n = aWTEvent2.getID();
            if (!$assertionsDisabled && n != aWTEvent.getID()) {
                throw new AssertionError();
            }
            switch (n) {
                case 2000: 
                case 2001: {
                    return aWTEvent2;
                }
            }
        }
        return super.coalesceEvents(aWTEvent, aWTEvent2);
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof PanelEvent) {
            this.processPanelEvent((PanelEvent)aWTEvent);
        } else {
            super.processEvent(aWTEvent);
        }
    }

    protected void processPanelEvent(PanelEvent panelEvent) {
        switch (panelEvent.getID()) {
            case 2000: {
                this.fireAncestorWindowShown(panelEvent);
                break;
            }
            case 2001: {
                this.fireAncestorWindowHidden(panelEvent);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    public Window getAncestorWindow() {
        return EnhancedPanel.getAncestorWindow(this);
    }

    private static final Window getAncestorWindow(Component component) {
        while (component != null && !(component instanceof Window)) {
            component = component.getParent();
        }
        return (Window)component;
    }

    public void addPanelListener(PanelListener panelListener) {
        if (panelListener == null) {
            throw new NullPointerException();
        }
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(PanelListener.class, panelListener);
    }

    public void removePanelListener(PanelListener panelListener) {
        if (panelListener == null) {
            throw new NullPointerException();
        }
        if (this.listenerList == null) {
            return;
        }
        this.listenerList.remove(PanelListener.class, panelListener);
    }

    public PanelListener[] getPanelListeners() {
        if (this.listenerList != null) {
            return (PanelListener[])this.listenerList.getListeners(PanelListener.class);
        }
        return new PanelListener[0];
    }

    public EventListener[] getListeners(Class clazz) {
        if (clazz == PanelListener.class) {
            return this.getPanelListeners();
        }
        return super.getListeners(clazz);
    }

    protected void fireAncestorWindowShown(PanelEvent panelEvent) {
        if (this.listenerList == null) {
            return;
        }
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$de$schlichtherle$swing$event$PanelListener == null ? EnhancedPanel.class$("de.schlichtherle.swing.event.PanelListener") : class$de$schlichtherle$swing$event$PanelListener)) continue;
            ((PanelListener)objectArray[i + 1]).ancestorWindowShown(panelEvent);
        }
    }

    protected void fireAncestorWindowHidden(PanelEvent panelEvent) {
        if (this.listenerList == null) {
            return;
        }
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$de$schlichtherle$swing$event$PanelListener == null ? EnhancedPanel.class$("de.schlichtherle.swing.event.PanelListener") : class$de$schlichtherle$swing$event$PanelListener)) continue;
            ((PanelListener)objectArray[i + 1]).ancestorWindowHidden(panelEvent);
        }
    }

    static {
        $assertionsDisabled = !EnhancedPanel.class.desiredAssertionStatus();
    }
}

