/*
 * Decompiled with CFR 0.152.
 */
package jode.flow;

import jode.AssertError;
import jode.decompiler.LocalInfo;
import jode.expr.Expression;
import jode.expr.LocalLoadOperator;
import jode.flow.SpecialBlock;

public class VariableStack {
    public static final VariableStack EMPTY = new VariableStack();
    final LocalInfo[] stackMap;

    public boolean isEmpty() {
        return this.stackMap.length == 0;
    }

    public VariableStack pop(int n) {
        LocalInfo[] localInfoArray = new LocalInfo[this.stackMap.length - n];
        System.arraycopy(this.stackMap, 0, localInfoArray, 0, this.stackMap.length - n);
        return new VariableStack(localInfoArray);
    }

    public VariableStack push(LocalInfo localInfo) {
        return this.poppush(0, localInfo);
    }

    public VariableStack poppush(int n, LocalInfo localInfo) {
        LocalInfo[] localInfoArray = new LocalInfo[this.stackMap.length - n + 1];
        System.arraycopy(this.stackMap, 0, localInfoArray, 0, this.stackMap.length - n);
        localInfoArray[this.stackMap.length - n] = localInfo;
        return new VariableStack(localInfoArray);
    }

    public VariableStack peek(int n) {
        LocalInfo[] localInfoArray = new LocalInfo[n];
        System.arraycopy(this.stackMap, this.stackMap.length - n, localInfoArray, 0, n);
        return new VariableStack(localInfoArray);
    }

    public void merge(VariableStack variableStack) {
        if (this.stackMap.length != variableStack.stackMap.length) {
            throw new IllegalArgumentException("stack length differs");
        }
        int n = 0;
        while (n < this.stackMap.length) {
            if (this.stackMap[n].getType().stackSize() != variableStack.stackMap[n].getType().stackSize()) {
                throw new IllegalArgumentException("stack element length differs at " + n);
            }
            this.stackMap[n].combineWith(variableStack.stackMap[n]);
            ++n;
        }
    }

    public static VariableStack merge(VariableStack variableStack, VariableStack variableStack2) {
        if (variableStack == null) {
            return variableStack2;
        }
        if (variableStack2 == null) {
            return variableStack;
        }
        variableStack.merge(variableStack2);
        return variableStack;
    }

    public Expression mergeIntoExpression(Expression expression) {
        int n = this.stackMap.length - 1;
        while (n >= 0) {
            expression = expression.addOperand(new LocalLoadOperator(this.stackMap[n].getType(), null, this.stackMap[n]));
            --n;
        }
        return expression;
    }

    public VariableStack executeSpecial(SpecialBlock specialBlock) {
        if (specialBlock.type == SpecialBlock.POP) {
            int n = 0;
            int n2 = this.stackMap.length;
            while (n < specialBlock.count) {
                n += this.stackMap[--n2].getType().stackSize();
            }
            if (n != specialBlock.count) {
                throw new IllegalArgumentException("wrong POP");
            }
            LocalInfo[] localInfoArray = new LocalInfo[n2];
            System.arraycopy(this.stackMap, 0, localInfoArray, 0, n2);
            return new VariableStack(localInfoArray);
        }
        if (specialBlock.type == SpecialBlock.DUP) {
            int n = 0;
            int n3 = 0;
            int n4 = this.stackMap.length;
            while (n < specialBlock.count) {
                ++n3;
                n += this.stackMap[--n4].getType().stackSize();
            }
            if (n != specialBlock.count) {
                throw new IllegalArgumentException("wrong DUP");
            }
            int n5 = n4;
            int n6 = 0;
            while (n6 < specialBlock.depth) {
                n6 += this.stackMap[--n5].getType().stackSize();
            }
            if (n6 != specialBlock.depth) {
                throw new IllegalArgumentException("wrong DUP");
            }
            LocalInfo[] localInfoArray = new LocalInfo[this.stackMap.length + n3];
            System.arraycopy(this.stackMap, 0, localInfoArray, 0, n5);
            System.arraycopy(this.stackMap, n4, localInfoArray, n5, n3);
            System.arraycopy(this.stackMap, n5, localInfoArray, n5 + n3, n4 - n5);
            System.arraycopy(this.stackMap, n4, localInfoArray, n4 + n3, n3);
            return new VariableStack(localInfoArray);
        }
        if (specialBlock.type == SpecialBlock.SWAP) {
            LocalInfo[] localInfoArray = new LocalInfo[this.stackMap.length];
            System.arraycopy(this.stackMap, 0, localInfoArray, 0, this.stackMap.length - 2);
            if (this.stackMap[this.stackMap.length - 2].getType().stackSize() != 1 || this.stackMap[this.stackMap.length - 1].getType().stackSize() != 1) {
                throw new IllegalArgumentException("wrong SWAP");
            }
            localInfoArray[this.stackMap.length - 2] = this.stackMap[this.stackMap.length - 1];
            localInfoArray[this.stackMap.length - 1] = this.stackMap[this.stackMap.length - 2];
            return new VariableStack(localInfoArray);
        }
        throw new AssertError("Unknown SpecialBlock");
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[");
        int n = 0;
        while (n < this.stackMap.length) {
            if (n > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.stackMap[n].getName());
            ++n;
        }
        return stringBuffer.append("]").toString();
    }

    private VariableStack() {
        this.stackMap = new LocalInfo[0];
    }

    private VariableStack(LocalInfo[] localInfoArray) {
        this.stackMap = localInfoArray;
    }
}

