/*
 * Decompiled with CFR 0.152.
 */
package jode.obfuscator.modules;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import jode.obfuscator.ClassIdentifier;
import jode.obfuscator.FieldIdentifier;
import jode.obfuscator.Identifier;
import jode.obfuscator.LocalIdentifier;
import jode.obfuscator.MethodIdentifier;
import jode.obfuscator.PackageIdentifier;
import jode.obfuscator.Renamer;

public class NameSwapper
implements Renamer {
    private Random rand;
    private Set packs;
    private Set clazzes;
    private Set methods;
    private Set fields;
    private Set locals;

    public final Collection getCollection(Identifier identifier) {
        if (identifier instanceof PackageIdentifier) {
            return this.packs;
        }
        if (identifier instanceof ClassIdentifier) {
            return this.clazzes;
        }
        if (identifier instanceof MethodIdentifier) {
            return this.methods;
        }
        if (identifier instanceof FieldIdentifier) {
            return this.fields;
        }
        if (identifier instanceof LocalIdentifier) {
            return this.locals;
        }
        throw new IllegalArgumentException(identifier.getClass().getName());
    }

    public final void addIdentifierName(Identifier identifier) {
        this.getCollection(identifier).add(identifier.getName());
    }

    public Iterator generateNames(Identifier identifier) {
        NameSwapper nameSwapper = this;
        if (nameSwapper == null) {
            throw null;
        }
        return nameSwapper.new NameGenerator(this.getCollection(identifier));
    }

    public NameSwapper(boolean bl, long l) {
        if (bl) {
            this.fields = this.locals = new HashSet();
            this.methods = this.locals;
            this.clazzes = this.locals;
            this.packs = this.locals;
        } else {
            this.packs = new HashSet();
            this.clazzes = new HashSet();
            this.methods = new HashSet();
            this.fields = new HashSet();
            this.locals = new HashSet();
        }
    }

    public NameSwapper(boolean bl) {
        this(bl, System.currentTimeMillis());
    }

    private class NameGenerator
    implements Iterator {
        Collection pool;

        public boolean hasNext() {
            return true;
        }

        public Object next() {
            int n = NameSwapper.this.rand.nextInt(this.pool.size());
            Iterator iterator = this.pool.iterator();
            while (n > 0) {
                iterator.next();
            }
            return (String)iterator.next();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        NameGenerator(Collection collection) {
            this.pool = collection;
        }
    }
}

