/* This is a rexx program to make a small .htm file to run an applet */
'@echo off'

parse arg classFile targetFile

/* Get just the name of the class file, and the target file */

className = filespec("name", classFile)
targetName = filespec("name", targetFile)

/* Get the two names, without their extensions */
a = lastpos(".", className)
if (a \= 0) then do
    classNoExt = strip(left(className, a-1))
end
else do
    classNoExt = strip(className)
end

a = lastpos(".", targetName)
if (a \= 0) then do
    targetNoExt = strip(left(targetName, a-1))
end
else do
    targetNoExt = strip(targetName)
end


/* We only generate htm file for .class file with name that matches the
   target .htm file name
*/
if (translate(classNoExt) \= translate(targetNoExt)) then
    exit 0

/* Delete the target file */
'if exist 'targetfile' del 'targetFile' > null'

say "Writing target file "targetFile

/* Fully qualify targetFile */
targetFile = filespec("path", classFile)targetFile

/* Open the target file */
rc = stream(targetFile, "C", "OPEN")

/* Write out the file */
rc = lineout(targetFile, "<h1>Test Applet for class "className"</h1>")
rc = lineout(targetFile, "<applet code="classNoExt" width=600 height=400>")
rc = lineout(targetfile, "</applet>")

/* Close the target file */

rc = stream(targetFile, "C", "CLOSE")

exit 0

