/*
 * Copyright (c) 1996 IBM Corp. All Rights Reserved.
 */

import java.awt.*;
import java.awt.image.*;
import java.lang.*;
import java.util.*;

/**
** This class provides the means for a GUI programmer to describe layout
** constraints to a PMLayout manager for a Component.
** The only PM constraints are x,y,cx,cy which are coordinates,width
** and height in java world coordinates means top left corner for x,y;
**<p>
*/
public class PMConstraint extends Object {

  /**
  ** Internal instance variable specifying this constraints associated Component
  */
   protected Component component;

  /**
  ** public bounding    value
  */

  public int x;
  public int y;
  public int cx;
  public int cy;

  /**
  ** Return important state information in a String
  */
   public String toString() {

      return "PMConstraint[ ["
          + (String)((component != null)
                    ? component.toString()
                    : "null") + "\n\n"

          + "   x = " + x
          + "   y = " + y
          + "   cx = " + cx
          + "   cy = " + cy ;

   }


  /**
  ** Construct a PMConstraint with a default constructor
  */
   public PMConstraint() {

   }
  /**
  ** Construct a PMConstraint with a copy constructor
  */

   public PMConstraint(PMConstraint PMc) {
      //
      component        = PMc.component;
      x                = PMc.x;
      y                = PMc.y;
      cx               = PMc.cx;
      cy               = PMc.cy;
   }

   public void setBounds(int in_x,int in_y,int in_cx,int in_cy) {
          x = in_x;
          y = in_y;
          cx= in_cx;
          cy= in_cy;
   }
   public Rectangle bounds() {
       return new Rectangle(x,y,cx,cy);
   }

}
