/* IconCanvas: This class draws an Icon view.  It is used by the */
/*    DataContainer class.                                       */

package extend.awt;

import java.awt.*;

public class IconCanvas extends Canvas {

   protected IconCanvas (DataContainer dc) {

      setBackground (Color.white);

      parent = dc;
   }

   public void paint (Graphics g) {

      FontMetrics fm = getFontMetrics (getFont ());
      int lHeight = fm.getHeight ();
      ContainerItem item = parent.getRoot ();
      int which = -1; 
      int lines = -1;
      int y = 0;
      String [] text = null;
      Dimension textBox = null;
      Dimension itemBox = null;
      int ix = 0;
      int iy = 0;
      int left = size ().width;
      int tx = 0;
      int ty = 0;
      int dy = 0;

      parent.clearHotSpotList ();
      parent.drawDataArea (g, 0, size ());

      if (item != null)
         item = item.getFirst ();

      while ((item != null) && (y < size ().height)) {

         text = splitLine (item.textFor ());
         textBox = lineSpan (text, fm);
         itemBox = iconSpan (item.getImage (), text, fm);
         itemBox.width += 4;

         if (left + itemBox.width > size ().width) {

            which++;
            left = 4;

            if (which >= parent.getFirst ()) {

               y += dy;
               dy = 0;

               if (y < size ().height)
                  lines++;
            }
         }

         if (which >= parent.getFirst ()) {

            ty = y;

            if (item.getImage () == null) {

               ix = 40;
               iy = 40;

            } else {

               ix = item.getImage ().getWidth (this);
               iy = item.getImage ().getHeight (this);

               if (ix < 1) ix = 40;
               if (iy < 1) iy = 40;
            }

            tx = left + ((itemBox.width - ix) / 2);

            if (item.isSelected ()) {

               g.setColor (new Color (0, 0, 64));
               g.fillRect (tx, ty + 4, ix, iy);
            }

            parent.addHotSpot (tx, ty + 4, ix, iy, item,
                               DataContainer.Selectable, this);

            if (item.getImage () != null)
               g.drawImage (item.getImage (), tx, ty + 4, this);

            ty += iy + 2;

            if (item.isSelected ()) {

               g.setColor (new Color (0, 0, 64));
               g.fillRect (left + ((itemBox.width - textBox.width) / 2),
                           ty + 4, textBox.width, textBox.height);
               g.setColor (Color.white);

            } else
               g.setColor (Color.black);

            parent.addHotSpot (left + ((itemBox.width - textBox.width) / 2) + 2,
                               ty, textBox.width, textBox.height, item,
                               DataContainer.Selectable, this);

            for (int loop = 0; loop < text.length; loop++) {

               tx = left + ((itemBox.width - fm.stringWidth (text [loop])) / 2);
               ty += lHeight;

               g.drawString (text [loop], tx, ty);
            }

            ty += 2;
            dy = Math.max (dy, ty - y);

         }

         left += itemBox.width + 8;

         item = item.getNext ();
      }

      if (y + dy < size ().height)
         lines++;

      parent.setLines (lines);
   }

   protected Dimension iconSpan (Image image, String [] list, FontMetrics fm) {

      Dimension result = lineSpan (list, fm);

      if (image == null) {

         result.height += 42;
         result.width = Math.max (result.width, 40);

      } else {

         result.height += image.getHeight (this) + 2;
         result.width = Math.max (result.width, image.getWidth (this));
      }

      return result;
   }

   private Dimension lineSpan (String [] list, FontMetrics fm) {

      int w = 0;

      for (int loop = 0; loop < list.length; loop++)
         w = Math.max (w, fm.stringWidth (list [loop]));

      return new Dimension (w, fm.getHeight () * list.length);
   }

   protected String [] splitLine (String source) {

      String [] result = null;
      int lines = 1;
      int start = 0;

      while (source.indexOf ('\n', start) > -1) {

         lines++;
         start = source.indexOf ('\n', start) + 1;
      }

      result = new String [lines];
      start = 0;

      for (int loop = 0; loop < lines - 1; loop++) {

         result [loop] = source.substring (start, source.indexOf ('\n', start));
         start = source.indexOf ('\n', start) + 1;
      }

      result [lines - 1] = source.substring (start);

      return result;
   }

   DataContainer parent;
}
