/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.svn;

import org.tmatesoft.svn.cli.svn.SVNCommandEnvironment;
import org.tmatesoft.svn.core.internal.util.SVNFormatUtil;
import org.tmatesoft.svn.core.internal.wc.SVNTreeConflictUtil;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusType;

public class SVNStatusPrinter {
    private SVNCommandEnvironment myEnvironment;

    public SVNStatusPrinter(SVNCommandEnvironment env) {
        this.myEnvironment = env;
    }

    public void printStatus(String path, SVNStatus status, boolean detailed, boolean showLastCommitted, boolean skipUnrecognized, boolean showReposLocks) {
        if (status == null || skipUnrecognized && status.getEntry() == null && status.getTreeConflict() == null || status.getContentsStatus() == SVNStatusType.STATUS_NONE && status.getRemoteContentsStatus() == SVNStatusType.STATUS_NONE) {
            return;
        }
        char treeStatusCode = ' ';
        String treeDescriptionLine = "";
        if (status.getTreeConflict() != null) {
            String description = SVNTreeConflictUtil.getHumanReadableConflictDescription(status.getTreeConflict());
            treeStatusCode = 'C';
            treeDescriptionLine = "\n      >   " + description;
        }
        StringBuffer result = new StringBuffer();
        if (detailed) {
            char lockStatus;
            String wcRevision = status.getEntry() == null ? "" : (!status.getRevision().isValid() ? " ? " : (status.isCopied() ? "-" : Long.toString(status.getRevision().getNumber())));
            char remoteStatus = status.getRemotePropertiesStatus() != SVNStatusType.STATUS_NONE || status.getRemoteContentsStatus() != SVNStatusType.STATUS_NONE ? (char)'*' : ' ';
            if (showReposLocks) {
                lockStatus = status.getRemoteLock() != null ? (status.getLocalLock() != null ? (status.getLocalLock().getID().equals(status.getRemoteLock().getID()) ? (char)'K' : 'T') : (char)'O') : (status.getLocalLock() != null ? (char)'B' : ' ');
            } else {
                char c = lockStatus = status.getLocalLock() != null ? (char)'K' : ' ';
            }
            if (showLastCommitted) {
                String commitRevision = "";
                String commitAuthor = "";
                if (status.getEntry() != null && status.getCommittedRevision().isValid()) {
                    commitRevision = status.getCommittedRevision().toString();
                } else if (status.getEntry() != null) {
                    commitRevision = " ? ";
                }
                if (status.getEntry() != null && status.getAuthor() != null) {
                    commitAuthor = status.getAuthor();
                } else if (status.getEntry() != null) {
                    commitAuthor = " ? ";
                }
                result.append(status.getContentsStatus().getCode());
                result.append(status.getPropertiesStatus().getCode());
                result.append(status.isLocked() ? (char)'L' : ' ');
                result.append(status.isCopied() ? (char)'+' : ' ');
                result.append(SVNStatusPrinter.getSwitchCharacter(status));
                result.append(lockStatus);
                result.append(treeStatusCode);
                result.append(" ");
                result.append(remoteStatus);
                result.append("   ");
                result.append(SVNFormatUtil.formatString(wcRevision, 6, false));
                result.append("   ");
                result.append(SVNFormatUtil.formatString(commitRevision, 6, false));
                result.append(" ");
                result.append(SVNFormatUtil.formatString(commitAuthor, 12, true));
                result.append(" ");
                result.append(path);
                result.append(treeDescriptionLine);
            } else {
                result.append(status.getContentsStatus().getCode());
                result.append(status.getPropertiesStatus().getCode());
                result.append(status.isLocked() ? (char)'L' : ' ');
                result.append(status.isCopied() ? (char)'+' : ' ');
                result.append(SVNStatusPrinter.getSwitchCharacter(status));
                result.append(lockStatus);
                result.append(treeStatusCode);
                result.append(" ");
                result.append(remoteStatus);
                result.append("   ");
                result.append(SVNFormatUtil.formatString(wcRevision, 6, false));
                result.append("   ");
                result.append(path);
                result.append(treeDescriptionLine);
            }
        } else {
            result.append(status.getContentsStatus().getCode());
            result.append(status.getPropertiesStatus().getCode());
            result.append(status.isLocked() ? (char)'L' : ' ');
            result.append(status.isCopied() ? (char)'+' : ' ');
            result.append(SVNStatusPrinter.getSwitchCharacter(status));
            result.append(status.getLocalLock() != null ? (char)'K' : ' ');
            result.append(treeStatusCode);
            result.append(" ");
            result.append(path);
            result.append(treeDescriptionLine);
        }
        this.myEnvironment.getOut().println(result);
    }

    private static char getSwitchCharacter(SVNStatus status) {
        if (status == null) {
            return ' ';
        }
        return (char)(status.isSwitched() ? 83 : (status.isFileExternal() ? 88 : 32));
    }
}

