/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.svnadmin;

import java.util.Collection;
import java.util.LinkedList;
import org.tmatesoft.svn.cli.SVNCommandUtil;
import org.tmatesoft.svn.cli.svnadmin.SVNAdminCommand;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.wc.ISVNOptions;

public class SVNAdminListLocksCommand
extends SVNAdminCommand {
    public SVNAdminListLocksCommand() {
        super("lslocks", null);
    }

    protected Collection createSupportedOptions() {
        return new LinkedList();
    }

    public void run() throws SVNException {
        ISVNOptions options = this.getEnvironment().getClientManager().getOptions();
        SVNURL url = SVNURL.fromFile(this.getLocalRepository());
        SVNRepository repository = SVNRepositoryFactory.create(url);
        repository.setCanceller(this.getEnvironment());
        SVNLock[] locks = repository.getLocks("/");
        for (int i = 0; locks != null && i < locks.length; ++i) {
            SVNLock lock = locks[i];
            StringBuffer buffer = new StringBuffer();
            String comment = "(0 lines):";
            if (lock.getComment() != null) {
                int count = SVNCommandUtil.getLinesCount(lock.getComment());
                comment = count != 1 ? count + " lines" : count + " line";
                comment = "(" + comment + "):\n" + lock.getComment();
            }
            String created = lock.getCreationDate() != null ? SVNDate.formatHumanDate(lock.getCreationDate(), options) : "";
            String expires = lock.getExpirationDate() != null ? SVNDate.formatHumanDate(lock.getExpirationDate(), options) : "";
            buffer.append("Path: " + lock.getPath() + "\n");
            buffer.append("UUID Token: " + lock.getID() + "\n");
            buffer.append("Owner: " + lock.getOwner() + "\n");
            buffer.append("Created: " + created + "\n");
            buffer.append("Expires: " + expires + "\n");
            buffer.append("Comment " + comment + "\n\n");
            this.getEnvironment().getOut().print(buffer.toString());
        }
    }
}

