/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.svnversion;

import java.io.InputStream;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.tmatesoft.svn.cli.AbstractSVNCommand;
import org.tmatesoft.svn.cli.AbstractSVNCommandEnvironment;
import org.tmatesoft.svn.cli.AbstractSVNOption;
import org.tmatesoft.svn.cli.SVNCommandLine;
import org.tmatesoft.svn.cli.SVNOptionValue;
import org.tmatesoft.svn.cli.svnversion.SVNVersionCommand;
import org.tmatesoft.svn.cli.svnversion.SVNVersionOption;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

public class SVNVersionCommandEnvironment
extends AbstractSVNCommandEnvironment {
    private boolean myIsHelp;
    private boolean myIsVersion;
    private boolean myIsCommitted;
    private boolean myIsNoNewLine;

    public SVNVersionCommandEnvironment(String programName, PrintStream out, PrintStream err, InputStream in) {
        super(programName, out, err, in);
    }

    public boolean isHelp() {
        return this.myIsHelp;
    }

    public boolean isVersion() {
        return this.myIsVersion;
    }

    public boolean isCommitted() {
        return this.myIsCommitted;
    }

    public boolean isNoNewLine() {
        return this.myIsNoNewLine;
    }

    protected ISVNAuthenticationManager createClientAuthenticationManager() {
        return SVNWCUtil.createDefaultAuthenticationManager();
    }

    protected DefaultSVNOptions createClientOptions() {
        return SVNWCUtil.createDefaultOptions(true);
    }

    protected void initOption(SVNOptionValue optionValue) throws SVNException {
        AbstractSVNOption option = optionValue.getOption();
        if (option == SVNVersionOption.COMMITTED) {
            this.myIsCommitted = true;
        } else if (option == SVNVersionOption.NO_NEWLINE) {
            this.myIsNoNewLine = true;
        } else if (option == SVNVersionOption.HELP) {
            this.myIsHelp = true;
        } else if (option == SVNVersionOption.VERSION) {
            this.myIsVersion = true;
        }
    }

    protected String refineCommandName(String commandName, SVNCommandLine commandLine) throws SVNException {
        Iterator options = commandLine.optionValues();
        while (options.hasNext()) {
            SVNOptionValue optionValue = (SVNOptionValue)options.next();
            AbstractSVNOption option = optionValue.getOption();
            if (option == SVNVersionOption.HELP) {
                this.myIsHelp = true;
                continue;
            }
            if (option != SVNVersionOption.VERSION) continue;
            this.myIsVersion = true;
        }
        if (this.myIsHelp) {
            List<String> newArguments = commandName != null ? Collections.singletonList(commandName) : Collections.EMPTY_LIST;
            this.setArguments(newArguments);
            return "help";
        }
        if (this.isVersion()) {
            SVNVersionCommand versionCommand = new SVNVersionCommand(){

                protected Collection createSupportedOptions() {
                    LinkedList<SVNVersionOption> options = new LinkedList<SVNVersionOption>();
                    options.add(SVNVersionOption.VERSION);
                    return options;
                }

                public void run() throws SVNException {
                    AbstractSVNCommand helpCommand = AbstractSVNCommand.getCommand("help");
                    helpCommand.init(SVNVersionCommandEnvironment.this);
                    helpCommand.run();
                }

                public String getName() {
                    return "--version";
                }
            };
            AbstractSVNCommand.registerCommand(versionCommand);
            return "--version";
        }
        return "";
    }

    protected String getCommandLineClientName() {
        return "svnversion";
    }
}

