/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.util.Map;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.util.SVNURLUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNStatusEditor;
import org.tmatesoft.svn.core.io.ISVNReporter;
import org.tmatesoft.svn.core.io.ISVNReporterBaton;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNStatusReporter
implements ISVNReporterBaton,
ISVNReporter {
    private ISVNReporter myReporter;
    private ISVNReporterBaton myBaton;
    private SVNURL myCommonAncestorLocation;
    private SVNRepository myRepository;
    private SVNURL myRepositoryRoot;
    private Map myLocks;
    private SVNStatusEditor myEditor;

    public SVNStatusReporter(SVNRepository repos, ISVNReporterBaton baton, SVNStatusEditor editor) {
        this.myBaton = baton;
        this.myRepository = repos;
        this.myCommonAncestorLocation = repos.getLocation();
        this.myEditor = editor;
        this.myLocks = new SVNHashMap();
    }

    public SVNLock getLock(SVNURL url) {
        String root;
        if (this.myRepositoryRoot == null || this.myLocks.isEmpty() || url == null) {
            return null;
        }
        String urlString = url.getPath();
        String path = urlString.equals(root = this.myRepositoryRoot.getPath()) ? "/" : urlString.substring(root.length());
        return (SVNLock)this.myLocks.get(path);
    }

    public void report(ISVNReporter reporter) throws SVNException {
        this.myReporter = reporter;
        this.myBaton.report(this);
    }

    public void setPath(String path, String lockToken, long revision, boolean startEmpty) throws SVNException {
        this.setPath(path, lockToken, revision, SVNDepth.INFINITY, startEmpty);
    }

    public void deletePath(String path) throws SVNException {
        this.myReporter.deletePath(path);
    }

    public void linkPath(SVNURL url, String path, String lockToken, long revision, boolean startEmpty) throws SVNException {
        this.linkPath(url, path, lockToken, revision, SVNDepth.INFINITY, startEmpty);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishReport() throws SVNException {
        SVNLock[] locks = null;
        SVNURL oldLocation = this.myRepository.getLocation();
        try {
            this.myRepositoryRoot = this.myRepository.getRepositoryRoot(true);
            this.myRepository.setLocation(this.myCommonAncestorLocation, false);
            locks = this.myRepository.getLocks("");
        }
        catch (SVNException e) {
            if (e.getErrorMessage() == null || e.getErrorMessage().getErrorCode() != SVNErrorCode.RA_NOT_IMPLEMENTED) {
                throw e;
            }
        }
        finally {
            this.myRepository.setLocation(oldLocation, false);
            this.myRepository.closeSession();
        }
        if (locks != null) {
            for (int i = 0; i < locks.length; ++i) {
                SVNLock lock = locks[i];
                this.myLocks.put(lock.getPath(), lock);
            }
        }
        this.myEditor.setRepositoryInfo(this.myRepositoryRoot, this.myLocks);
        this.myReporter.finishReport();
    }

    public void abortReport() throws SVNException {
        this.myReporter.abortReport();
    }

    public void linkPath(SVNURL url, String path, String lockToken, long revision, SVNDepth depth, boolean startEmpty) throws SVNException {
        SVNURL rootURL = SVNURLUtil.getCommonURLAncestor(url, this.myCommonAncestorLocation);
        if (rootURL == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.BAD_URL, "Can not determine common ancestor of ''{0}'' and ''{1}'';\nprobably these entries belong to different repositories.", new Object[]{url, this.myCommonAncestorLocation});
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (SVNPathUtil.getPathAsChild(rootURL.getPath(), this.myCommonAncestorLocation.getPath()) != null) {
            this.myCommonAncestorLocation = rootURL;
        }
        this.myReporter.linkPath(url, path, lockToken, revision, depth, startEmpty);
    }

    public void setPath(String path, String lockToken, long revision, SVNDepth depth, boolean startEmpty) throws SVNException {
        this.myReporter.setPath(path, lockToken, revision, depth, startEmpty);
    }
}

