/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.Searchable;
import com.jidesoft.swing.event.SearchableEvent;
import java.awt.IllegalComponentStateException;
import java.awt.KeyboardFocusManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class ComboBoxSearchable
extends Searchable
implements ListDataListener,
PropertyChangeListener,
PopupMenuListener {
    private boolean _showPopupDuringSearching = true;

    public ComboBoxSearchable(JComboBox comboBox) {
        super(comboBox);
        comboBox.setKeySelectionManager(new JComboBox.KeySelectionManager(){

            public int selectionForKey(char aKey, ComboBoxModel aModel) {
                return -1;
            }
        });
        comboBox.getModel().addListDataListener(this);
        comboBox.addPropertyChangeListener("model", this);
        comboBox.addPopupMenuListener(this);
    }

    public void uninstallListeners() {
        super.uninstallListeners();
        if (this._component instanceof JComboBox) {
            ((JComboBox)this._component).getModel().removeListDataListener(this);
            ((JComboBox)this._component).removePopupMenuListener(this);
        }
        this._component.removePropertyChangeListener("model", this);
    }

    public boolean isShowPopupDuringSearching() {
        return this._showPopupDuringSearching;
    }

    public void setShowPopupDuringSearching(boolean showPopupDuringSearching) {
        this._showPopupDuringSearching = showPopupDuringSearching;
    }

    protected void setSelectedIndex(int index, boolean incremental) {
        if (((JComboBox)this._component).getSelectedIndex() != index) {
            ((JComboBox)this._component).setSelectedIndex(index);
        }
        if (this.isShowPopupDuringSearching()) {
            boolean old = this.isHideSearchPopupOnEvent();
            this.setHideSearchPopupOnEvent(false);
            ((JComboBox)this._component).hidePopup();
            this.setHideSearchPopupOnEvent(old);
            try {
                if (!((JComboBox)this._component).isPopupVisible() && KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner() != null && SwingUtilities.isDescendingFrom(KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner(), this._component)) {
                    ((JComboBox)this._component).showPopup();
                }
            }
            catch (IllegalComponentStateException e) {
                // empty catch block
            }
        }
    }

    protected int getSelectedIndex() {
        return ((JComboBox)this._component).getSelectedIndex();
    }

    protected Object getElementAt(int index) {
        ComboBoxModel comboBoxModel = ((JComboBox)this._component).getModel();
        return comboBoxModel.getElementAt(index);
    }

    protected int getElementCount() {
        ComboBoxModel comboBoxModel = ((JComboBox)this._component).getModel();
        return comboBoxModel.getSize();
    }

    protected String convertElementToString(Object object) {
        if (object != null) {
            return object.toString();
        }
        return "";
    }

    public void contentsChanged(ListDataEvent e) {
        if (!this.isProcessModelChangeEvent()) {
            return;
        }
        if (e.getIndex0() != -1 || e.getIndex1() != -1) {
            this.hidePopup();
            this.fireSearchableEvent(new SearchableEvent(this, 3005));
        }
    }

    public void intervalAdded(ListDataEvent e) {
        if (!this.isProcessModelChangeEvent()) {
            return;
        }
        this.hidePopup();
        this.fireSearchableEvent(new SearchableEvent(this, 3005));
    }

    public void intervalRemoved(ListDataEvent e) {
        if (!this.isProcessModelChangeEvent()) {
            return;
        }
        this.hidePopup();
        this.fireSearchableEvent(new SearchableEvent(this, 3005));
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("model".equals(evt.getPropertyName())) {
            this.hidePopup();
            if (evt.getOldValue() instanceof ComboBoxModel) {
                ((ComboBoxModel)evt.getOldValue()).removeListDataListener(this);
            }
            if (evt.getNewValue() instanceof ComboBoxModel) {
                ((ComboBoxModel)evt.getNewValue()).addListDataListener(this);
            }
        }
        this.fireSearchableEvent(new SearchableEvent(this, 3005));
    }

    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
    }

    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        if (this.isHideSearchPopupOnEvent()) {
            this.hidePopup();
        }
    }

    public void popupMenuCanceled(PopupMenuEvent e) {
    }
}

