/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.StyleRange;
import java.util.List;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.UIManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StyledLabel
extends JLabel {
    private static final String uiClassID = "StyledLabelUI";
    private List<StyleRange> _styleRanges;
    private boolean _ignoreColorSettings;
    public static final String PROPERTY_STYLE_RANGE = "styleRange";
    public static final String PROPERTY_IGNORE_COLOR_SETTINGS = "ignoreColorSettings";

    public StyledLabel() {
    }

    public StyledLabel(Icon image) {
        super(image);
    }

    public StyledLabel(Icon image, int horizontalAlignment) {
        super(image, horizontalAlignment);
    }

    public StyledLabel(String text) {
        super(text);
    }

    public StyledLabel(String text, int horizontalAlignment) {
        super(text, horizontalAlignment);
    }

    public StyledLabel(String text, Icon icon, int horizontalAlignment) {
        super(text, icon, horizontalAlignment);
    }

    @Override
    public void updateUI() {
        if (UIDefaultsLookup.get(uiClassID) == null) {
            LookAndFeelFactory.installJideExtension();
        }
        this.setUI(UIManager.getUI(this));
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    public synchronized void addStyleRange(StyleRange styleRange) {
        if (styleRange == null) {
            throw new IllegalArgumentException("StyleRange cannot be null.");
        }
        List<StyleRange> ranges = this.internalGetStyleRanges();
        for (int i = ranges.size() - 1; i >= 0; --i) {
            StyleRange range = ranges.get(i);
            if (range.getStart() != styleRange.getStart() || range.getStart() != styleRange.getStart()) continue;
            ranges.remove(i);
        }
        this.internalGetStyleRanges().add(styleRange);
        this.firePropertyChange(PROPERTY_STYLE_RANGE, null, styleRange);
    }

    public synchronized void setStyleRanges(StyleRange[] styleRanges) {
        this.internalGetStyleRanges().clear();
        this.addStyleRanges(styleRanges);
    }

    public synchronized void addStyleRanges(StyleRange[] styleRanges) {
        if (styleRanges != null) {
            for (StyleRange styleRange : styleRanges) {
                this.internalGetStyleRanges().add(styleRange);
            }
            this.firePropertyChange(PROPERTY_STYLE_RANGE, null, styleRanges);
        } else {
            this.firePropertyChange(PROPERTY_STYLE_RANGE, null, null);
        }
    }

    public synchronized StyleRange[] getStyleRanges() {
        List<StyleRange> list = this.internalGetStyleRanges();
        return list.toArray(new StyleRange[list.size()]);
    }

    private List<StyleRange> internalGetStyleRanges() {
        if (this._styleRanges == null) {
            this._styleRanges = new Vector<StyleRange>();
        }
        return this._styleRanges;
    }

    public synchronized void clearStyleRange(StyleRange styleRange) {
        if (this.internalGetStyleRanges().remove(styleRange)) {
            this.firePropertyChange(PROPERTY_STYLE_RANGE, styleRange, null);
        }
    }

    public synchronized void clearStyleRanges() {
        this.internalGetStyleRanges().clear();
        this.firePropertyChange(PROPERTY_STYLE_RANGE, null, null);
    }

    public boolean isIgnoreColorSettings() {
        return this._ignoreColorSettings;
    }

    public void setIgnoreColorSettings(boolean ignoreColorSettings) {
        boolean old = this._ignoreColorSettings;
        if (old != ignoreColorSettings) {
            this._ignoreColorSettings = ignoreColorSettings;
            this.firePropertyChange(PROPERTY_IGNORE_COLOR_SETTINGS, old, ignoreColorSettings);
        }
    }
}

