/*
 * Decompiled with CFR 0.152.
 */
package com.ice.cvsc;

import com.ice.cvsc.CVSEntry;
import com.ice.cvsc.CVSTracer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Vector;

public class CVSCUtilities {
    public static final String RCS_ID = "$Id: CVSCUtilities.java,v 2.11 2003/07/27 01:08:32 time Exp $";
    public static final String RCS_REV = "$Revision: 2.11 $";
    private static boolean redirectOutErr = false;
    private static PrintStream out = null;
    private static PrintStream err = null;

    public static boolean caseSensitivePathNames() {
        boolean result = true;
        String osname = System.getProperty("os.name");
        if (osname != null) {
            if (osname.startsWith("macos")) {
                result = false;
            } else if (osname.startsWith("Windows")) {
                result = false;
            }
        }
        return result;
    }

    public static boolean isSubpathInPath(String rootPath, String subPath) {
        boolean result = false;
        if (rootPath.length() > subPath.length()) {
            result = false;
        } else {
            subPath = CVSCUtilities.importPath(subPath);
            rootPath = CVSCUtilities.importPath(rootPath);
            if (!CVSCUtilities.caseSensitivePathNames()) {
                subPath = subPath.toLowerCase();
                rootPath = rootPath.toLowerCase();
            }
            result = subPath.startsWith(rootPath);
        }
        if (!result) {
            CVSTracer.traceIf(true, "CVSCUtilities.isSubpathInPath: FALSE result\n  adjusted rootPath '" + rootPath + "'\n" + "  adjusted subPath  '" + subPath + "'");
        }
        return result;
    }

    public static int computeTranslation(CVSEntry entry) {
        String options = entry.getOptions();
        int trans = 1;
        if (options != null && options.length() > 0 && options.startsWith("-kb")) {
            trans = 0;
        }
        return trans;
    }

    public static String exportPath(String path) {
        return path.replace('/', File.separatorChar);
    }

    public static String importPath(String path) {
        return path.replace(File.separatorChar, '/');
    }

    public static String ensureFinalSlash(String path) {
        return path.endsWith("/") ? path : path + "/";
    }

    public static String stripFinalSlash(String path) {
        return path.endsWith("/") ? path.substring(0, path.length() - 1) : path;
    }

    public static String stripFinalSeparator(String path) {
        while (true) {
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
                continue;
            }
            if (!path.endsWith(File.separator)) break;
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    public static String getLocalParent(String localDir) {
        int index = (localDir = CVSCUtilities.stripFinalSlash(localDir)).lastIndexOf(47);
        if (index > 0) {
            localDir = localDir.substring(0, index);
        }
        return localDir;
    }

    public static int slashCount(String s) {
        int result = 0;
        int cIdx = 0;
        while (cIdx < s.length()) {
            if (s.charAt(cIdx) == '/') {
                ++result;
            }
            ++cIdx;
        }
        return result;
    }

    public static boolean createEmptyFile(File f) {
        boolean result = true;
        try {
            FileWriter writer = new FileWriter(f);
            writer.close();
        }
        catch (IOException ex) {
            result = false;
            CVSTracer.traceWithStack("ERROR creating empty file '" + f.getPath() + "' - " + ex.getMessage());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void writeStringFile(File f, String str) throws IOException {
        FileWriter writer = null;
        try {
            writer = new FileWriter(f);
            if (str != null) {
                writer.write(str);
            }
            Object var4_3 = null;
            if (writer == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (writer == null) throw throwable;
            writer.close();
            throw throwable;
        }
        writer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String readStringFile(File f) throws IOException {
        BufferedReader in = null;
        String result = "";
        try {
            in = new BufferedReader(new FileReader(f));
            result = in.readLine();
            if (result == null) {
                result = "";
            }
            Object var4_3 = null;
            if (in == null) return result;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException ex) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            in.close();
            return result;
        }
        catch (IOException ex) {}
        return result;
    }

    public static void endRedirectOutput() {
        if (redirectOutErr) {
            redirectOutErr = false;
            System.out.flush();
            System.out.close();
            System.setOut(out);
            System.setErr(err);
            out = null;
            err = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void integrateEntriesLog(File adminDir) throws IOException {
        block17: {
            PrintWriter outBak = null;
            BufferedReader logIn = null;
            BufferedReader entIn = null;
            File logF = new File(adminDir, "Entries.Log");
            if (!logF.exists()) {
                return;
            }
            Vector<String> nameV = new Vector<String>();
            Vector<String> lineV = new Vector<String>();
            File entF = new File(adminDir, "Entries");
            File bakF = new File(adminDir, "Entries.Backup");
            try {
                String inLine;
                entIn = new BufferedReader(new FileReader(entF));
                while ((inLine = entIn.readLine()) != null) {
                    int begIdx;
                    int idx;
                    char ch = inLine.charAt(0);
                    if (ch != '/' && ch != 'D' || (idx = inLine.indexOf("/", begIdx = ch == 'D' ? 2 : 1)) == -1) continue;
                    lineV.addElement(inLine);
                    nameV.addElement(inLine.substring(begIdx, idx));
                }
                entIn.close();
                entIn = null;
                logIn = new BufferedReader(new FileReader(logF));
                while ((inLine = logIn.readLine()) != null && inLine.length() >= 5) {
                    char ch;
                    int begIdx;
                    int idx;
                    char selCh = inLine.charAt(0);
                    char sepCh = inLine.charAt(1);
                    if (selCh != 'A' && selCh != 'R' || sepCh != ' ' || (idx = inLine.indexOf("/", begIdx = (ch = inLine.charAt(2)) == 'D' ? 4 : 3)) == -1) continue;
                    String name = inLine.substring(begIdx, idx);
                    if (selCh == 'A') {
                        if (nameV.contains(name)) {
                            idx = nameV.indexOf(name);
                            lineV.setElementAt(inLine.substring(2), idx);
                            continue;
                        }
                        nameV.addElement(name);
                        lineV.addElement(inLine.substring(2));
                        continue;
                    }
                    if (selCh != 'R' || !nameV.contains(name)) continue;
                    idx = nameV.indexOf(name);
                    nameV.removeElementAt(idx);
                    lineV.removeElementAt(idx);
                }
                logIn.close();
                logIn = null;
                outBak = new PrintWriter(new FileWriter(bakF));
                int i = 0;
                int sz = nameV.size();
                while (i < sz) {
                    outBak.println(lineV.elementAt(i));
                    ++i;
                }
                outBak.close();
                outBak = null;
                entF.delete();
                if (bakF.renameTo(entF)) {
                    logF.delete();
                    break block17;
                }
                throw new IOException("RENAME FAILED from '" + bakF.getPath() + "' to '" + entF.getPath() + "'");
            }
            finally {
                try {
                    if (entIn != null) {
                        entIn.close();
                    }
                    if (logIn != null) {
                        logIn.close();
                    }
                    if (outBak != null) {
                        outBak.close();
                    }
                }
                catch (IOException ex) {}
            }
        }
    }
}

