/*
 * Decompiled with CFR 0.152.
 */
package com.ice.cvsc;

import com.ice.cvsc.CVSEntry;
import com.ice.cvsc.CVSTracer;
import java.util.Vector;

public class CVSEntryVector
extends Vector {
    public static final String RCS_ID = "$Id: CVSEntryVector.java,v 2.3 2003/07/27 01:08:32 time Exp $";
    public static final String RCS_REV = "$Revision: 2.3 $";
    public static boolean traceLocate = false;
    public static boolean traceLocatePath = false;
    private boolean isDirty = false;

    public CVSEntryVector() {
    }

    public CVSEntryVector(int initCap) {
        super(initCap);
    }

    public CVSEntryVector(int initCap, int capIncr) {
        super(initCap, capIncr);
    }

    public void removeAllEntries() {
        int i = 0;
        while (i < this.size()) {
            CVSEntry entry = this.entryAt(i);
            if (entry.isDirectory()) {
                entry.removeAllEntries();
            }
            ++i;
        }
        this.removeAllElements();
    }

    public CVSEntry entryAt(int index) {
        return (CVSEntry)this.elementAt(index);
    }

    public CVSEntry getEntryAt(int index) {
        return (CVSEntry)this.elementAt(index);
    }

    public void appendEntry(CVSEntry entry) {
        this.addElement(entry);
        this.isDirty = true;
    }

    private boolean removeEntry(CVSEntry entry) {
        boolean result = this.removeElement(entry);
        if (result) {
            this.isDirty = true;
        }
        return result;
    }

    private boolean removeEntry(String entryName) {
        int i = 0;
        while (i < this.size()) {
            CVSEntry entry = this.entryAt(i);
            if (entryName.equals(entry.getName())) {
                this.removeElementAt(i);
                this.isDirty = true;
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isDirty() {
        if (this.isDirty) {
            return true;
        }
        int i = 0;
        while (i < this.size()) {
            CVSEntry entry = (CVSEntry)this.elementAt(i);
            if (entry.isDirty()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setDirty(boolean dirty) {
        this.isDirty = dirty;
        int i = 0;
        while (i < this.size()) {
            CVSEntry entry = (CVSEntry)this.elementAt(i);
            entry.setDirty(dirty);
            ++i;
        }
    }

    public CVSEntry locateEntry(String name) {
        CVSTracer.traceIf(traceLocate, "===== CVSEntryVector.locateEntry: name '" + name + "' =====");
        int i = 0;
        while (i < this.size()) {
            CVSEntry entry = (CVSEntry)this.elementAt(i);
            CVSTracer.traceIf(traceLocate, "CVSEntryVector.locateEntry: ENTRY '" + entry.getFullName() + "' isDir '" + entry.isDirectory() + "'");
            if (name.equals(entry.getName())) {
                CVSTracer.traceIf(traceLocate, "CVSEntryVector.locateEntry: '" + entry.getFullName() + "' FOUND.");
                return entry;
            }
            ++i;
        }
        CVSTracer.traceIf(traceLocate, "CVSEntryVector.locateEntry: '" + name + "' NOT FOUND.");
        return null;
    }
}

