/*
 * Decompiled with CFR 0.152.
 */
package com.ice.jcvsii;

import com.ice.cvsc.CVSArgumentVector;
import com.ice.cvsc.CVSClient;
import com.ice.cvsc.CVSEntryVector;
import com.ice.cvsc.CVSProject;
import com.ice.cvsc.CVSRequest;
import com.ice.cvsc.CVSResponse;
import com.ice.cvsc.CVSScramble;
import com.ice.cvsc.CVSUserInterface;
import com.ice.jcvsii.CVSThread;
import com.ice.jcvsii.CVSUtilities;
import com.ice.jcvsii.Config;
import com.ice.jcvsii.ConnectInfoPanel;
import com.ice.jcvsii.MainPanel;
import com.ice.jcvsii.MainTabPanel;
import com.ice.jcvsii.ResourceMgr;
import com.ice.pref.UserPrefs;
import com.ice.util.AWTUtilities;
import java.awt.Color;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;

public class CreatePanel
extends MainTabPanel
implements ActionListener,
CVSUserInterface {
    protected CVSClient client;
    protected ConnectInfoPanel info;
    protected JTextField argumentsText;
    protected JTextArea outputText;
    protected JLabel feedback;
    protected JButton actionButton;

    public CreatePanel(MainPanel parent) {
        super(parent);
        this.establishContents();
    }

    public void loadPreferences() {
        this.info.loadPreferences("create");
    }

    public void savePreferences() {
        this.info.savePreferences("create");
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if (command.equalsIgnoreCase("CREATE")) {
            this.performCreate();
        } else if (command.equalsIgnoreCase("CANCEL")) {
            this.cancelCreate();
        }
    }

    private void cancelCreate() {
        this.client.setCanceled(true);
    }

    private void performCreate() {
        Config cfg = Config.getInstance();
        UserPrefs prefs = cfg.getPreferences();
        ResourceMgr rmgr = ResourceMgr.getInstance();
        CVSEntryVector entries = new CVSEntryVector();
        CVSArgumentVector arguments = new CVSArgumentVector();
        String userName = this.info.getUserName();
        String passWord = this.info.getPassword();
        String hostname = this.info.getServer();
        String repository = this.info.getModule();
        String rootDirectory = this.info.getRepository();
        String vendorTag = "vendor-tag";
        String releaseTag = "release-tag";
        String message = "Creating new repository.";
        boolean isPServer = this.info.isPServer();
        int connMethod = this.info.getConnectionMethod();
        int cvsPort = CVSUtilities.computePortNum(hostname, connMethod, isPServer);
        if (hostname.length() < 1 || repository.length() < 1 || rootDirectory.length() < 1) {
            Object[] fmtArgs = new String[]{hostname.length() < 1 ? rmgr.getUIString("name.for.cvsserver") : (repository.length() < 1 ? rmgr.getUIString("name.for.cvsmodule") : rmgr.getUIString("name.for.cvsrepos"))};
            String msg = rmgr.getUIFormat("create.needs.input.msg", fmtArgs);
            String title = rmgr.getUIString("create.needs.input.title");
            JOptionPane.showMessageDialog((Frame)this.getTopLevelAncestor(), msg, title, 0);
            return;
        }
        if (userName.length() < 1 && (connMethod == 2 || connMethod == 3)) {
            String msg = rmgr.getUIString("common.rsh.needs.user.msg");
            String title = rmgr.getUIString("common.rsh.needs.user.title");
            JOptionPane.showMessageDialog((Frame)this.getTopLevelAncestor(), msg, title, 0);
            return;
        }
        this.getMainPanel().setAllTabsEnabled(false);
        CVSClient client = CVSUtilities.createCVSClient(hostname, cvsPort);
        CVSProject project = new CVSProject(client);
        project.setUserName(userName);
        project.setTempDirectory(cfg.getTemporaryDirectory());
        project.setRepository(repository);
        project.setRootDirectory(rootDirectory);
        project.setLocalRootDirectory(prefs.getCurrentDirectory());
        project.setPServer(isPServer);
        project.setConnectionPort(cvsPort);
        project.setConnectionMethod(connMethod);
        if (connMethod == 2) {
            CVSUtilities.establishRSHProcess(project);
        }
        project.setSetVariables(CVSUtilities.getUserSetVariables(hostname));
        project.setServerCommand(CVSUtilities.establishServerCommand(hostname, connMethod, isPServer));
        project.setAllowsGzipFileMode(prefs.getBoolean("global.allowGzipFileMode", false));
        project.setGzipStreamLevel(prefs.getInteger("global.gzipStreamLevel", 0));
        if (isPServer) {
            String scrambled = CVSScramble.scramblePassword(passWord, 'A');
            project.setPassword(scrambled);
        } else if (connMethod == 3) {
            project.setPassword(passWord);
        }
        CVSRequest request = new CVSRequest();
        request.setPServer(isPServer);
        request.setUserName(userName);
        if (isPServer || connMethod == 3) {
            request.setPassword(project.getPassword());
        }
        request.setConnectionMethod(connMethod);
        request.setServerCommand(project.getServerCommand());
        request.setRshProcess(project.getRshProcess());
        request.setPort(cvsPort);
        request.setHostName(client.getHostName());
        request.setRepository(repository);
        request.setRootDirectory(rootDirectory);
        request.setRootRepository(rootDirectory);
        request.setLocalDirectory(prefs.getCurrentDirectory());
        request.setSetVariables(project.getSetVariables());
        request.setCommand("import");
        request.sendModule = false;
        request.sendArguments = true;
        request.handleUpdated = false;
        request.allowOverWrites = false;
        request.queueResponse = false;
        request.responseHandler = project;
        request.includeNotifies = false;
        request.traceRequest = CVSProject.overTraceRequest;
        request.traceResponse = CVSProject.overTraceResponse;
        request.traceTCPData = CVSProject.overTraceTCP;
        request.traceProcessing = CVSProject.overTraceProcessing;
        request.allowGzipFileMode = project.allowsGzipFileMode();
        request.setGzipStreamLevel(project.getGzipStreamLevel());
        arguments.appendArgument("-m");
        arguments.appendArgument(message);
        arguments.appendArgument(repository);
        arguments.appendArgument(vendorTag);
        arguments.appendArgument(releaseTag);
        arguments.appendArgument(repository);
        request.setEntries(entries);
        request.setArguments(arguments);
        request.setUserInterface(this);
        CVSResponse response = new CVSResponse();
        CreatePanel createPanel = this;
        createPanel.getClass();
        MyRunner myRunner = createPanel.new MyRunner(project, client, request, response);
        CreatePanel createPanel2 = this;
        createPanel2.getClass();
        CVSThread thread = new CVSThread("Create", (Runnable)myRunner, createPanel2.new MyMonitor(request, response));
        thread.start();
    }

    public void uiDisplayProgressMsg(String message) {
        this.feedback.setText(message);
        this.feedback.repaint(0L);
    }

    public void uiDisplayProgramError(String error) {
    }

    public void uiDisplayResponse(CVSResponse response) {
    }

    private void establishContents() {
        this.setLayout(new GridBagLayout());
        this.info = new ConnectInfoPanel("create");
        this.info.setPServerMode(true);
        this.info.setUsePassword(true);
        int row = 0;
        AWTUtilities.constrain(this, this.info, 2, 17, 0, row++, 1, 1, 1.0, 0.0);
        this.actionButton = new JButton(ResourceMgr.getInstance().getUIString("create.perform.label"));
        this.actionButton.setActionCommand("CREATE");
        this.actionButton.addActionListener(this);
        AWTUtilities.constrain(this, this.actionButton, 0, 10, 0, row++, 1, 1, 0.0, 0.0, new Insets(5, 5, 5, 5));
        this.feedback = new JLabel(ResourceMgr.getInstance().getUIString("name.for.ready"));
        this.feedback.setOpaque(true);
        this.feedback.setBackground(Color.white);
        this.feedback.setBorder(new CompoundBorder(new LineBorder(Color.darkGray), new EmptyBorder(1, 3, 1, 3)));
        AWTUtilities.constrain(this, this.feedback, 2, 10, 0, row++, 1, 1, 1.0, 0.0, new Insets(4, 0, 3, 0));
        this.outputText = new JTextArea(){

            public boolean isFocusTraversable() {
                return false;
            }
        };
        this.outputText.setEditable(false);
        JScrollPane scroller = new JScrollPane(this.outputText);
        scroller.setVerticalScrollBarPolicy(22);
        AWTUtilities.constrain(this, scroller, 1, 10, 0, row++, 1, 1, 1.0, 1.0);
    }

    private class MyMonitor
    implements CVSThread.Monitor {
        private CVSRequest request;
        private CVSResponse response;

        public MyMonitor(CVSRequest request, CVSResponse response) {
            this.request = request;
            this.response = response;
        }

        public void threadStarted() {
            CreatePanel.this.actionButton.setActionCommand("CANCEL");
            CreatePanel.this.actionButton.setText(ResourceMgr.getInstance().getUIString("create.cancel.label"));
        }

        public void threadCanceled() {
        }

        public void threadFinished() {
            CreatePanel.this.actionButton.setActionCommand("CREATE");
            CreatePanel.this.actionButton.setText(ResourceMgr.getInstance().getUIString("create.perform.label"));
            String resultStr = this.response.getDisplayResults();
            if (this.response.getStatus() == 0) {
                CreatePanel.this.uiDisplayProgressMsg(ResourceMgr.getInstance().getUIString("create.status.success"));
            } else {
                CreatePanel.this.uiDisplayProgressMsg(ResourceMgr.getInstance().getUIString("create.status.failure"));
            }
            CreatePanel.this.outputText.setText(resultStr);
            CreatePanel.this.outputText.revalidate();
            CreatePanel.this.outputText.repaint();
            if (this.response != null && !this.request.saveTempFiles) {
                this.response.deleteTempFiles();
            }
            CreatePanel.this.getMainPanel().setAllTabsEnabled(true);
        }
    }

    private class MyRunner
    implements Runnable {
        private CVSClient client;
        private CVSProject project;
        private CVSRequest request;
        private CVSResponse response;

        public MyRunner(CVSProject project, CVSClient client, CVSRequest request, CVSResponse response) {
            this.client = client;
            this.project = project;
            this.request = request;
            this.response = response;
        }

        public void run() {
            this.client.processCVSRequest(this.request, this.response);
            this.project.processCVSResponse(this.request, this.response);
        }
    }
}

