/*
 * Decompiled with CFR 0.152.
 */
package com.ice.jcvsii;

import com.ice.config.ConfigureEditor;
import com.ice.config.ConfigureSpec;
import com.ice.pref.UserPrefs;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class LookAndFeelEditor
extends ConfigureEditor {
    protected JPanel radioPanel;
    protected ButtonGroup group;
    protected JRadioButton[] choiceButtons;
    protected String[] plafClassNames;
    protected String[] plafDisplayNames;

    public LookAndFeelEditor() {
        super("Look And Feel Class");
    }

    public void edit(UserPrefs prefs, ConfigureSpec spec) {
        super.edit(prefs, spec);
        this.radioPanel.removeAll();
        String propName = spec.getPropertyName();
        String currPlaf = prefs.getProperty(propName, null);
        this.group = new ButtonGroup();
        this.getLookAndFeelInfo();
        String[] choices = this.plafDisplayNames;
        this.choiceButtons = new JRadioButton[choices.length];
        int i = 0;
        while (i < this.plafDisplayNames.length) {
            JRadioButton radio;
            this.choiceButtons[i] = radio = new JRadioButton(this.plafDisplayNames[i]);
            this.group.add(radio);
            this.radioPanel.add(radio);
            radio.setSelected(false);
            if (currPlaf != null) {
                if (currPlaf.equals(this.plafClassNames[i])) {
                    radio.setSelected(true);
                }
            } else if (i == 0) {
                radio.setSelected(true);
            }
            ++i;
        }
        this.radioPanel.validate();
        this.radioPanel.repaint(250L);
    }

    public void saveChanges(UserPrefs prefs, ConfigureSpec spec) {
        String propName = spec.getPropertyName();
        String oldChoice = prefs.getProperty(propName, null);
        int i = 0;
        while (i < this.choiceButtons.length) {
            if (this.choiceButtons[i].isSelected()) {
                String newChoice = this.plafClassNames[i];
                prefs.setProperty(propName, newChoice);
                break;
            }
            ++i;
        }
    }

    public void requestInitialFocus() {
    }

    protected JPanel createEditPanel() {
        JPanel result = new JPanel();
        result.setLayout(new BoxLayout(result, 1));
        result.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.radioPanel = result;
        return this.radioPanel;
    }

    private void getLookAndFeelInfo() {
        UIManager.LookAndFeelInfo[] lafi = UIManager.getInstalledLookAndFeels();
        this.plafClassNames = new String[lafi.length + 1];
        this.plafDisplayNames = new String[lafi.length + 1];
        this.plafClassNames[0] = "DEFAULT";
        this.plafDisplayNames[0] = "System Default";
        int i = 0;
        while (i < lafi.length) {
            this.plafClassNames[i + 1] = lafi[i].getClassName();
            this.plafDisplayNames[i + 1] = lafi[i].getName();
            ++i;
        }
    }
}

