/*
 * Decompiled with CFR 0.152.
 */
package com.ice.jcvsii;

import com.ice.jcvsii.CVSUserDialog;
import com.ice.jcvsii.Config;
import com.ice.jcvsii.ProjectFrame;
import com.ice.pref.UserPrefs;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class OutputFrame
extends JFrame
implements ActionListener {
    private ProjectFrame projectFrame;
    private JTextArea outputText;
    private JScrollPane scroller;
    private boolean isRedirecting;
    private File redirectFile;
    private BufferedWriter redirectWriter;
    private JMenuItem endItem;
    private JMenuItem beginItem;
    private String fileDialogDefaultPath;

    public OutputFrame(ProjectFrame projectFrame, String title) {
        super(title);
        this.projectFrame = projectFrame;
        this.outputText = new JTextArea();
        this.scroller = new JScrollPane(this.outputText);
        this.isRedirecting = false;
        this.redirectFile = null;
        this.redirectWriter = null;
        this.endItem = null;
        this.beginItem = null;
        this.fileDialogDefaultPath = null;
        this.outputText.setEditable(false);
        this.outputText.setBackground(Color.white);
        this.outputText.setFont(Config.getPreferences().getFont("outputFrame.font", new Font("Monospaced", 0, 12)));
        Container content = this.getContentPane();
        content.setLayout(new BorderLayout(0, 0));
        content.add("Center", this.scroller);
        this.establishMenuBar();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                OutputFrame.this.setVisible(false);
            }

            public void windowClosed(WindowEvent e) {
                OutputFrame.this.windowBeingClosed();
            }
        });
    }

    public void loadPreferences(Rectangle defBounds) {
        this.setBounds(this.projectFrame.getPreferences().getBounds("outputFrame.bounds", defBounds));
    }

    public void savePreferences() {
        Rectangle bounds = this.getBounds();
        if (bounds.x >= 0 && bounds.y >= 0 && bounds.width > 0 && bounds.height > 0) {
            this.projectFrame.getPreferences().setBounds("outputFrame.bounds", bounds);
        }
    }

    public void windowBeingClosed() {
        this.savePreferences();
        if (this.isRedirecting && this.redirectWriter != null) {
            try {
                this.redirectWriter.close();
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        this.projectFrame.outputIsClosing();
        this.projectFrame = null;
    }

    public String getText() {
        return this.outputText.getText();
    }

    public void setText(String newText) {
        if (this.isRedirecting && this.redirectWriter != null) {
            try {
                String lineSep = UserPrefs.getLineSeparator();
                this.redirectWriter.write(newText);
                if (!newText.endsWith(lineSep)) {
                    this.redirectWriter.write(lineSep);
                }
            }
            catch (IOException ex) {
                this.endRedirection();
                this.outputText.setText("*** ERROR writing to redirect file.");
                this.outputText.revalidate();
                this.outputText.repaint(500L);
            }
        } else {
            this.outputText.setText(newText);
            this.outputText.revalidate();
            this.outputText.repaint(500L);
        }
    }

    public void actionPerformed(ActionEvent evt) {
        String command = evt.getActionCommand();
        if (command.startsWith("Hide")) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    OutputFrame.this.setVisible(false);
                }
            });
        } else if (command.startsWith("Close")) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    OutputFrame.this.dispose();
                }
            });
        } else if (command.startsWith("Show")) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    OutputFrame.this.projectFrame.setVisible(true);
                    OutputFrame.this.projectFrame.toFront();
                    OutputFrame.this.projectFrame.requestFocus();
                }
            });
        } else if (command.startsWith("SaveToFile")) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    OutputFrame.this.saveToFile();
                }
            });
        } else if (command.startsWith("Redirect")) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    OutputFrame.this.redirectToFile();
                }
            });
        } else if (command.startsWith("EndRedirect")) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    OutputFrame.this.endRedirection();
                }
            });
        } else if (command.startsWith("CopyText")) {
            this.outputText.copy();
        } else if (command.startsWith("SelectAll")) {
            this.outputText.selectAll();
        }
    }

    public void saveToFile() {
        block4: {
            FileDialog dialog = new FileDialog((Frame)this, "Save To File", 1);
            if (this.fileDialogDefaultPath != null) {
                dialog.setDirectory(this.fileDialogDefaultPath);
            }
            dialog.show();
            String dirName = dialog.getDirectory();
            String fileName = dialog.getFile();
            if (dirName == null || fileName == null) break block4;
            File outF = null;
            this.fileDialogDefaultPath = dirName;
            try {
                String ln;
                outF = new File(dirName, fileName);
                PrintWriter out = new PrintWriter(new FileWriter(outF));
                BufferedReader rdr = new BufferedReader(new StringReader(this.outputText.getText()));
                while ((ln = rdr.readLine()) != null) {
                    out.println(ln);
                }
                out.close();
            }
            catch (IOException ex) {
                CVSUserDialog.Error("Could not save text to file '" + outF.getPath() + "':\n   " + ex.getMessage());
            }
        }
    }

    public void redirectToFile() {
        if (this.isRedirecting) {
            CVSUserDialog.Note("Output is already redirected to '" + this.redirectFile.getPath() + "'");
            return;
        }
        FileDialog dialog = new FileDialog((Frame)this, "Redirect File", 1);
        if (this.fileDialogDefaultPath != null) {
            dialog.setDirectory(this.fileDialogDefaultPath);
        }
        dialog.show();
        String dirName = dialog.getDirectory();
        String fileName = dialog.getFile();
        if (dirName != null && fileName != null) {
            this.fileDialogDefaultPath = dirName;
            try {
                this.isRedirecting = true;
                this.redirectFile = new File(dirName, fileName);
                this.redirectWriter = new BufferedWriter(new FileWriter(this.redirectFile));
            }
            catch (IOException ex) {
                CVSUserDialog.Error("Could not redirect to file '" + this.redirectFile.getPath() + "'.\n" + ex.getMessage());
                this.redirectFile = null;
                this.redirectWriter = null;
                this.isRedirecting = false;
            }
            if (this.isRedirecting) {
                this.beginItem.setEnabled(false);
                this.endItem.setEnabled(true);
                this.outputText.setText("Redirecting to file '" + this.redirectFile.getPath() + "'...");
            }
        }
    }

    public void endRedirection() {
        if (!this.isRedirecting) {
            return;
        }
        if (this.redirectWriter != null) {
            try {
                this.redirectWriter.close();
            }
            catch (IOException ex) {
                CVSUserDialog.Error("Failed closing redirect file '" + this.redirectFile.getPath() + "'.\n" + ex.getMessage());
            }
        }
        this.outputText.setText("Redirection to file ended.");
        this.beginItem.setEnabled(true);
        this.endItem.setEnabled(false);
        this.redirectFile = null;
        this.redirectWriter = null;
        this.isRedirecting = false;
    }

    private void establishMenuBar() {
        JMenuBar mBar = new JMenuBar();
        JMenu mFile = new JMenu("File", true);
        mBar.add(mFile);
        JMenuItem mItem = new JMenuItem("Show Project");
        mFile.add(mItem);
        mItem.addActionListener(this);
        mItem.setActionCommand("Show");
        mItem.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        mFile.addSeparator();
        mItem = new JMenuItem("Save To File...");
        mFile.add(mItem);
        mItem.addActionListener(this);
        mItem.setActionCommand("SaveToFile");
        mItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        mFile.addSeparator();
        mItem = new JMenuItem("Redirect To File...");
        mFile.add(mItem);
        mItem.addActionListener(this);
        mItem.setActionCommand("Redirect");
        mItem.setAccelerator(KeyStroke.getKeyStroke(82, 2));
        this.beginItem = mItem;
        mItem = new JMenuItem("End File Redirection");
        mFile.add(mItem);
        mItem.addActionListener(this);
        mItem.setActionCommand("EndRedirect");
        mItem.setEnabled(false);
        this.endItem = mItem;
        mFile.addSeparator();
        mItem = new JMenuItem("Hide Window");
        mFile.add(mItem);
        mItem.addActionListener(this);
        mItem.setActionCommand("Hide");
        mItem.setAccelerator(KeyStroke.getKeyStroke(87, 2));
        JMenu mEdit = new JMenu("Edit", true);
        mBar.add(mEdit);
        mItem = new JMenuItem("Copy");
        mEdit.add(mItem);
        mItem.addActionListener(this);
        mItem.setActionCommand("CopyText");
        mItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        mEdit.addSeparator();
        mItem = new JMenuItem("Select All");
        mEdit.add(mItem);
        mItem.addActionListener(this);
        mItem.setActionCommand("SelectAll");
        mItem.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        this.setJMenuBar(mBar);
    }
}

