/*
 * Decompiled with CFR 0.152.
 */
package com.ice.jcvsii;

import com.ice.jcvsii.Config;
import com.ice.jcvsii.DiffLayout;
import com.ice.jcvsii.ProjectFrame;
import com.ice.util.AWTUtilities;
import com.ice.util.StringUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;

public class PrettyDiffFrame
extends JFrame
implements ActionListener,
SwingConstants {
    private int dCol;
    private int dRow;
    private ProjectFrame projectFrame;
    private JPanel mainPanel;
    private JPanel diffPanel;
    private JScrollPane scroller;
    private Font lblFont;
    private Font rawFont;
    private Font timeFont;
    private Font titleFont;
    private Font headerFont;
    private Color clrRmv = null;
    private Color clrChg = null;
    private Color clrChgDk = null;
    private Color clrAdd = null;
    private Color clrNil = null;
    private Color clrHeader = null;
    private Color clrTitle = null;
    private Color clrBack = null;

    public PrettyDiffFrame(ProjectFrame projectFrame, String title, String fileName, String diffs, String rev1, String rev2) {
        super(title);
        this.projectFrame = projectFrame;
        this.clrRmv = new Color(255, 204, 204);
        this.clrChg = new Color(153, 255, 153);
        this.clrChgDk = new Color(68, 204, 68);
        this.clrAdd = new Color(204, 204, 255);
        this.clrNil = new Color(204, 204, 204);
        this.clrTitle = new Color(224, 224, 224);
        this.clrHeader = new Color(240, 240, 255);
        this.clrBack = Color.white;
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new GridBagLayout());
        this.mainPanel.setOpaque(true);
        this.mainPanel.setBackground(this.clrBack);
        this.scroller = new JScrollPane(this.mainPanel);
        this.timeFont = Config.getPreferences().getFont("prettyDiff.title.font", new Font("SansSerif", 0, 10));
        this.titleFont = Config.getPreferences().getFont("prettyDiff.title.font", new Font("SansSerif", 1, 14));
        this.headerFont = Config.getPreferences().getFont("prettyDiff.header.font", new Font("SansSerif", 1, 12));
        this.lblFont = Config.getPreferences().getFont("prettyDiff.lbl.font", new Font("Monospaced", 0, 12));
        this.rawFont = Config.getPreferences().getFont("prettyDiff.raw.font", new Font("Monospaced", 0, 10));
        Container content = this.getContentPane();
        content.setLayout(new BorderLayout(0, 0));
        content.add("Center", this.scroller);
        this.establishMenuBar();
        this.establishDiffs(diffs, fileName, rev1, rev2);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                PrettyDiffFrame.this.setVisible(false);
                PrettyDiffFrame.this.dispose();
            }

            public void windowClosed(WindowEvent e) {
                PrettyDiffFrame.this.windowBeingClosed();
            }
        });
    }

    public void loadPreferences(Rectangle defBounds) {
        this.setBounds(this.projectFrame.getPreferences().getBounds("prettyDiff.bounds", defBounds));
    }

    public void savePreferences() {
        Rectangle bounds = this.getBounds();
        if (bounds.x >= 0 && bounds.y >= 0 && bounds.width > 0 && bounds.height > 0) {
            this.projectFrame.getPreferences().setBounds("prettyDiff.bounds", bounds);
        }
    }

    public void windowBeingClosed() {
        this.savePreferences();
    }

    public void actionPerformed(ActionEvent evt) {
        String command = evt.getActionCommand();
        if (command.startsWith("Close")) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    PrettyDiffFrame.this.dispose();
                }
            });
        }
    }

    private String spaceTabs(String text) {
        int len = text.length();
        StringBuffer buf = new StringBuffer(len * 2);
        int i = 0;
        while (i < len) {
            char ch = text.charAt(i);
            if (ch == '\t') {
                buf.append("    ");
            } else {
                buf.append(ch);
            }
            ++i;
        }
        return buf.toString();
    }

    private JLabel createDiffLabel(String text) {
        JLabel lbl = null;
        lbl = new JLabel(text);
        lbl.setFont(this.lblFont);
        lbl.setForeground(Color.black);
        lbl.setOpaque(true);
        return lbl;
    }

    private void establishDiffs(String rawDiff, String fileName, String rev1, String rev2) {
        JLabel lbl = null;
        JSeparator sep = null;
        String[] lines = StringUtilities.splitString(rawDiff, "\n");
        int lnIdx = 0;
        String[] revStrs = new String[]{rev1, rev2};
        String[] timeStamps = new String[]{null, null};
        int numLines = lines.length;
        Vector<String> errV = new Vector<String>();
        boolean gotDiffLines = false;
        while (lnIdx < numLines) {
            if (lines[lnIdx].startsWith("--- ") || lines[lnIdx].startsWith("+++ ")) {
                int idx = lines[lnIdx].startsWith("--- ") ? 0 : 1;
                StringTokenizer toker = new StringTokenizer(lines[lnIdx].substring(4), "\t");
                if (toker.hasMoreTokens()) {
                    String name = toker.nextToken();
                    if (fileName == null) {
                        fileName = name;
                    }
                }
                if (toker.hasMoreTokens()) {
                    String timestamp = toker.nextToken();
                    if (timeStamps[idx] == null) {
                        timeStamps[idx] = timestamp;
                    }
                }
                if (toker.hasMoreTokens()) {
                    String rev = toker.nextToken();
                    if (revStrs[idx] == null) {
                        revStrs[idx] = rev;
                    }
                } else if (revStrs[idx] == null) {
                    revStrs[idx] = "Current";
                }
                if (idx == 1) {
                    gotDiffLines = true;
                    ++lnIdx;
                    break;
                }
            } else {
                errV.add(lines[lnIdx]);
            }
            ++lnIdx;
        }
        this.dCol = 0;
        this.dRow = 0;
        if (lnIdx >= numLines) {
            lbl = this.createDiffLabel("No Differences");
            lbl.setFont(this.headerFont);
            AWTUtilities.constrain(this.mainPanel, lbl, 2, 18, this.dCol, this.dRow, 2, 1, 1.0, 0.0, new Insets(2, 2, 2, 2));
            return;
        }
        if (fileName != null) {
            lbl = new JLabel("Diffs for '" + fileName + "'", 0);
            lbl.setFont(this.titleFont);
            lbl.setOpaque(true);
            lbl.setBackground(this.clrTitle);
            lbl.setForeground(Color.black);
            AWTUtilities.constrain(this.mainPanel, lbl, 2, 18, this.dCol++, this.dRow, 2, 1, 1.0, 0.0, new Insets(0, 0, 0, 0));
            this.dCol = 0;
            ++this.dRow;
        }
        lbl = new JLabel("Version: " + revStrs[0], 0);
        lbl.setFont(this.titleFont);
        lbl.setOpaque(true);
        lbl.setBackground(this.clrTitle);
        lbl.setForeground(Color.black);
        AWTUtilities.constrain(this.mainPanel, lbl, 2, 18, this.dCol++, this.dRow, 1, 1, 1.0, 0.0, new Insets(0, 0, 0, 0));
        lbl = new JLabel("Version: " + revStrs[1], 0);
        lbl.setFont(this.titleFont);
        lbl.setOpaque(true);
        lbl.setBackground(this.clrTitle);
        lbl.setForeground(Color.black);
        AWTUtilities.constrain(this.mainPanel, lbl, 2, 18, this.dCol++, this.dRow, 1, 1, 1.0, 0.0, new Insets(0, 0, 0, 0));
        this.dCol = 0;
        ++this.dRow;
        if (timeStamps[0] != null || timeStamps[1] == null) {
            lbl = new JLabel(timeStamps[0] == null ? " " : timeStamps[0], 0);
            lbl.setFont(this.timeFont);
            lbl.setOpaque(true);
            lbl.setBackground(this.clrTitle);
            lbl.setForeground(Color.black);
            AWTUtilities.constrain(this.mainPanel, lbl, 2, 18, this.dCol++, this.dRow, 1, 1, 1.0, 0.0, new Insets(0, 0, 0, 0));
            lbl = new JLabel(timeStamps[1] == null ? " " : timeStamps[1], 0);
            lbl.setFont(this.timeFont);
            lbl.setOpaque(true);
            lbl.setBackground(this.clrTitle);
            lbl.setForeground(Color.black);
            AWTUtilities.constrain(this.mainPanel, lbl, 2, 18, this.dCol++, this.dRow, 1, 1, 1.0, 0.0, new Insets(0, 0, 0, 0));
            this.dCol = 0;
            ++this.dRow;
        }
        sep = new JSeparator(0);
        AWTUtilities.constrain(this.mainPanel, sep, 2, 11, this.dCol, this.dRow, 2, 1, 1.0, 0.0, new Insets(1, 1, 1, 1));
        this.dCol = 0;
        ++this.dRow;
        this.diffPanel = new JPanel();
        this.diffPanel.setLayout(new DiffLayout());
        this.diffPanel.setOpaque(true);
        this.diffPanel.setBackground(this.clrBack);
        AWTUtilities.constrain(this.mainPanel, this.diffPanel, 1, 18, this.dCol, this.dRow, 2, 1, 1.0, 1.0, new Insets(2, 2, 2, 2));
        this.dCol = 0;
        ++this.dRow;
        int state = 68;
        Vector<String> ltColV = new Vector<String>();
        Vector<String> rtColV = new Vector<String>();
        while (lnIdx < numLines) {
            String ln = lines[lnIdx];
            if (ln.startsWith("@@")) {
                String[] flds = StringUtilities.splitString(ln, " ");
                String oldStr = flds[1].substring(1);
                String newStr = flds[2].substring(1);
                flds = StringUtilities.splitString(oldStr, ",");
                String oldLineCnt = "";
                String oldLineNum = flds[0];
                if (flds.length > 1) {
                    oldLineCnt = flds[1];
                }
                flds = StringUtilities.splitString(newStr, ",");
                String newLineCnt = "1";
                String newLineNum = flds[0];
                if (flds.length > 1) {
                    newLineCnt = flds[1];
                }
                sep = new JSeparator(0);
                this.diffPanel.add(sep);
                sep = new JSeparator(0);
                this.diffPanel.add(sep);
                lbl = this.createDiffLabel("Line " + oldLineNum);
                lbl.setFont(this.headerFont);
                lbl.setBackground(this.clrHeader);
                lbl.setForeground(Color.black);
                this.diffPanel.add(lbl);
                lbl = this.createDiffLabel("Line " + newLineNum);
                lbl.setFont(this.headerFont);
                lbl.setBackground(this.clrHeader);
                lbl.setForeground(Color.black);
                this.diffPanel.add(lbl);
                sep = new JSeparator(0);
                this.diffPanel.add(sep);
                sep = new JSeparator(0);
                this.diffPanel.add(sep);
                state = 68;
                ltColV.removeAllElements();
                rtColV.removeAllElements();
            } else {
                char diffCode = ln.charAt(0);
                String remStr = ln.substring(1);
                remStr = this.spaceTabs(remStr);
                if (diffCode == '+') {
                    if (state == 68) {
                        lbl = this.createDiffLabel(" ");
                        lbl.setBackground(this.clrBack);
                        this.diffPanel.add(lbl);
                        lbl = this.createDiffLabel(remStr.length() == 0 ? " " : remStr);
                        lbl.setBackground(this.clrAdd);
                        this.diffPanel.add(lbl);
                    } else {
                        state = 67;
                        rtColV.addElement(remStr);
                    }
                } else if (diffCode == '-') {
                    state = 82;
                    ltColV.addElement(remStr);
                } else {
                    this.appendDiffElements((char)state, ltColV, rtColV);
                    lbl = this.createDiffLabel(remStr);
                    lbl.setBackground(this.clrBack);
                    this.diffPanel.add(lbl);
                    lbl = this.createDiffLabel(remStr);
                    lbl.setBackground(this.clrBack);
                    this.diffPanel.add(lbl);
                    state = 68;
                    ltColV.removeAllElements();
                    rtColV.removeAllElements();
                }
            }
            ++lnIdx;
        }
        this.appendDiffElements((char)state, ltColV, rtColV);
        this.appendLegend(revStrs);
    }

    private void appendDiffElements(char state, Vector ltColV, Vector rtColV) {
        block7: {
            JLabel lbl;
            block6: {
                lbl = null;
                if (state != 'R') break block6;
                int j = 0;
                while (j < ltColV.size()) {
                    lbl = this.createDiffLabel((String)ltColV.elementAt(j));
                    lbl.setBackground(this.clrRmv);
                    this.diffPanel.add(lbl);
                    lbl = this.createDiffLabel(" ");
                    lbl.setBackground(this.clrBack);
                    this.diffPanel.add(lbl);
                    ++j;
                }
                break block7;
            }
            if (state != 'C') break block7;
            int j = 0;
            while (j < ltColV.size() || j < rtColV.size()) {
                if (j < ltColV.size()) {
                    lbl = this.createDiffLabel((String)ltColV.elementAt(j));
                    lbl.setBackground(this.clrChg);
                    this.diffPanel.add(lbl);
                } else {
                    lbl = this.createDiffLabel(" ");
                    lbl.setBackground(this.clrChgDk);
                    this.diffPanel.add(lbl);
                }
                if (j < rtColV.size()) {
                    lbl = this.createDiffLabel((String)rtColV.elementAt(j));
                    lbl.setBackground(this.clrChg);
                    this.diffPanel.add(lbl);
                } else {
                    lbl = this.createDiffLabel(" ");
                    lbl.setBackground(this.clrChgDk);
                    this.diffPanel.add(lbl);
                }
                ++j;
            }
        }
    }

    private void appendLegend(String[] revStrs) {
        JLabel lbl = null;
        JPanel outerPan = new JPanel();
        outerPan.setOpaque(true);
        outerPan.setBackground(this.clrBack);
        outerPan.setLayout(new GridBagLayout());
        outerPan.setBorder(new CompoundBorder(new EmptyBorder(3, 3, 3, 3), new EtchedBorder(0)));
        AWTUtilities.constrain(this.mainPanel, outerPan, 2, 11, 0, this.dRow++, 2, 1, 1.0, 0.0, new Insets(0, 0, 0, 0));
        JPanel legendPan = new JPanel();
        legendPan.setOpaque(true);
        legendPan.setBackground(this.clrTitle);
        legendPan.setLayout(new GridBagLayout());
        AWTUtilities.constrain(outerPan, legendPan, 2, 11, 0, 0, 1, 1, 1.0, 0.0, new Insets(0, 0, 0, 0));
        int subCol = 0;
        int subRow = 0;
        lbl = new JLabel(" LEGEND ", 0);
        lbl.setFont(this.titleFont);
        lbl.setOpaque(true);
        lbl.setBackground(this.clrTitle);
        lbl.setForeground(Color.black);
        AWTUtilities.constrain(legendPan, lbl, 2, 11, subCol++, subRow, 2, 1, 1.0, 0.0, new Insets(0, 0, 0, 0));
        subCol = 0;
        AWTUtilities.constrain(legendPan, new JSeparator(0), 2, 11, subCol++, ++subRow, 2, 1, 1.0, 0.0, new Insets(0, 0, 0, 0));
        subCol = 0;
        ++subRow;
        String verStr = revStrs[0].equalsIgnoreCase("Current") ? "current version" : "version " + revStrs[0];
        lbl = new JLabel("Removed from " + verStr + ".", 0);
        lbl.setOpaque(true);
        lbl.setBackground(this.clrRmv);
        lbl.setForeground(Color.black);
        AWTUtilities.constrain(legendPan, lbl, 2, 11, subCol++, subRow, 1, 1, 1.0, 0.0, new Insets(0, 0, 0, 0));
        lbl = new JLabel(" ");
        lbl.setOpaque(true);
        lbl.setBackground(this.clrBack);
        AWTUtilities.constrain(legendPan, lbl, 2, 11, subCol++, subRow, 1, 1, 1.0, 0.0, new Insets(0, 0, 0, 0));
        subCol = 0;
        lbl = new JLabel("Changed between the versions.", 0);
        lbl.setOpaque(true);
        lbl.setBackground(this.clrChg);
        lbl.setForeground(Color.black);
        AWTUtilities.constrain(legendPan, lbl, 2, 11, subCol++, ++subRow, 2, 1, 1.0, 0.0, new Insets(0, 0, 0, 0));
        subCol = 0;
        lbl = new JLabel(" ");
        lbl.setOpaque(true);
        lbl.setBackground(this.clrBack);
        AWTUtilities.constrain(legendPan, lbl, 2, 11, subCol++, ++subRow, 1, 1, 1.0, 0.0, new Insets(0, 0, 0, 0));
        verStr = revStrs[1].equalsIgnoreCase("Current") ? "current version" : "version " + revStrs[1];
        lbl = new JLabel("Inserted into " + verStr + ".", 0);
        lbl.setOpaque(true);
        lbl.setBackground(this.clrAdd);
        lbl.setForeground(Color.black);
        AWTUtilities.constrain(legendPan, lbl, 2, 11, subCol++, subRow, 1, 1, 1.0, 0.0, new Insets(0, 0, 0, 0));
        this.dCol = 0;
        ++this.dRow;
    }

    private void establishMenuBar() {
        JMenuBar mBar = new JMenuBar();
        JMenu mFile = new JMenu("File", true);
        mBar.add(mFile);
        JMenuItem mItem = new JMenuItem("Close Window");
        mFile.add(mItem);
        mItem.addActionListener(this);
        mItem.setActionCommand("Close");
        mItem.setAccelerator(KeyStroke.getKeyStroke(87, 2));
        this.setJMenuBar(mBar);
    }
}

