/*
 * Decompiled with CFR 0.152.
 */
package com.ice.jcvsii;

import com.ice.cvsc.CVSArgumentVector;
import com.ice.cvsc.CVSCUtilities;
import com.ice.cvsc.CVSClient;
import com.ice.cvsc.CVSEntry;
import com.ice.cvsc.CVSEntryVector;
import com.ice.cvsc.CVSIgnore;
import com.ice.cvsc.CVSLog;
import com.ice.cvsc.CVSProject;
import com.ice.cvsc.CVSRequest;
import com.ice.cvsc.CVSResponse;
import com.ice.cvsc.CVSTracer;
import com.ice.cvsc.CVSUserInterface;
import com.ice.jcvsii.CVSThread;
import com.ice.jcvsii.CVSUserDialog;
import com.ice.jcvsii.CVSUtilities;
import com.ice.jcvsii.Config;
import com.ice.jcvsii.EntryNode;
import com.ice.jcvsii.EntryPanel;
import com.ice.jcvsii.HTMLDialog;
import com.ice.jcvsii.JAFUtilities;
import com.ice.jcvsii.JCVS;
import com.ice.jcvsii.MessageDialog;
import com.ice.jcvsii.NewFilesDialog;
import com.ice.jcvsii.OutputFrame;
import com.ice.jcvsii.PasswordDialog;
import com.ice.jcvsii.PrettyDiffFrame;
import com.ice.jcvsii.ProjectFrameMgr;
import com.ice.jcvsii.ReleaseDetailsDialog;
import com.ice.jcvsii.ResourceMgr;
import com.ice.jcvsii.UnknownFilesDialog;
import com.ice.pref.UserPrefs;
import com.ice.util.AWTUtilities;
import com.ice.util.StringUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ProjectFrame
extends JFrame
implements ActionListener,
CVSUserInterface {
    public static final String RCS_ID = "$Id: ProjectFrame.java,v 1.12 2003/07/27 04:53:06 time Exp $";
    public static final String RCS_REV = "$Revision: 1.12 $";
    private CVSProject project;
    private OutputFrame output;
    private UserPrefs prefs;
    private CVSEntryVector entries;
    private CVSEntryVector popupEntries;
    private String displayStdout;
    private String displayStderr;
    private String lastUserFileDir;
    private boolean briefArgs;
    private JPanel argumentsPan;
    private JTextArea argumentText;
    private JLabel feedback;
    private EntryPanel entryPanel;
    private JMenuBar mBar;
    private JMenu mFile;
    private JCheckBoxMenuItem traceCheckItem;
    private Cursor saveCursor;
    private boolean traceReq = false;
    private boolean traceResp = false;
    private boolean traceProc = false;
    private boolean traceTCP = false;
    private boolean releasingProject = false;
    private boolean prettyDiffs = false;

    public ProjectFrame(String title, CVSProject project) {
        super(title);
        this.initialize(project);
        this.establishMenuBar();
        this.establishContents();
        this.loadPreferences();
        this.show();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ProjectFrame.this.dispose();
            }

            public void windowClosed(WindowEvent e) {
                ProjectFrame.this.windowBeingClosed();
            }
        });
    }

    private void initialize(CVSProject project) {
        this.project = project;
        this.output = null;
        this.entries = null;
        this.popupEntries = null;
        this.briefArgs = true;
        this.feedback = null;
        this.argumentsPan = null;
        this.saveCursor = null;
        this.displayStdout = "";
        this.displayStderr = "";
        this.lastUserFileDir = null;
        this.releasingProject = false;
        Config cfg = Config.getInstance();
        this.prefs = new UserPrefs(project.getRepository(), cfg.getPrefs());
        this.prefs.setPropertyPrefix("jcvsii.");
        cfg.loadProjectPreferences(project, this.prefs);
        this.traceResp = this.traceReq = this.prefs.getBoolean("global.traceAll", false);
        this.traceProc = this.traceReq;
        this.traceTCP = this.traceReq;
    }

    public void windowBeingClosed() {
        ProjectFrameMgr.removeProject(this, this.project.getLocalRootPath());
        this.savePreferences();
        if (this.output != null) {
            this.output.savePreferences();
            this.output.dispose();
            this.output = null;
        }
        if (!this.releasingProject) {
            Config.getInstance().saveProjectPreferences(this.project, this.prefs);
        }
    }

    public UserPrefs getPreferences() {
        return this.prefs;
    }

    public void loadPreferences() {
        this.entryPanel.loadPreferences(this.prefs);
        Rectangle bounds = this.prefs.getBounds("project.bounds", new Rectangle(20, 40, 525, 440));
        this.setBounds(bounds);
    }

    public void savePreferences() {
        Rectangle bounds = this.getBounds();
        if (bounds.x >= 0 && bounds.y >= 0 && bounds.width > 0 && bounds.height > 0) {
            this.prefs.setBounds("project.bounds", bounds);
        }
        this.entryPanel.savePreferences(this.prefs);
    }

    public void actionPerformed(ActionEvent evt) {
        int index;
        String command = evt.getActionCommand();
        if (command.startsWith("POPUP:")) {
            command = command.substring(6);
            this.popupEntries = (CVSEntryVector)evt.getSource();
        }
        if ((index = command.indexOf(38)) < 0) {
            this.performActionLine(command, evt);
        } else {
            StringTokenizer toker = new StringTokenizer(command, "&");
            while (toker.hasMoreTokens()) {
                String token;
                try {
                    token = toker.nextToken();
                }
                catch (NoSuchElementException ex) {
                    break;
                }
                if (token == null || token.length() < 1) break;
                this.performActionLine(token, evt);
            }
        }
        this.popupEntries = null;
    }

    public void performActionLine(String command, ActionEvent event) {
        if (command.startsWith("CVS:")) {
            String subCmd = command.substring(4);
            this.prettyDiffs = false;
            this.performCVSCommand(subCmd);
        } else if (command.startsWith("JCVS:")) {
            String subCmd = command.substring(5);
            this.performJCVSCommand(subCmd);
        } else if (command.equalsIgnoreCase("Close")) {
            this.performJCVSCommand("Close");
        }
    }

    protected boolean performJCVSCommand(String command) {
        boolean result = true;
        if (command.startsWith("FMSG:")) {
            String message = command.substring(5);
            this.showFeedback(message);
        } else if (command.startsWith("NOTE:")) {
            String message = command.substring(5);
            CVSUserDialog.Note(this, message);
        } else if (command.startsWith("ERROR:")) {
            String message = command.substring(6);
            CVSUserDialog.Error(this, message);
        } else if (command.startsWith("PDIFF:")) {
            String subCmd = command.substring(6);
            this.prettyDiffs = true;
            this.performCVSCommand(subCmd);
        } else if (command.equals("TRACE")) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (ProjectFrame.this.traceCheckItem.getState()) {
                        ProjectFrame.this.traceReq = true;
                        ProjectFrame.this.traceResp = true;
                        ProjectFrame.this.traceProc = true;
                        ProjectFrame.this.traceTCP = true;
                    } else {
                        ProjectFrame.this.traceReq = false;
                        ProjectFrame.this.traceResp = false;
                        ProjectFrame.this.traceProc = false;
                        ProjectFrame.this.traceTCP = false;
                    }
                }
            });
        } else if (command.startsWith("DisplayUnkFiles:")) {
            String subCmd = command.substring("DisplayUnkFiles:".length());
            this.processUnknownFiles(subCmd);
        } else if (command.equalsIgnoreCase("DisplayUnkDirs")) {
            this.processUnknownDirs();
        } else if (command.equalsIgnoreCase("Close")) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ProjectFrame.this.dispose();
                }
            });
        } else if (command.equalsIgnoreCase("HideOutputWindow")) {
            if (this.output != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ProjectFrame.this.output.setVisible(false);
                    }
                });
            }
        } else if (command.equalsIgnoreCase("CloseOutputWindow")) {
            if (this.output != null) {
                this.output.dispose();
                this.output = null;
            }
        } else if (command.equalsIgnoreCase("ShowOutputWindow")) {
            this.ensureOutputAvailable();
            if (this.output != null) {
                this.output.show();
                this.output.toFront();
                this.output.requestFocus();
            }
        } else if (command.equalsIgnoreCase("OpenAllEntries")) {
            this.openAllEntries();
        } else if (command.equalsIgnoreCase("CloseAllEntries")) {
            this.closeAllEntries();
        } else if (command.equalsIgnoreCase("SelectNoEntries")) {
            this.selectNoEntries();
        } else if (command.equalsIgnoreCase("SelectAllEntries")) {
            this.selectAllEntries();
        } else if (command.equalsIgnoreCase("SelectModifiedEntries")) {
            this.selectModifiedEntries();
        } else if (command.equalsIgnoreCase("ShowDetails")) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ProjectFrame.this.displayProjectDetails();
                }
            });
        } else if (command.equalsIgnoreCase("ClearResults")) {
            this.ensureOutputAvailable();
            if (this.output != null) {
                this.output.setText("");
            }
        } else if (command.equalsIgnoreCase("ClearArgText")) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ProjectFrame.this.clearArgumentsText();
                }
            });
        } else if (command.equalsIgnoreCase("PerformLogin")) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ProjectFrame.this.performLogin();
                }
            });
        } else if (command.equalsIgnoreCase("AddToWorkBench")) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ProjectFrame.this.addToWorkBench();
                }
            });
        } else if (command.equalsIgnoreCase("ExpandBelow")) {
            TreePath[] selPaths = this.entryPanel.getSelectionPaths();
            if (selPaths != null) {
                int nIdx = 0;
                while (nIdx < selPaths.length) {
                    TreePath selPath = selPaths[nIdx];
                    EntryNode node = (EntryNode)selPath.getLastPathComponent();
                    if (!node.isLeaf()) {
                        this.entryPanel.expandAll(node);
                        this.entryPanel.clearSelection(selPath);
                    }
                    ++nIdx;
                }
            }
        } else if (command.equalsIgnoreCase("SelectBelow")) {
            TreePath[] selPaths = this.entryPanel.getSelectionPaths();
            if (selPaths != null) {
                int nIdx = 0;
                while (nIdx < selPaths.length) {
                    TreePath selPath = selPaths[nIdx];
                    EntryNode node = (EntryNode)selPath.getLastPathComponent();
                    if (!node.isLeaf()) {
                        this.entryPanel.selectAll(node);
                        this.entryPanel.clearSelection(selPath);
                    }
                    ++nIdx;
                }
            }
        } else if (command.startsWith("OPEN:")) {
            int selector = CVSRequest.parseEntriesSelector(command.charAt(5));
            String verb = "edit";
            if (command.length() > 7) {
                verb = command.substring(7);
            }
            CVSEntryVector entries = this.getEntriesToActUpon(selector);
            int eIdx = 0;
            while (entries != null && eIdx < entries.size()) {
                CVSEntry entry = entries.entryAt(eIdx);
                if (entry != null) {
                    File entryFile = this.project.getLocalEntryFile(entry);
                    JAFUtilities.openFile(entry.getName(), entryFile, verb);
                } else {
                    new Throwable("NULL ENTRY[" + eIdx + "] on command '" + command + "'").printStackTrace();
                }
                ++eIdx;
            }
        } else if (command.startsWith("MOVE:")) {
            String backupPattern = command.substring(7);
            int selector = CVSRequest.parseEntriesSelector(command.charAt(5));
            CVSEntryVector entries = this.getEntriesToActUpon(selector);
            int eIdx = 0;
            while (entries != null && eIdx < entries.size()) {
                CVSEntry entry = entries.entryAt(eIdx);
                if (entry != null) {
                    File entryFile = this.project.getLocalEntryFile(entry);
                    if (!CVSUtilities.renameFile(entryFile, backupPattern, true)) {
                        Object[] fmtArgs = new String[]{entryFile.getPath()};
                        String msg = ResourceMgr.getInstance().getUIFormat("project.rename.failed.msg", fmtArgs);
                        String title = ResourceMgr.getInstance().getUIString("project.rename.failed.title");
                        JOptionPane.showMessageDialog(this, msg, title, 0);
                        break;
                    }
                } else {
                    new Throwable("NULL ENTRY[" + eIdx + "] on command '" + command + "'").printStackTrace();
                }
                ++eIdx;
            }
        } else if (command.startsWith("COPY:")) {
            String copyPattern = command.substring(7);
            int selector = CVSRequest.parseEntriesSelector(command.charAt(5));
            CVSEntryVector entries = this.getEntriesToActUpon(selector);
            int eIdx = 0;
            while (entries != null && eIdx < entries.size()) {
                CVSEntry entry = entries.entryAt(eIdx);
                if (entry != null) {
                    File entryFile = this.project.getLocalEntryFile(entry);
                    if (!CVSUtilities.copyFile(entryFile, copyPattern)) {
                        Object[] fmtArgs = new String[]{entryFile.getPath()};
                        String msg = ResourceMgr.getInstance().getUIFormat("project.copy.failed.msg", fmtArgs);
                        String title = ResourceMgr.getInstance().getUIString("project.copy.failed.title");
                        JOptionPane.showMessageDialog(this, msg, title, 0);
                        break;
                    }
                } else {
                    new Throwable("NULL ENTRY[" + eIdx + "] on command '" + command + "'").printStackTrace();
                }
                ++eIdx;
            }
        } else if (command.startsWith("CMDLINE:")) {
            String subCmd = command.substring(8);
            this.performCVSCommandLine(subCmd);
        } else if (command.startsWith("ADDDIR:")) {
            String subCmd = command.substring(8);
            this.performAddDirectory(subCmd);
        }
        return result;
    }

    private void addToWorkBench() {
        JCVS.getMainFrame().addProjectToWorkBench(this.project);
    }

    public void displayProjectDetails() {
        String type = Config.getPreferences().getProperty("project.details.content.type", "text/plain");
        if (type.equalsIgnoreCase("text/html")) {
            this.displayProjectDetailsHTML();
        } else {
            this.displayProjectDetailsPlain();
        }
    }

    public void displayProjectDetailsHTML() {
        Object[] fmtArgs = new Object[]{this.project.getRepository(), this.project.getRootDirectory(), this.project.getClient().getHostName(), new Integer(this.project.getClient().getPort()), this.project.getLocalRootDirectory()};
        String msgStr = ResourceMgr.getInstance().getUIFormat("project.details.dialog.html", fmtArgs);
        String title = ResourceMgr.getInstance().getUIString("project.details.dialog.title");
        new HTMLDialog((Frame)this, title, true, msgStr).show();
    }

    public void displayProjectDetailsPlain() {
        Object[] fmtArgs = new Object[]{this.project.getRepository(), this.project.getRootDirectory(), this.project.getClient().getHostName(), new Integer(this.project.getClient().getPort()), this.project.getLocalRootDirectory()};
        String msgStr = ResourceMgr.getInstance().getUIFormat("project.details.dialog.text", fmtArgs);
        String title = ResourceMgr.getInstance().getUIString("project.details.dialog.title");
        JOptionPane.showMessageDialog(this, msgStr, title, 1);
    }

    public synchronized void showFeedback(String message) {
        this.feedback.setText(message);
        this.feedback.repaint(0L);
    }

    public void verifyLogin() {
        if (!this.project.isPServer() && !this.project.isSSHServer()) {
            return;
        }
        String password = this.project.getPassword();
        if (password == null) {
            this.performLogin();
        }
    }

    public void performLogin() {
        if (!this.project.isPServer() && !this.project.isSSHServer()) {
            return;
        }
        String userName = this.project.getUserName();
        PasswordDialog passDialog = new PasswordDialog((Frame)this, userName);
        passDialog.show();
        userName = passDialog.getUserName();
        String password = passDialog.getPassword();
        if (userName != null && password != null) {
            this.setWaitCursor();
            boolean valid = this.project.verifyPassword(this, userName, password, this.traceReq);
            this.resetCursor();
            if (!valid) {
                Object[] fmtArgs = new String[]{userName};
                String msg = ResourceMgr.getInstance().getUIFormat("project.login.failed.msg", fmtArgs);
                String title = ResourceMgr.getInstance().getUIString("project.login.failed.title");
                JOptionPane.showMessageDialog(this, msg, title, 0);
            }
        }
    }

    public void performCheckOut(String checkOutCommand) {
        boolean result = this.commonCVSCommand(checkOutCommand, null, null);
        if (result) {
            this.project.writeAdminFiles();
        } else {
            String msg = ResourceMgr.getInstance().getUIString("project.checkout.failed.msg");
            String title = ResourceMgr.getInstance().getUIString("project.checkout.failed.title");
            JOptionPane.showMessageDialog(this, msg, title, 0);
        }
    }

    protected void performAddDirectory(String commandSpec) {
        String prompt = ResourceMgr.getInstance().getUIString("global.directory.name.prompt");
        String dirPath = JOptionPane.showInputDialog(prompt);
        if (dirPath != null) {
            CVSEntryVector entries = this.getEntriesToActUpon(12);
            if (entries != null && entries.size() > 0) {
                StringBuffer addPath = new StringBuffer();
                CVSEntry dirEntry = entries.entryAt(0);
                if (dirEntry == this.project.getRootEntry()) {
                    addPath.append(dirEntry.getLocalDirectory() + dirPath);
                } else {
                    addPath.append(dirEntry.getFullName() + "/" + dirPath);
                }
                if (!addPath.toString().endsWith("/")) {
                    addPath.append("/");
                }
                addPath.append(".");
                CVSResponse result = this.project.ensureRepositoryPath(this, addPath.toString(), new CVSResponse());
                if (result.getStatus() != 0) {
                    Object[] fmtArgs = new String[]{dirPath, result.getStderr(), result.getStdout()};
                    String msg = ResourceMgr.getInstance().getUIFormat("project.diradd.failed.msg", fmtArgs);
                    String title = ResourceMgr.getInstance().getUIString("project.diradd.failed.title");
                    JOptionPane.showMessageDialog(this, msg, title, 0);
                } else {
                    this.showFeedback("Updating entries list...");
                    this.project.writeAdminFiles();
                    this.showFeedback("Done.");
                    this.entryPanel.repaint(500L);
                }
            } else {
                new Throwable("The entries list is EMPTY!!!").printStackTrace();
            }
        }
    }

    protected void performCVSCommandLine(String commandSpec) {
        CVSArgumentVector arguments;
        String command = null;
        String prompt = ResourceMgr.getInstance().getUIString("project.cvs.command.prompt");
        String commandLine = JOptionPane.showInputDialog(prompt);
        if (commandLine != null && (arguments = CVSArgumentVector.parseArgumentString(commandLine)).size() > 0) {
            command = (String)arguments.elementAt(0);
            arguments.removeElementAt(0);
            this.commonCVSCommand(command + ":" + commandSpec, null, arguments);
        }
    }

    protected boolean performCVSCommand(String command) {
        boolean result = true;
        if (command.startsWith("Notify:")) {
            int selectCh = CVSRequest.parseEntriesSelector(command.charAt(7));
            String options = "";
            String noteType = command.substring(9, 10);
            if (noteType.equals("E")) {
                options = command.substring(11);
            }
            CVSEntryVector entries = this.getEntriesToActUpon(selectCh);
            this.project.addEntryNotify(entries, noteType, options);
        } else if (command.startsWith("release:")) {
            boolean doit = true;
            Vector mods = new Vector();
            Vector adds = new Vector();
            Vector rems = new Vector();
            Vector unks = new Vector();
            CVSIgnore ignore = new CVSIgnore();
            Config cfg = Config.getInstance();
            UserPrefs prefs = cfg.getPreferences();
            String userIgnores = prefs.getProperty("global.userIgnores", null);
            if (userIgnores != null) {
                ignore.addIgnoreSpec(userIgnores);
            }
            if (this.project.checkReleaseStatus(ignore, mods, adds, rems, unks)) {
                ReleaseDetailsDialog dlg = new ReleaseDetailsDialog(this, adds, mods, rems, unks);
                dlg.show();
                doit = dlg.clickedOk();
            } else {
                String title;
                String prompt = ResourceMgr.getInstance().getUIString("project.confirm.release.clean.prompt");
                boolean bl = doit = JOptionPane.showConfirmDialog(this, prompt, title = ResourceMgr.getInstance().getUIString("project.confirm.release.clean.title"), 0, 3) == 0;
            }
            if (doit) {
                this.releasingProject = true;
                this.commonCVSCommand(command, null, null);
            }
        } else {
            this.commonCVSCommand(command, null, null);
        }
        return result;
    }

    private boolean commonCVSCommand(String command, CVSEntryVector entries, CVSArgumentVector arguments) {
        CVSArgumentVector args;
        boolean allok = true;
        this.setWaitCursor();
        ResourceMgr rmgr = ResourceMgr.getInstance();
        String fdbkStr = rmgr.getUIString("project.fdbk.buildcvsreq");
        this.showFeedback(fdbkStr);
        CVSRequest request = new CVSRequest();
        request.setArguments(new CVSArgumentVector());
        request.setGlobalArguments(new CVSArgumentVector());
        request.traceRequest = this.traceReq;
        request.traceResponse = this.traceResp;
        request.traceProcessing = this.traceProc;
        request.traceTCPData = this.traceTCP;
        if (arguments != null) {
            request.appendArguments(arguments);
        } else {
            String argStr = this.getArgumentString();
            request.parseArgumentString(argStr.trim());
        }
        allok = request.parseControlString(command);
        if (!allok) {
            Object[] fmtArgs = new String[]{command, request.getVerifyFailReason()};
            String msg = ResourceMgr.getInstance().getUIFormat("project.cmdparse.failed.msg", fmtArgs);
            String title = ResourceMgr.getInstance().getUIString("project.cmdparse.failed.title");
            JOptionPane.showMessageDialog(this, msg, title, 0);
        }
        int portNum = CVSUtilities.computePortNum(this.project.getClient().getHostName(), this.project.getConnectionMethod(), this.project.isPServer());
        if (!request.queueResponse) {
            request.responseHandler = this.project;
        }
        request.setPort(portNum);
        if (request.redirectOutput && !this.setRedirectWriter(request)) {
            fdbkStr = rmgr.getUIString("project.fdbk.canceled");
            this.showFeedback(fdbkStr);
            this.resetCursor();
            return true;
        }
        if (entries == null) {
            if (request.getEntrySelector() == 0) {
                entries = new CVSEntryVector();
            } else {
                entries = this.getEntriesToActUpon(request.getEntrySelector());
                int selector = request.getEntrySelector();
                if ((selector == 10 || selector == 11) && entries == null) {
                    fdbkStr = rmgr.getUIString("project.fdbk.canceled");
                    this.showFeedback(fdbkStr);
                    this.resetCursor();
                    return true;
                }
                if (request.execInCurDir && request.getEntrySelector() == 12) {
                    CVSEntry dirEnt = entries.entryAt(0);
                    if (dirEnt != null && dirEnt.isDirectory()) {
                        request.setDirEntry(entries.entryAt(0));
                    } else {
                        CVSTracer.traceWithStack("dirEnt is WRONG!");
                    }
                }
            }
        }
        if (entries == null) {
            Object[] fmtArgs = new String[]{request.getCommand()};
            String msg = ResourceMgr.getInstance().getUIFormat("project.no.selection.msg", fmtArgs);
            String title = ResourceMgr.getInstance().getUIString("project.no.selection.title");
            JOptionPane.showMessageDialog(this, msg, title, 0);
            allok = false;
        }
        if (allok && request.guaranteeMsg && !(args = request.getArguments()).containsArgument("-m")) {
            Object[] fmtArgs = new String[]{request.getCommand()};
            String prompt = ResourceMgr.getInstance().getUIFormat("project.message.required.prompt", fmtArgs);
            String msgStr = this.requestMessageArgument(prompt);
            if (msgStr != null) {
                args.addElement("-m");
                args.addElement(msgStr);
            } else {
                allok = false;
            }
        }
        if (allok) {
            this.setWaitCursor();
            this.setUIAvailable(false);
            request.setEntries(entries);
            fdbkStr = rmgr.getUIString("project.fdbk.sendreq");
            this.showFeedback(fdbkStr);
            this.clearArgumentsText();
            request.setUserInterface(this);
            CVSResponse response = new CVSResponse();
            String string = request.getCommand();
            ProjectFrame projectFrame = this;
            projectFrame.getClass();
            MyRunner myRunner = projectFrame.new MyRunner(request, response);
            ProjectFrame projectFrame2 = this;
            projectFrame2.getClass();
            CVSThread thread = new CVSThread(string, (Runnable)myRunner, projectFrame2.new MyMonitor(request, response));
            thread.start();
        } else {
            this.resetCursor();
        }
        return allok;
    }

    public void setUIAvailable(boolean avail) {
    }

    protected void focusArguments() {
        this.argumentText.requestFocus();
    }

    protected void clearArgumentsText() {
        this.argumentText.setText("");
        this.argumentText.requestFocus();
    }

    protected String getArgumentString() {
        return this.argumentText.getText();
    }

    protected void setWaitCursor() {
        this.setCursor(Cursor.getPredefinedCursor(3));
    }

    protected void resetCursor() {
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void selectNoEntries() {
        this.entryPanel.clearSelection();
    }

    public void selectAllEntries() {
        this.entryPanel.selectAll();
    }

    public void selectModifiedEntries() {
        this.entryPanel.selectModified();
    }

    public void openAllEntries() {
        this.entryPanel.expandAll(true);
    }

    public void closeAllEntries() {
        this.entryPanel.expandAll(false);
    }

    protected CVSEntryVector getSelectedEntries(boolean expandDirEntries) {
        CVSEntryVector entries = new CVSEntryVector();
        TreePath[] selPaths = this.entryPanel.getSelectionPaths();
        if (selPaths != null) {
            int i = 0;
            while (i < selPaths.length) {
                EntryNode node = (EntryNode)selPaths[i].getLastPathComponent();
                if (node.isLeaf() || !expandDirEntries) {
                    entries.appendEntry(node.getEntry());
                } else {
                    Enumeration<TreeNode> chEnum = node.children();
                    while (chEnum.hasMoreElements()) {
                        EntryNode chNode = (EntryNode)chEnum.nextElement();
                        entries.appendEntry(chNode.getEntry());
                    }
                }
                ++i;
            }
        }
        return entries;
    }

    private CVSEntry createAddFileEntry(String entryName, String localDirectory, String repository) {
        CVSEntry entry = new CVSEntry();
        entry.setName(entryName);
        entry.setLocalDirectory(localDirectory);
        entry.setRepository(repository);
        entry.setTimestamp(this.project.getEntryFile(entry));
        entry.setVersion("0");
        return entry;
    }

    public CVSEntryVector getEntriesToActUpon(int selector) {
        CVSEntry entry = null;
        CVSEntryVector entries = null;
        if (selector == 10) {
            entries = this.getUserSelectedFile();
        } else if (selector == 11) {
            entries = this.getNewlyAddedFiles();
        } else if (selector == 12) {
            entries = this.popupEntries;
        } else {
            if (selector == 2 || selector == 3 || selector == 5 || selector == 7 || selector == 9) {
                entries = this.getSelectedEntries(true);
                if (entries.size() == 0) {
                    entries = new CVSEntryVector();
                    this.project.getRootEntry().addAllSubTreeEntries(entries);
                }
            } else {
                entries = new CVSEntryVector();
                this.project.getRootEntry().addAllSubTreeEntries(entries);
            }
            if (entries != null) {
                int i = 0;
                while (i < entries.size()) {
                    entry = entries.entryAt(i);
                    File entryFile = this.project.getEntryFile(entry);
                    if (selector == 4 || selector == 5) {
                        if (!this.project.isLocalFileModified(entry)) {
                            entries.removeElementAt(i);
                            --i;
                        }
                    } else if (selector == 6 || selector == 7) {
                        if (!entryFile.exists()) {
                            entries.removeElementAt(i);
                            --i;
                        }
                    } else if (!(selector != 8 && selector != 9 || entryFile.exists() && !this.project.isLocalFileModified(entry))) {
                        entries.removeElementAt(i);
                        --i;
                    }
                    ++i;
                }
            }
        }
        return entries;
    }

    public CVSEntryVector getNewlyAddedFiles() {
        CVSEntry dirEntry = null;
        this.entries = this.getSelectedEntries(false);
        if (this.entries == null || this.entries.size() == 0) {
            dirEntry = this.entryPanel.getRootNode().getEntry();
        } else {
            if (this.entries.size() != 1 || !this.entries.entryAt(0).isDirectory()) {
                String msg = ResourceMgr.getInstance().getUIString("project.new.one.entry.msg");
                String title = ResourceMgr.getInstance().getUIString("project.new.one.entry.title");
                JOptionPane.showMessageDialog(this, msg, title, 0);
                return null;
            }
            dirEntry = this.entries.entryAt(0);
        }
        String entryLocal = dirEntry.getLocalDirectory();
        String entryRepos = dirEntry.getRepository();
        File dirF = null;
        dirF = entryLocal.equals("./") ? new File(CVSCUtilities.exportPath(this.project.getLocalRootDirectory())) : new File(CVSCUtilities.exportPath(this.project.getLocalRootDirectory()), CVSCUtilities.exportPath(entryLocal.substring(2)));
        String prompt = ResourceMgr.getInstance().getUIString("project.new.files.dialog.prompt");
        NewFilesDialog dlg = new NewFilesDialog((Frame)this, true, prompt);
        dlg.refreshFileList(dirF, dirEntry);
        dlg.show();
        String[] files = dlg.getSelectedFiles();
        if (files.length == 0) {
            return null;
        }
        CVSEntryVector result = new CVSEntryVector();
        int i = 0;
        while (i < files.length) {
            CVSEntry entry = this.createAddFileEntry(files[i], entryLocal, entryRepos);
            result.appendEntry(entry);
            ++i;
        }
        return result;
    }

    public CVSEntryVector getUserSelectedFile() {
        CVSEntryVector result = null;
        String prompt = ResourceMgr.getInstance().getUIString("project.addfile.prompt");
        FileDialog dialog = new FileDialog((Frame)this, prompt, 0);
        String localPath = this.lastUserFileDir != null ? this.lastUserFileDir : CVSCUtilities.exportPath(this.project.getLocalRootDirectory());
        dialog.setDirectory(localPath);
        dialog.show();
        String fileName = dialog.getFile();
        if (fileName != null) {
            this.lastUserFileDir = dialog.getDirectory();
            localPath = CVSCUtilities.ensureFinalSlash(CVSCUtilities.importPath(this.lastUserFileDir));
            String rootRepos = CVSCUtilities.ensureFinalSlash(this.project.getRootDirectory());
            String localRootDir = CVSCUtilities.ensureFinalSlash(this.project.getLocalRootDirectory());
            if (CVSCUtilities.isSubpathInPath(localRootDir, localPath)) {
                result = new CVSEntryVector();
                String entryLocal = localPath.substring(localRootDir.length());
                String entryRepos = rootRepos + entryLocal;
                entryLocal = CVSCUtilities.ensureFinalSlash("./" + entryLocal);
                CVSEntry entry = this.createAddFileEntry(fileName, entryLocal, entryRepos);
                result.addElement(entry);
            } else {
                Object[] fmtArgs = new String[]{localPath, localRootDir};
                String msg = ResourceMgr.getInstance().getUIFormat("project.add.not.subtree.msg", fmtArgs);
                String title = ResourceMgr.getInstance().getUIString("project.add.not.subtree.title");
                JOptionPane.showMessageDialog(this, msg, title, 0);
            }
        }
        return result;
    }

    protected void displayFinalResults(boolean ok) {
        StringBuffer finalResult = new StringBuffer("");
        String resultLine = ok ? ResourceMgr.getInstance().getUIString("project.fdbk.result.ok") : ResourceMgr.getInstance().getUIString("project.fdbk.result.err");
        if (!ok || this.displayStderr.length() > 0 || this.displayStdout.length() > 0) {
            if (this.displayStderr.length() > 0) {
                finalResult.append(this.displayStderr);
                if (this.displayStdout.length() > 0) {
                    finalResult.append("\n");
                }
            }
            if (this.displayStdout.length() > 0) {
                finalResult.append(this.displayStdout);
            }
            finalResult.append("\n" + resultLine);
            this.ensureOutputAvailable();
            this.output.setText(finalResult.toString());
            this.output.setVisible(true);
            this.output.requestFocus();
        } else if (this.output != null) {
            this.output.setText(resultLine);
        }
        this.showFeedback(resultLine);
    }

    protected void displayPrettyDiffs(boolean ok) {
        String resultLine = ResourceMgr.getInstance().getUIString("project.fdbk.result.ok");
        if (!ok || this.displayStderr.length() > 0) {
            this.displayFinalResults(ok);
            resultLine = ResourceMgr.getInstance().getUIString("project.fdbk.result.err");
        } else if (ok && this.displayStdout.length() > 0) {
            PrettyDiffFrame diffFrame = new PrettyDiffFrame(this, "Diffs", null, this.displayStdout, null, null);
            Dimension sz = this.getSize();
            Point loc = this.getLocationOnScreen();
            Rectangle defBounds = new Rectangle(loc.x + 15, loc.y + 15, 600, 440);
            diffFrame.loadPreferences(defBounds);
            diffFrame.show();
        }
        this.showFeedback(resultLine);
    }

    private void establishContents() {
        int indent = 21;
        Dimension sz = this.getSize();
        UserPrefs prefs = Config.getPreferences();
        this.setBackground(prefs.getColor("projectWindow.bg", new Color(200, 215, 250)));
        this.argumentsPan = new JPanel();
        this.argumentsPan.setBorder(new CompoundBorder(new EtchedBorder(0), new EmptyBorder(3, 3, 3, 3)));
        this.argumentsPan.setLayout(new GridBagLayout());
        Font argFont = prefs.getFont("projectWindow.argumentFont", new Font("Monospaced", 1, 12));
        this.argumentText = new JTextArea();
        this.argumentText.setEditable(true);
        this.argumentText.setBackground(Color.white);
        this.argumentText.setFont(argFont);
        this.argumentText.setVisible(true);
        this.argumentText.setBorder(new LineBorder(Color.black));
        String lblStr = ResourceMgr.getInstance().getUIString("project.arguments.label");
        JLabel argsLbl = new JLabel(lblStr);
        argsLbl.setFont(new Font("Monospaced", 1, 12));
        argsLbl.setForeground(Color.black);
        AWTUtilities.constrain(this.argumentsPan, argsLbl, 2, 18, 0, 0, 1, 1, 1.0, 0.0);
        AWTUtilities.constrain(this.argumentsPan, this.argumentText, 2, 18, 0, 1, 1, 1, 1.0, 0.0);
        JButton eraserButton = null;
        try {
            Image iEraser = AWTUtilities.getImageResource("/com/ice/jcvsii/images/icons/eraser.gif");
            ImageIcon eraserIcon = new ImageIcon(iEraser);
            eraserButton = new JButton((Icon)eraserIcon){

                public boolean isFocusTraversable() {
                    return false;
                }
            };
            eraserButton.setOpaque(false);
            eraserButton.setMargin(new Insets(1, 1, 1, 1));
        }
        catch (IOException ex) {
            eraserButton = new JButton("x");
        }
        String tipStr = ResourceMgr.getInstance().getUIString("project.eraser.tip");
        eraserButton.setToolTipText(tipStr);
        eraserButton.addActionListener(this);
        eraserButton.setActionCommand("JCVS:ClearArgText");
        AWTUtilities.constrain(this.argumentsPan, eraserButton, 0, 15, 1, 0, 1, 2, 0.0, 0.0, new Insets(1, 5, 0, 3));
        this.entryPanel = new EntryPanel(this.project.getRootEntry(), this.project.getLocalRootDirectory(), this);
        this.feedback = new JLabel("jCVS II - TLYT == TLYM");
        this.feedback.setOpaque(true);
        this.feedback.setBackground(Color.white);
        this.feedback.setFont(prefs.getFont("projectWindow.feedback.font", new Font("Serif", 1, 12)));
        JPanel feedPan = new JPanel();
        feedPan.setLayout(new BorderLayout(0, 0));
        feedPan.setBorder(new EtchedBorder(0));
        feedPan.add("Center", this.feedback);
        Container content = this.getContentPane();
        content.setLayout(new GridBagLayout());
        int row = 0;
        AWTUtilities.constrain(content, this.argumentsPan, 2, 10, 0, row++, 1, 1, 1.0, 0.0);
        AWTUtilities.constrain(content, this.entryPanel, 1, 10, 0, row++, 1, 1, 1.0, 1.0);
        AWTUtilities.constrain(content, feedPan, 2, 17, 0, row++, 1, 1, 1.0, 0.0);
    }

    private void establishMenuBar() {
        ResourceMgr rmgr = ResourceMgr.getInstance();
        this.mBar = new JMenuBar();
        String name = rmgr.getUIString("menu.projW.file.name");
        this.mFile = new JMenu(name);
        this.mBar.add(this.mFile);
        name = rmgr.getUIString("menu.projW.file.hide.name");
        JMenuItem mItem = new JMenuItem(name);
        this.mFile.add(mItem);
        mItem.addActionListener(this);
        mItem.setActionCommand("JCVS:HideOutputWindow");
        mItem.setAccelerator(KeyStroke.getKeyStroke(72, 2));
        name = rmgr.getUIString("menu.projW.file.show.name");
        mItem = new JMenuItem(name);
        this.mFile.add(mItem);
        mItem.addActionListener(this);
        mItem.setActionCommand("JCVS:ShowOutputWindow");
        mItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.mFile.addSeparator();
        name = rmgr.getUIString("menu.projW.file.trace.name");
        this.traceCheckItem = new JCheckBoxMenuItem(name);
        this.mFile.add(this.traceCheckItem);
        this.traceCheckItem.setState(this.traceReq);
        this.traceCheckItem.addActionListener(this);
        this.traceCheckItem.setActionCommand("JCVS:TRACE");
        this.traceCheckItem.setAccelerator(KeyStroke.getKeyStroke(84, 2));
        this.mFile.addSeparator();
        if (this.project.isPServer() || this.project.isSSHServer()) {
            name = rmgr.getUIString("menu.projW.file.login.name");
            mItem = new JMenuItem(name);
            this.mFile.add(mItem);
            mItem.addActionListener(this);
            mItem.setActionCommand("JCVS:PerformLogin");
            mItem.setAccelerator(KeyStroke.getKeyStroke(76, 2));
            this.mFile.addSeparator();
        }
        name = rmgr.getUIString("menu.projW.file.details.name");
        mItem = new JMenuItem(name);
        this.mFile.add(mItem);
        mItem.addActionListener(this);
        mItem.setActionCommand("JCVS:ShowDetails");
        name = rmgr.getUIString("menu.projW.file.addto.name");
        mItem = new JMenuItem(name);
        this.mFile.add(mItem);
        mItem.addActionListener(this);
        mItem.setActionCommand("JCVS:AddToWorkBench");
        this.mFile.addSeparator();
        name = rmgr.getUIString("menu.projW.file.close.name");
        mItem = new JMenuItem(name);
        this.mFile.add(mItem);
        mItem.addActionListener(this);
        mItem.setActionCommand("Close");
        mItem.setAccelerator(KeyStroke.getKeyStroke(87, 2));
        this.addAdditionalMenus(this.mBar);
        String menuBarStr = Config.getPreferences().getProperty("projectMenuBar", null);
        if (menuBarStr != null) {
            this.buildCommandMenus(menuBarStr);
        }
        this.setJMenuBar(this.mBar);
    }

    public void addAdditionalMenus(JMenuBar menuBar) {
    }

    private void buildCommandMenus(String menuBarSpec) {
        UserPrefs prefs = Config.getPreferences();
        String[] menuList = StringUtilities.splitString(menuBarSpec, ":");
        if (menuList == null) {
            return;
        }
        int mIdx = 0;
        while (mIdx < menuList.length) {
            String menuString = prefs.getProperty("projectMenu." + menuList[mIdx], null);
            if (menuString == null) {
                CVSLog.logMsg("ProjectFrame.buildCommandMenus: Menu Definition '" + menuList[mIdx] + "' is missing.");
            } else {
                String[] itemList = StringUtilities.splitString(menuString, ":");
                if (itemList != null) {
                    JMenu menu = new JMenu(menuList[mIdx], true);
                    int iIdx = 0;
                    while (iIdx < itemList.length) {
                        String itemString = prefs.getProperty("projectMenuItem." + menuList[mIdx] + "." + itemList[iIdx], null);
                        if (itemString == null) {
                            CVSLog.logMsg("ProjectFrame.buildCommandMenus: Menu '" + menuList[mIdx] + "' is missing item string '" + itemList[iIdx] + "'");
                        } else {
                            int colonIdx = itemString.indexOf(58);
                            if (colonIdx < 0) {
                                CVSLog.logMsg("CVSProjectFrame.buildCommandMenus: Menu '" + menuList[mIdx] + "' Item '" + itemList[iIdx] + "' has an invalid definition [title:cvs].");
                            } else {
                                String title = itemString.substring(0, colonIdx);
                                String command = itemString.substring(colonIdx + 1);
                                if (title.equals("-")) {
                                    menu.addSeparator();
                                } else {
                                    JMenuItem mItem = new JMenuItem(title);
                                    mItem.setActionCommand(command);
                                    mItem.addActionListener(new ActionListener(){

                                        public void actionPerformed(ActionEvent e) {
                                            ProjectFrame projectFrame = ProjectFrame.this;
                                            projectFrame.getClass();
                                            SwingUtilities.invokeLater(projectFrame.new PJInvoker(e));
                                        }
                                    });
                                    menu.add(mItem);
                                }
                            }
                        }
                        ++iIdx;
                    }
                    this.mBar.add(menu);
                }
            }
            ++mIdx;
        }
    }

    public void uiDisplayProgressMsg(String message) {
        this.showFeedback(message);
    }

    public void uiDisplayProgramError(String error) {
        CVSLog.logMsg(error);
        CVSUserDialog.Error(error);
        CVSTracer.traceWithStack("CVSProjectFrame.uiDisplayProgramError: " + error);
    }

    public void uiDisplayResponse(CVSResponse response) {
        this.displayStdout = response.getStdout();
        this.displayStderr = response.getStderr();
    }

    private void ensureOutputAvailable() {
        if (this.output == null) {
            String name = ProjectFrame.getProjectDisplayName(this.project, this.project.getLocalRootDirectory());
            this.output = new OutputFrame(this, name + " Output");
            Dimension sz = this.getSize();
            Point loc = this.getLocationOnScreen();
            Rectangle defBounds = new Rectangle(loc.x + 15, loc.y + 15, sz.width, sz.height);
            this.output.loadPreferences(defBounds);
        }
    }

    public void outputIsClosing() {
        this.output = null;
    }

    public boolean setRedirectWriter(CVSRequest request) {
        boolean result = true;
        FileDialog dialog = new FileDialog((Frame)this, "Redirect Output", 1);
        String localDir = CVSCUtilities.exportPath(this.project.getLocalRootDirectory());
        dialog.setDirectory(localDir);
        dialog.show();
        String dirName = dialog.getDirectory();
        String fileName = dialog.getFile();
        if (dirName != null && fileName != null) {
            File outputFile = new File(dirName, fileName);
            PrintWriter pWriter = null;
            try {
                pWriter = new PrintWriter(new FileWriter(outputFile));
            }
            catch (IOException ex) {
                pWriter = null;
                result = false;
                Object[] fmtArgs = new String[]{outputFile.getPath(), ex.getMessage()};
                String msg = ResourceMgr.getInstance().getUIFormat("project.redirect.failed.msg", fmtArgs);
                String title = ResourceMgr.getInstance().getUIString("project.redirect.failed.title");
                JOptionPane.showMessageDialog(this, msg, title, 0);
            }
            request.setRedirectWriter(pWriter);
        } else {
            result = false;
        }
        return result;
    }

    protected String requestMessageArgument(String prompt) {
        MessageDialog dlg = new MessageDialog((Frame)this, true, prompt);
        dlg.show();
        return dlg.getMessage();
    }

    private static String getProjectDisplayName(CVSProject project, String localRootPath) {
        String name = project.getRepository();
        if (name.equals(".")) {
            String path = localRootPath;
            if (path.endsWith("/.") || path.endsWith(File.separator + ".")) {
                path = path.substring(0, path.length() - 2);
            }
            name = CVSUtilities.getFileName(path);
        }
        return name;
    }

    public static void openProject(File rootDirFile, String password) {
        block4: {
            Config cfg = Config.getInstance();
            UserPrefs prefs = cfg.getPreferences();
            CVSClient client = CVSUtilities.createCVSClient();
            CVSProject project = new CVSProject(client);
            project.setTempDirectory(cfg.getTemporaryDirectory());
            project.setAllowsGzipFileMode(prefs.getBoolean("global.allowGzipFileMode", true));
            project.setGzipStreamLevel(prefs.getInteger("global.gzipStreamLevel", 0));
            try {
                project.openProject(rootDirFile);
                int cvsPort = CVSUtilities.computePortNum(project.getClient().getHostName(), project.getConnectionMethod(), project.isPServer());
                project.setConnectionPort(cvsPort);
                project.getClient().setPort(cvsPort);
                if (project.getConnectionMethod() == 2) {
                    CVSUtilities.establishRSHProcess(project);
                }
                project.setServerCommand(CVSUtilities.establishServerCommand(project.getClient().getHostName(), project.getConnectionMethod(), project.isPServer()));
                project.setSetVariables(CVSUtilities.getUserSetVariables(project.getClient().getHostName()));
                String name = ProjectFrame.getProjectDisplayName(project, rootDirFile.getPath());
                String title = name + " Project";
                ProjectFrame frame = new ProjectFrame(title, project);
                ProjectFrameMgr.addProject(frame, rootDirFile.getPath());
                frame.toFront();
                frame.requestFocus();
                if (password != null) {
                    project.setPassword(password);
                    break block4;
                }
                frame.verifyLogin();
            }
            catch (IOException ex) {
                Object[] fmtArgs = new String[]{rootDirFile.getPath(), ex.getMessage()};
                String msg = ResourceMgr.getInstance().getUIFormat("project.openproject.failed.msg", fmtArgs);
                String title = ResourceMgr.getInstance().getUIString("project.openproject.failed.title");
                JOptionPane.showMessageDialog(null, msg, title, 0);
            }
        }
    }

    public static String getUserSelectedProject(Frame parent, String prompt, String initDir) {
        String result = null;
        UserPrefs prefs = Config.getPreferences();
        while (true) {
            FileDialog dialog = new FileDialog(parent, prompt, 0);
            dialog.setFile("Entries");
            if (initDir != null) {
                dialog.setDirectory(initDir);
            }
            dialog.show();
            String fileName = dialog.getFile();
            String dirName = dialog.getDirectory();
            if (fileName == null) break;
            if (fileName.equalsIgnoreCase("Entries")) {
                if (CVSProject.verifyAdminDirectory(dirName = CVSCUtilities.importPath(dirName))) {
                    result = CVSProject.adminPathToRootPath(dirName);
                    break;
                }
                Object[] fmtArgs = new String[]{fileName, dirName};
                String msg = ResourceMgr.getInstance().getUIFormat("project.select.verify.failed.msg", fmtArgs);
                String title = ResourceMgr.getInstance().getUIString("project.select.verify.failed.title");
                JOptionPane.showMessageDialog(parent, msg, title, 0);
                continue;
            }
            String msg = ResourceMgr.getInstance().getUIString("project.select.help.msg");
            String title = ResourceMgr.getInstance().getUIString("project.select.help.title");
            JOptionPane.showMessageDialog(parent, msg, title, 1);
        }
        return result;
    }

    public void processUnknownFiles(String cvsCommandSpec) {
        Vector unks = new Vector();
        Vector mods = new Vector();
        Vector adds = new Vector();
        Vector rems = new Vector();
        CVSIgnore ignore = new CVSIgnore();
        Config cfg = Config.getInstance();
        UserPrefs prefs = cfg.getPreferences();
        String userIgnores = prefs.getProperty("global.userIgnores", null);
        this.project.checkReleaseStatus(ignore, mods, adds, rems, unks);
        if (unks.size() > 0) {
            String root = this.project.getLocalRootDirectory();
            if (root == null) {
                return;
            }
            char ch = (root = root.trim()).charAt(root.length() - 1);
            if (ch != '/' && ch != '\\' && ch != File.separatorChar) {
                root = root + File.separatorChar;
            }
            int size = unks.size();
            Vector<File> unkFiles = new Vector<File>();
            int i = 0;
            while (i < size) {
                File f;
                String nextStr = (String)unks.elementAt(i);
                if (nextStr.startsWith("./")) {
                    nextStr = nextStr.substring(2, nextStr.length());
                }
                if ((f = new File(root + nextStr)).exists() && !f.isDirectory()) {
                    unkFiles.add(f);
                }
                ++i;
            }
            if (unkFiles.size() > 0) {
                UnknownFilesDialog dialog = new UnknownFilesDialog((Frame)this, unkFiles, this.getTitle(), false);
                if (dialog.isCancelAction()) {
                    this.showFeedback("User cancelled.");
                } else {
                    File[] array = dialog.selectFiles();
                    if (array.length == 0) {
                        this.showFeedback("No selection to operate on.");
                    } else if (dialog.isDeleteAction()) {
                        int i2 = 0;
                        while (i2 < array.length) {
                            String msg;
                            if (array[i2].delete()) {
                                msg = "File " + array[i2].getAbsolutePath() + " deleted.";
                                this.showFeedback(msg);
                            } else {
                                msg = "Failed to delete file " + array[i2].getAbsolutePath() + ".";
                                this.showFeedback(msg);
                            }
                            ++i2;
                        }
                        this.showFeedback("Finished deleting selected unknown files.");
                    } else if (dialog.isAddAction()) {
                        CVSEntryVector entries = new CVSEntryVector();
                        int i3 = 0;
                        while (i3 < array.length) {
                            CVSEntry tempEntry = this.toCVSEntry(array[i3]);
                            if (tempEntry != null) {
                                entries.appendEntry(tempEntry);
                            }
                            ++i3;
                        }
                        this.commonCVSCommand(cvsCommandSpec, entries, null);
                    }
                }
            }
        } else {
            String msg = ResourceMgr.getInstance().getUIString("project.no.unknowns.msg");
            String title = ResourceMgr.getInstance().getUIString("project.no.unknowns.title");
            JOptionPane.showMessageDialog(this, msg, title, 1);
        }
    }

    public void processUnknownDirs() {
        Vector unks = new Vector();
        Vector mods = new Vector();
        Vector adds = new Vector();
        Vector rems = new Vector();
        CVSIgnore ignore = new CVSIgnore();
        Config cfg = Config.getInstance();
        UserPrefs prefs = cfg.getPreferences();
        StringBuffer resultBuffer = new StringBuffer(4096);
        String userIgnores = prefs.getProperty("global.userIgnores", null);
        this.project.checkReleaseStatus(ignore, mods, adds, rems, unks);
        if (unks.size() > 0) {
            String root = this.project.getLocalRootDirectory();
            if (root == null) {
                return;
            }
            char ch = (root = root.trim()).charAt(root.length() - 1);
            if (ch != '/' && ch != '\\' && ch != File.separatorChar) {
                root = root + File.separatorChar;
            }
            int size = unks.size();
            Vector<File> unkDirs = new Vector<File>();
            int i = 0;
            while (i < size) {
                File f;
                String nextStr = (String)unks.elementAt(i);
                if (nextStr.startsWith("./")) {
                    nextStr = nextStr.substring(2, nextStr.length());
                }
                if ((f = new File(root + nextStr)).exists() && f.isDirectory()) {
                    unkDirs.add(f);
                }
                ++i;
            }
            if (unkDirs.size() > 0) {
                UnknownFilesDialog dialog = new UnknownFilesDialog((Frame)this, unkDirs, "Directories in " + this.getTitle(), true);
                if (dialog.isCancelAction()) {
                    this.showFeedback("User cancelled.");
                } else {
                    File[] array = dialog.selectFiles();
                    if (array.length == 0) {
                        this.showFeedback("No selection to operate on.");
                    } else {
                        int i2 = 0;
                        while (i2 < array.length) {
                            String path = array[i2].getPath();
                            if (CVSCUtilities.isSubpathInPath(root, path)) {
                                String dirPath = path.substring(root.length());
                                dirPath = CVSCUtilities.importPath(dirPath);
                                this.addUnknownDirectory(resultBuffer, dirPath);
                            } else {
                                String msg = "Directory " + path + " not under root directory!";
                                resultBuffer.append(msg).append("\n");
                                this.showFeedback(msg);
                            }
                            ++i2;
                        }
                        this.project.writeAdminFiles();
                    }
                }
                if (resultBuffer.length() > 0) {
                    this.ensureOutputAvailable();
                    this.output.setText(resultBuffer.toString());
                    this.output.setVisible(true);
                    this.output.requestFocus();
                }
            }
        } else {
            String msg = ResourceMgr.getInstance().getUIString("project.no.unknowns.msg");
            String title = ResourceMgr.getInstance().getUIString("project.no.unknowns.title");
            JOptionPane.showMessageDialog(this, msg, title, 1);
        }
    }

    protected void addUnknownDirectory(StringBuffer resultBuffer, String dirPath) {
        StringBuffer addPath = new StringBuffer();
        CVSEntry dirEntry = this.project.getRootEntry();
        addPath.append(dirEntry.getLocalDirectory() + dirPath);
        if (addPath.charAt(addPath.length() - 1) != '/') {
            addPath.append("/");
        }
        addPath.append(".");
        CVSResponse result = this.project.ensureRepositoryPath(this, addPath.toString(), new CVSResponse());
        resultBuffer.append(result.getResultText());
    }

    public CVSEntry toCVSEntry(File f) {
        CVSEntry result = null;
        String fileName = f.getName();
        if (fileName != null) {
            String localPath = CVSCUtilities.ensureFinalSlash(CVSCUtilities.importPath(f.getParent()));
            String repos = this.project.getRepository();
            String rootDir = CVSCUtilities.ensureFinalSlash(this.project.getRootDirectory());
            String localRootDir = CVSCUtilities.ensureFinalSlash(this.project.getLocalRootDirectory());
            if (CVSCUtilities.isSubpathInPath(localRootDir, localPath)) {
                String entryLocal = localPath.substring(localRootDir.length());
                String entryRepos = rootDir + repos + "/" + entryLocal;
                entryLocal = CVSCUtilities.ensureFinalSlash("./" + entryLocal);
                result = this.createAddFileEntry(fileName, entryLocal, entryRepos);
            }
        }
        return result;
    }

    private class PJInvoker
    implements Runnable {
        private ActionEvent event;

        public PJInvoker(ActionEvent e) {
            this.event = e;
        }

        public void run() {
            ProjectFrame.this.actionPerformed(this.event);
        }
    }

    private class MyMonitor
    implements CVSThread.Monitor {
        private CVSRequest request;
        private CVSResponse response;

        public MyMonitor(CVSRequest req, CVSResponse resp) {
            this.request = req;
            this.response = resp;
        }

        public void threadStarted() {
        }

        public void threadCanceled() {
        }

        public void threadFinished() {
            boolean allok = this.response.getStatus() == 0;
            ProjectFrame.this.setUIAvailable(true);
            ProjectFrame.this.resetCursor();
            ProjectFrame.this.entryPanel.repaint(500L);
            if (ProjectFrame.this.releasingProject) {
                if (allok) {
                    ProjectFrame.this.project.releaseProject();
                    SwingUtilities.invokeLater(new Runnable(this){
                        private final /* synthetic */ MyMonitor this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void run() {
                            MyMonitor.access$1000(this.this$1).dispose();
                        }
                    });
                } else {
                    ProjectFrame.this.displayFinalResults(allok);
                    JOptionPane.showMessageDialog(ProjectFrame.this, "The CVS command to release this project failed.", "WARNING", 2);
                }
            } else {
                if (ProjectFrame.this.prettyDiffs) {
                    ProjectFrame.this.displayPrettyDiffs(allok);
                } else {
                    ProjectFrame.this.displayFinalResults(allok);
                }
                if (this.request.isRedirected()) {
                    this.request.endRedirection();
                }
            }
        }

        static /* synthetic */ ProjectFrame access$1000(MyMonitor x0) {
            return x0.ProjectFrame.this;
        }
    }

    private class MyRunner
    implements Runnable {
        private CVSRequest request;
        private CVSResponse response;

        public MyRunner(CVSRequest req, CVSResponse resp) {
            this.request = req;
            this.response = resp;
        }

        public void run() {
            boolean fail = false;
            if ("add".equals(this.request.getCommand())) {
                CVSEntry entry = this.request.getEntries().entryAt(0);
                CVSResponse addResponse = ProjectFrame.this.project.ensureRepositoryPath(ProjectFrame.this, entry.getFullName(), this.response);
                if (addResponse.getStatus() != 0) {
                    fail = true;
                    String fdbkStr = ResourceMgr.getInstance().getUIString("project.fdbk.errcreate");
                    ProjectFrame.this.showFeedback(fdbkStr);
                    this.response.appendStderr("An error occurred while creating '" + entry.getFullName() + "'");
                } else {
                    CVSEntry dirEntry = ProjectFrame.this.project.getDirEntryForLocalDir(entry.getLocalDirectory());
                    if (dirEntry == null) {
                        CVSLog.logMsg("ADD FILE COULD NOT FIND PARENT DIRECTORY");
                        CVSLog.logMsg("    locaDirectory = " + entry.getLocalDirectory());
                        new Throwable("COULD NOT FIND THE DIRECTORY!").printStackTrace();
                        fail = true;
                        String fdbkStr = ResourceMgr.getInstance().getUIString("project.fdbk.errcreate");
                        ProjectFrame.this.showFeedback(fdbkStr);
                        this.response.appendStderr("An error occurred while creating '" + entry.getFullName() + "'");
                    } else {
                        this.request.setDirEntry(dirEntry);
                        if (this.request.getEntrySelector() == 10) {
                            entry.setRepository(dirEntry.getRepository());
                        }
                    }
                }
            }
            if (fail || ProjectFrame.this.project.performCVSRequest(this.request, this.response)) {
                // empty if block
            }
        }
    }
}

