/*
 * Decompiled with CFR 0.152.
 */
package com.ice.jcvsii;

import com.ice.cvsc.CVSIgnore;
import com.ice.jcvsii.Config;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.border.TitledBorder;

public class UnknownFilesDialog
extends JDialog {
    JList lstFiles = new JList();
    MyListModel mdlList = new MyListModel();
    JPanel pnlControl = new JPanel();
    JButton btnCancel = new JButton();
    JButton btnDelete = new JButton();
    JButton btnSelectAll = new JButton();
    BorderLayout borderLayout1 = new BorderLayout();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JScrollPane scrlList = new JScrollPane();
    TitledBorder titledBorder1;
    Vector selectedList = new Vector();
    JButton btnAdd = new JButton();
    boolean cancelled = false;
    boolean deleted = false;

    public UnknownFilesDialog(Frame owner, Vector vct, String title, boolean dirs) {
        super(owner, title, true);
        try {
            this.jbInit(dirs);
            this.setData(vct);
            super.setDefaultCloseOperation(0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setData(Vector data) {
        this.selectedList.clear();
        this.mdlList.setData(data);
    }

    private void jbInit(boolean dirs) throws Exception {
        this.titledBorder1 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140)), "Unknown Files");
        this.getContentPane().setLayout(this.borderLayout1);
        this.btnCancel.setText("Cancel");
        this.btnCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UnknownFilesDialog.this.btnCancelActionPerformed(e);
            }
        });
        if (!dirs) {
            this.btnDelete.setFont(new Font("Dialog", 1, 12));
            this.btnDelete.setForeground(Color.red);
            this.btnDelete.setText("Delete");
            this.btnDelete.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    UnknownFilesDialog.this.btnDeleteActionPerformed(e);
                }
            });
        }
        this.pnlControl.setLayout(this.gridBagLayout1);
        this.pnlControl.setBorder(BorderFactory.createEtchedBorder());
        this.btnSelectAll.setText("Select All");
        this.btnSelectAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UnknownFilesDialog.this.btnSelectAllActionPerformed(e);
            }
        });
        this.scrlList.setBorder(this.titledBorder1);
        this.btnAdd.setFont(new Font("Dialog", 1, 12));
        this.btnAdd.setForeground(Color.blue);
        this.btnAdd.setText("Add to project");
        this.btnAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UnknownFilesDialog.this.btnAddActionPerformed(e);
            }
        });
        this.getContentPane().add((Component)this.pnlControl, "South");
        this.pnlControl.add((Component)this.btnSelectAll, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.pnlControl.add((Component)this.btnCancel, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 10, 5, 5), 0, 0));
        if (!dirs) {
            this.pnlControl.add((Component)this.btnDelete, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 10, 5, 10), 0, 0));
        }
        this.pnlControl.add((Component)this.btnAdd, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 10, 5, 0), 0, 0));
        this.getContentPane().add((Component)this.scrlList, "Center");
        this.scrlList.getViewport().add((Component)this.lstFiles, null);
        this.lstFiles.setModel(this.mdlList);
        this.lstFiles.setCellRenderer(new MyCellRenderer());
        this.lstFiles.addMouseListener(new MyEditEventListener());
    }

    private void btnCancelActionPerformed(ActionEvent e) {
        this.cancelled = true;
        this.selectedList.clear();
        super.dispose();
    }

    private void btnSelectAllActionPerformed(ActionEvent e) {
        this.mdlList.selectAllItems();
    }

    private void btnDeleteActionPerformed(ActionEvent e) {
        this.deleted = true;
        this.dispose();
    }

    private void btnAddActionPerformed(ActionEvent e) {
        this.deleted = false;
        this.dispose();
    }

    public boolean isCancelAction() {
        return this.cancelled;
    }

    public boolean isAddAction() {
        return !this.deleted;
    }

    public boolean isDeleteAction() {
        return this.deleted;
    }

    public void dispose() {
        this.selectedList.clear();
        Enumeration enumeration = this.mdlList.elements();
        while (enumeration.hasMoreElements()) {
            MyItem item = (MyItem)enumeration.nextElement();
            if (!item.isSelected) continue;
            this.selectedList.add(item.file);
        }
        super.dispose();
    }

    public void show() {
        this.deleted = false;
        this.cancelled = false;
        super.pack();
        Dimension s = this.getSize();
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        if (s.height > d.height) {
            s.height = d.height;
        }
        if (s.width > d.width) {
            s.width = d.width;
        }
        this.setLocation((d.width - s.width) / 2, (d.height - s.height) / 2);
        super.show();
    }

    public File[] selectFiles() {
        this.show();
        File[] array = new File[this.selectedList.size()];
        int i = 0;
        while (i < array.length) {
            array[i] = (File)this.selectedList.elementAt(i);
            ++i;
        }
        return array;
    }

    private class MyItem {
        String label = null;
        boolean isSelected = false;
        File file = null;

        public MyItem(File newFile) {
            this.label = newFile.getAbsolutePath();
            this.file = newFile;
        }
    }

    private class MyListModel
    extends AbstractListModel {
        Vector listItems = new Vector();
        CVSIgnore ignore = new CVSIgnore();

        public MyListModel() {
            this.ignore.addIgnoreSpec(Config.getPreferences().getProperty("global.userIgnores", null));
        }

        public void setData(Vector ukns) {
            this.listItems.clear();
            if (ukns != null && ukns.size() > 0) {
                int i = 0;
                while (i < ukns.size()) {
                    File f;
                    Object obj = ukns.elementAt(i);
                    if (obj != null && obj instanceof File && !this.ignore.isFileToBeIgnored((f = (File)obj).getName())) {
                        this.listItems.add(new MyItem(f));
                    }
                    ++i;
                }
            }
            this.fireContentsChanged(this, 0, 1);
        }

        public int getSize() {
            return this.listItems.size();
        }

        public void toggleItemAt(int index) {
            if (index > -1 && index < this.listItems.size()) {
                MyItem item = (MyItem)this.listItems.elementAt(index);
                item.isSelected = !item.isSelected;
                this.fireContentsChanged(this, index, index);
            }
        }

        public void selectAllItems() {
            int size = this.listItems.size();
            int i = 0;
            while (i < size) {
                ((MyItem)this.listItems.elementAt((int)i)).isSelected = true;
                ++i;
            }
            this.fireContentsChanged(this, 0, size - 1);
        }

        public Object getElementAt(int i) {
            int size = this.getSize();
            if (i < 0 || i >= size) {
                return null;
            }
            return this.listItems.elementAt(i);
        }

        public boolean addElement(Object o) {
            this.addElementAt(o, this.listItems.size());
            return true;
        }

        public void addElementAt(Object obj, int pos) {
            if (obj != null && obj instanceof File) {
                this.listItems.add(pos, new MyItem((File)obj));
                this.fireContentsChanged(this, pos, pos + 1);
            }
        }

        public Object deleteElementAt(int i) {
            if (this.listItems.size() == 0) {
                return null;
            }
            Object ret = this.listItems.remove(i);
            this.fireContentsChanged(this, i, i + 1);
            return ret;
        }

        public boolean containsElement(Object obj) {
            int i = this.listItems.indexOf(obj);
            return i >= 0;
        }

        public Object deleteElement(Object obj) {
            if (this.listItems.size() == 0) {
                return null;
            }
            this.listItems.remove(obj);
            this.fireContentsChanged(this, 0, this.listItems.size());
            return obj;
        }

        public Enumeration elements() {
            return this.listItems.elements();
        }
    }

    private class MyCellRenderer
    extends JCheckBox
    implements ListCellRenderer {
        Color selColor = new Color(208, 224, 240);

        public MyCellRenderer() {
            this.setOpaque(true);
            this.setBorder(null);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof MyItem) {
                boolean sel = ((MyItem)value).isSelected;
                this.setSelected(sel);
                this.setText(((MyItem)value).label);
                this.setBackground(sel ? this.selColor : Color.white);
                this.setForeground(Color.black);
                return this;
            }
            return null;
        }
    }

    private class MyEditEventListener
    extends MouseAdapter {
        private MyEditEventListener() {
        }

        public void mouseReleased(MouseEvent e) {
            UnknownFilesDialog.this.mdlList.toggleItemAt(UnknownFilesDialog.this.lstFiles.locationToIndex(e.getPoint()));
        }
    }
}

