/*
 * Decompiled with CFR 0.152.
 */
package com.ice.jcvsii;

import com.ice.jni.dde.DDEException;
import com.ice.jni.dde.JNIDDE;
import java.io.IOException;
import javax.activation.CommandObject;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.swing.JOptionPane;

public class Win32Viewer
implements CommandObject {
    private boolean debug = false;

    public void setCommandContext(String verb, DataHandler dh) throws IOException {
        this.viewContent(verb, dh);
    }

    public void viewContent(String verb, DataHandler dh) {
        DataSource ds = dh.getDataSource();
        if (!(ds instanceof FileDataSource)) {
            return;
        }
        FileDataSource fds = (FileDataSource)ds;
        try {
            JNIDDE dde = new JNIDDE();
            String fileName = fds.getFile().getPath();
            String execDir = System.getProperty("user.dir", "");
            if (this.debug) {
                System.err.println("Win32Shell: Verb = '" + verb + "' Filename = '" + fileName + "'");
            }
            JNIDDE.shellExecute(verb, fileName, null, execDir, 1);
        }
        catch (UnsatisfiedLinkError er) {
            String msg = "It appears that you have not installed the\nWindows DDE native library, 'ICE_JNIDDE.dll'.\nConsult the documentation about Win32 installation.\n\n" + er.getMessage() + "\n";
            JOptionPane.showMessageDialog(null, msg, "Error", 0);
        }
        catch (DDEException ex) {
            String msg = "Win32Viewer had trouble with the DDE communications.\nThe most likely reason is that you have not defined an\naction for the verb '" + verb + "'.\n" + "Consult the documentation about Win32 installation.\n" + "\n" + ex.getMessage() + "\n";
            JOptionPane.showMessageDialog(null, msg, "Error", 0);
        }
    }
}

