/*
 * Decompiled with CFR 0.152.
 */
package com.ice.jcvsii;

import com.ice.jcvsii.WorkBenchDefinition;
import com.ice.jcvsii.WorkBenchTreeNode;
import com.ice.pref.UserPrefs;
import javax.swing.tree.DefaultTreeModel;

public class WorkBenchTreeModel
extends DefaultTreeModel {
    public WorkBenchTreeModel(WorkBenchTreeNode rootNode) {
        super(rootNode);
    }

    public void saveWorkBench(UserPrefs prefs) {
        WorkBenchTreeNode rootNode = (WorkBenchTreeNode)this.getRoot();
        this.recursiveSave(prefs, rootNode);
    }

    public void recursiveSave(UserPrefs prefs, WorkBenchTreeNode rootNode) {
        String propName = "wb." + rootNode.getDefinition().getFullPath();
        WorkBenchDefinition def = rootNode.getDefinition();
        prefs.setBoolean(propName + ".isleaf", !def.isFolder());
        prefs.setProperty(propName + ".name", def.getDisplayName());
        prefs.setProperty(propName + ".desc", def.getDescription());
        if (!def.isFolder()) {
            prefs.setProperty(propName + ".local", def.getLocalDirectory());
        } else {
            WorkBenchTreeNode[] childs = rootNode.getChildren();
            prefs.setTokens(propName + ".children", this.getChildTokens(childs));
            int i = 0;
            while (i < childs.length) {
                this.recursiveSave(prefs, childs[i]);
                ++i;
            }
        }
    }

    public void fireTreeChanged() {
        WorkBenchTreeNode rootNode = (WorkBenchTreeNode)this.getRoot();
        this.fireTreeStructureChanged(rootNode, rootNode.getPath(), null, null);
    }

    public void loadWorkBench(UserPrefs prefs) {
        WorkBenchTreeNode rootNode = (WorkBenchTreeNode)this.getRoot();
        this.recursiveLoad(prefs, rootNode);
        this.fireTreeStructureChanged(rootNode, rootNode.getPath(), null, null);
    }

    public void recursiveLoad(UserPrefs prefs, WorkBenchTreeNode rootNode) {
        String rootPath = rootNode.getDefinition().getFullPath();
        String propName = "wb." + rootPath;
        String[] chNames = prefs.getTokens(propName + ".children", new String[0]);
        int i = 0;
        while (i < chNames.length) {
            WorkBenchTreeNode newNode;
            WorkBenchDefinition childDef;
            String localRoot;
            String name = chNames[i];
            propName = "wb." + rootPath + "." + name;
            boolean isFolder = !prefs.getBoolean(propName + ".isleaf", true);
            String display = prefs.getProperty(propName + ".name", null);
            String desc = prefs.getProperty(propName + ".desc", null);
            String string = localRoot = isFolder ? null : prefs.getProperty(propName + ".local", null);
            if (display == null || desc == null || !isFolder && localRoot == null) {
                new Throwable("loadWorkBench: path '" + propName + "' appears corrupted.").printStackTrace();
            } else if (isFolder) {
                childDef = new WorkBenchDefinition(name, rootPath, display, desc);
                newNode = new WorkBenchTreeNode(childDef);
                rootNode.add(newNode);
                this.recursiveLoad(prefs, newNode);
            } else {
                childDef = new WorkBenchDefinition(name, rootPath, display, desc, localRoot);
                newNode = new WorkBenchTreeNode(childDef);
                rootNode.add(newNode);
            }
            ++i;
        }
    }

    private String[] getChildTokens(WorkBenchTreeNode[] childs) {
        String[] result = new String[childs.length];
        int i = 0;
        while (i < childs.length) {
            result[i] = childs[i].getDefinition().getName();
            ++i;
        }
        return result;
    }
}

