/*
 * Decompiled with CFR 0.152.
 */
package com.ice.pref;

import com.ice.util.StringUtilities;
import java.util.Vector;

public class PrefsTuple {
    protected String key = null;
    protected String[] values = null;

    private PrefsTuple() {
    }

    public PrefsTuple(String key, String[] values) {
        this.key = key;
        this.values = values;
    }

    public PrefsTuple(String key, Vector values) {
        this.key = key;
        this.values = new String[values.size()];
        values.copyInto(this.values);
    }

    public boolean equals(PrefsTuple that) {
        if (!this.key.equals(that.key)) {
            return false;
        }
        if (this.values.length != that.values.length) {
            return false;
        }
        int i = 0;
        while (i < this.values.length) {
            if (!this.values[i].equals(that.values[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String getKey() {
        return this.key;
    }

    public String[] getValues() {
        return this.values;
    }

    public void setValues(String[] values) {
        this.values = values;
    }

    public String getValueAt(int idx) {
        return this.values[idx];
    }

    public void setValueAt(String value, int idx) {
        this.values[idx] = value;
    }

    public int length() {
        return this.values == null ? 0 : this.values.length;
    }

    public String toString() {
        return "PrefsTuple[key=" + this.key + ", values=[" + StringUtilities.join(this.values, ",") + "]]";
    }
}

